/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.router;

import java.util.List;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.MetaData;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.client.impl.router.RouterImpl;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedRoundRobinRouter
extends RouterImpl {
    private int lastSelectedPeer = -1;
    private int currentWeight = 0;

    protected WeightedRoundRobinRouter(IRealmTable table, Configuration config) {
        super(null, null, table, config, null);
    }

    public WeightedRoundRobinRouter(IContainer container, IConcurrentFactory concurrentFactory, IRealmTable realmTable, Configuration config, MetaData aMetaData) {
        super(container, concurrentFactory, realmTable, config, aMetaData);
    }

    @Override
    public IPeer selectPeer(List<IPeer> availablePeers) {
        int peerSize;
        int n = peerSize = availablePeers != null ? availablePeers.size() : 0;
        if (peerSize <= 0) {
            return null;
        }
        if (peerSize == 1) {
            return availablePeers.iterator().next();
        }
        int maxWeight = 0;
        Integer gcd = null;
        for (IPeer peer : availablePeers) {
            maxWeight = Math.max(maxWeight, peer.getRating());
            gcd = gcd == null ? peer.getRating() : this.gcd(gcd, peer.getRating());
        }
        WeightedRoundRobinRouter weightedRoundRobinRouter = this;
        synchronized (weightedRoundRobinRouter) {
            while (true) {
                this.lastSelectedPeer = (this.lastSelectedPeer + 1) % peerSize;
                if (this.lastSelectedPeer == 0) {
                    this.currentWeight -= gcd.intValue();
                    if (this.currentWeight <= 0) {
                        this.currentWeight = maxWeight;
                    }
                }
                if (peerSize <= this.lastSelectedPeer) {
                    this.lastSelectedPeer = -1;
                    continue;
                }
                IPeer candidate = availablePeers.get(this.lastSelectedPeer);
                if (candidate.getRating() >= this.currentWeight) break;
            }
            return availablePeers.get(this.lastSelectedPeer);
        }
    }

    protected int gcd(int a, int b) {
        return b == 0 ? a : this.gcd(b, a % b);
    }
}

