/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.router;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.Configuration;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.LocalAction;
import org.jdiameter.api.Message;
import org.jdiameter.api.MetaData;
import org.jdiameter.api.PeerState;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.URI;
import org.jdiameter.client.api.IAnswer;
import org.jdiameter.client.api.IContainer;
import org.jdiameter.client.api.IMessage;
import org.jdiameter.client.api.IRequest;
import org.jdiameter.client.api.controller.IPeer;
import org.jdiameter.client.api.controller.IPeerTable;
import org.jdiameter.client.api.controller.IRealm;
import org.jdiameter.client.api.controller.IRealmTable;
import org.jdiameter.client.api.router.IRouter;
import org.jdiameter.client.impl.helpers.AppConfiguration;
import org.jdiameter.client.impl.helpers.Parameters;
import org.jdiameter.client.impl.parser.MessageImpl;
import org.jdiameter.common.api.concurrent.IConcurrentFactory;
import org.jdiameter.server.api.agent.IAgentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterImpl
implements IRouter {
    public static final int DONT_CACHE = 0;
    public static final int ALL_SESSION = 1;
    public static final int ALL_REALM = 2;
    public static final int REALM_AND_APPLICATION = 3;
    public static final int ALL_APPLICATION = 4;
    public static final int ALL_HOST = 5;
    public static final int ALL_USER = 6;
    private static final Logger logger = LoggerFactory.getLogger(RouterImpl.class);
    protected MetaData metaData;
    protected IRealmTable realmTable;
    public final int REDIRECT_TABLE_SIZE = 1024;
    protected List<RedirectEntry> redirectTable = new ArrayList<RedirectEntry>(1024);
    protected IConcurrentFactory concurrentFactory;
    protected IContainer container;
    public static int REQUEST_TABLE_SIZE = 10240;
    public static int REQUEST_TABLE_CLEAR_SIZE = 2048;
    protected Lock requestEntryTableLock = new ReentrantLock();
    protected ReadWriteLock redirectTableLock = new ReentrantReadWriteLock();
    protected Map<String, AnswerEntry> requestEntryMap;
    protected boolean isStopped = true;

    public RouterImpl(IContainer container, IConcurrentFactory concurrentFactory, IRealmTable realmTable, Configuration config, MetaData aMetaData) {
        this.concurrentFactory = concurrentFactory;
        this.metaData = aMetaData;
        this.realmTable = realmTable;
        this.container = container;
        logger.debug("Constructor for RouterImpl: Calling loadConfiguration");
        this.loadConfiguration(config);
    }

    protected void loadConfiguration(Configuration config) {
        logger.debug("Loading Router Configuration. Populating Realms, Application IDs, etc");
        String localRealm = config.getStringValue(Parameters.OwnRealm.ordinal(), null);
        String localHost = config.getStringValue(Parameters.OwnDiameterURI.ordinal(), null);
        try {
            this.realmTable.addLocalRealm(localRealm, new URI(localHost).getFQDN());
        }
        catch (UnknownServiceException use) {
            throw new RuntimeException("Unable to create URI from Own URI config value:" + localHost, use);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException("Unable to create URI from Own URI config value:" + localHost, use);
        }
        if (config.getChildren(org.jdiameter.server.impl.helpers.Parameters.RequestTable.ordinal()) != null) {
            int tSize;
            AppConfiguration requestTableConfig = (AppConfiguration)config.getChildren(org.jdiameter.server.impl.helpers.Parameters.RequestTable.ordinal())[0];
            int tClearSize = requestTableConfig.getIntValue(org.jdiameter.server.impl.helpers.Parameters.RequestTableClearSize.ordinal(), (Integer)org.jdiameter.server.impl.helpers.Parameters.RequestTableClearSize.defValue());
            if (tSize > 0 && tClearSize >= tSize) {
                logger.warn("Configuration entry RequestTable, attribute 'clear_size' [{}] should not be greater than 'size' [{}]. Adjusting.", (Object)tSize, (Object)tClearSize);
                for (tSize = requestTableConfig.getIntValue(org.jdiameter.server.impl.helpers.Parameters.RequestTableSize.ordinal(), (Integer)org.jdiameter.server.impl.helpers.Parameters.RequestTableSize.defValue()); tClearSize >= tSize; tSize *= 10) {
                }
            }
            REQUEST_TABLE_SIZE = tSize;
            REQUEST_TABLE_CLEAR_SIZE = tClearSize;
        }
        this.requestEntryMap = new ConcurrentHashMap<String, AnswerEntry>(REQUEST_TABLE_SIZE);
        logger.debug("Configured Request Table with size[{}] and clear size[{}].", (Object)REQUEST_TABLE_SIZE, (Object)REQUEST_TABLE_CLEAR_SIZE);
        if (config.getChildren(Parameters.RealmTable.ordinal()) != null) {
            logger.debug("Going to loop through configured realms and add them into a network map");
            for (Configuration items : config.getChildren(Parameters.RealmTable.ordinal())) {
                Configuration[] m;
                if (items == null) continue;
                for (Configuration c : m = items.getChildren(Parameters.RealmEntry.ordinal())) {
                    try {
                        String name = c.getStringValue(org.jdiameter.server.impl.helpers.Parameters.RealmName.ordinal(), "");
                        logger.debug("Getting config for realm [{}]", (Object)name);
                        ApplicationId appId = null;
                        Configuration[] apps = c.getChildren(Parameters.ApplicationId.ordinal());
                        if (apps != null) {
                            for (Configuration a : apps) {
                                if (a == null) continue;
                                long vnd = a.getLongValue(Parameters.VendorId.ordinal(), 0L);
                                long auth = a.getLongValue(Parameters.AuthApplId.ordinal(), 0L);
                                long acc = a.getLongValue(Parameters.AcctApplId.ordinal(), 0L);
                                appId = auth != 0L ? ApplicationId.createByAuthAppId((long)vnd, (long)auth) : ApplicationId.createByAccAppId((long)vnd, (long)acc);
                                if (!logger.isDebugEnabled()) break;
                                logger.debug("Realm [{}] has application Acct [{}] Auth [{}] Vendor [{}]", new Object[]{name, appId.getAcctAppId(), appId.getAuthAppId(), appId.getVendorId()});
                                break;
                            }
                        }
                        String[] hosts = c.getStringValue(org.jdiameter.server.impl.helpers.Parameters.RealmHosts.ordinal(), (String)org.jdiameter.server.impl.helpers.Parameters.RealmHosts.defValue()).split(",");
                        logger.debug("Adding realm [{}] with hosts [{}] to network map", (Object)name, (Object)hosts);
                        LocalAction locAction = LocalAction.valueOf((String)c.getStringValue(org.jdiameter.server.impl.helpers.Parameters.RealmLocalAction.ordinal(), "0"));
                        boolean isDynamic = c.getBooleanValue(org.jdiameter.server.impl.helpers.Parameters.RealmEntryIsDynamic.ordinal(), false);
                        long expirationTime = c.getLongValue(org.jdiameter.server.impl.helpers.Parameters.RealmEntryExpTime.ordinal(), 0L);
                        IAgentConfiguration agentConfImpl = null;
                        Configuration[] confs = c.getChildren(Parameters.Agent.ordinal());
                        if (confs != null && confs.length > 0) {
                            Configuration agentConfiguration = confs[0];
                            agentConfImpl = this.container.getAssemblerFacility().getComponentInstance(IAgentConfiguration.class);
                            if (agentConfImpl != null) {
                                agentConfImpl = agentConfImpl.parse(agentConfiguration);
                            }
                        }
                        this.realmTable.addRealm(name, appId, locAction, agentConfImpl, isDynamic, expirationTime, hosts);
                    }
                    catch (Exception e) {
                        logger.warn("Unable to append realm entry", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerRequestRouteInfo(IRequest request) {
        logger.debug("Entering registerRequestRouteInfo");
        if (REQUEST_TABLE_SIZE == 0) {
            return;
        }
        try {
            long hopByHopId = request.getHopByHopIdentifier();
            Avp hostAvp = request.getAvps().getAvp(264);
            Avp realmAvp = request.getAvps().getAvp(296);
            AnswerEntry entry = new AnswerEntry(hopByHopId, hostAvp != null ? hostAvp.getDiameterIdentity() : null, realmAvp != null ? realmAvp.getDiameterIdentity() : null);
            int s = this.requestEntryMap.size();
            logger.debug("RequestRoute map size is [{}]", (Object)s);
            if (s > REQUEST_TABLE_CLEAR_SIZE) {
                try {
                    this.requestEntryTableLock.lock();
                    s = this.requestEntryMap.size();
                    logger.debug("After 'lock', RequestRoute map size is [{}]", (Object)s);
                    if (s > REQUEST_TABLE_SIZE) {
                        logger.warn("RequestRoute map size is [{}]. There's probably a leak. Cleaning up after a short wait...", (Object)s);
                        Thread.sleep(5000L);
                        logger.warn("RequestRoute map size is now [{}] after sleeping. Clearing it!", (Object)this.requestEntryMap.size());
                        this.requestEntryMap.clear();
                    }
                }
                catch (Exception e) {
                    logger.warn("Failure trying to clear RequestRoute map", (Throwable)e);
                }
                finally {
                    this.requestEntryTableLock.unlock();
                }
            }
            String messageKey = this.makeRoutingKey((Message)request);
            logger.debug("Adding request key [{}] to RequestRoute map for routing answers back to the requesting peer", (Object)messageKey);
            this.requestEntryMap.put(messageKey, entry);
        }
        catch (Exception e) {
            logger.warn("Unable to store route info", (Throwable)e);
        }
    }

    private String makeRoutingKey(Message message) {
        String sessionId = message.getSessionId();
        return (sessionId != null ? sessionId : "null") + message.getEndToEndIdentifier() + message.getHopByHopIdentifier();
    }

    @Override
    public String[] getRequestRouteInfo(IMessage message) {
        if (REQUEST_TABLE_SIZE == 0) {
            return ((MessageImpl)message).getRoutingInfo();
        }
        String messageKey = this.makeRoutingKey((Message)message);
        AnswerEntry ans = this.requestEntryMap.get(messageKey);
        if (ans != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getRequestRouteInfo found host [{}] and realm [{}] for Message key Id [{}]", new Object[]{ans.getHost(), ans.getRealm(), messageKey});
            }
            return new String[]{ans.getHost(), ans.getRealm()};
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Could not find route info for message key [{}]. Table size is [{}]", (Object)messageKey, (Object)this.requestEntryMap.size());
        }
        return null;
    }

    @Override
    public void garbageCollectRequestRouteInfo(IMessage message) {
        if (REQUEST_TABLE_SIZE == 0) {
            return;
        }
        String messageKey = this.makeRoutingKey((Message)message);
        this.requestEntryMap.remove(messageKey);
    }

    @Override
    public IPeer getPeer(IMessage message, IPeerTable manager) throws RouteException, AvpDataException {
        IPeer peer;
        IPeer c;
        logger.debug("Getting a peer for message [{}]", (Object)message);
        String destRealm = null;
        String destHost = null;
        IRealm matchedRealm = null;
        String[] info = null;
        if (message.isRequest()) {
            Avp avpRealm = message.getAvps().getAvp(283);
            if (avpRealm == null) {
                throw new RouteException("Destination realm avp is empty");
            }
            destRealm = avpRealm.getDiameterIdentity();
            Avp avpHost = message.getAvps().getAvp(293);
            if (avpHost != null) {
                destHost = avpHost.getDiameterIdentity();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Looking up peer for request: [{}], DestHost=[{}], DestRealm=[{}]", new Object[]{message, destHost, destRealm});
            }
            matchedRealm = (IRealm)this.realmTable.matchRealm(message);
        } else {
            info = this.getRequestRouteInfo(message);
            if (info != null) {
                destHost = info[0];
                destRealm = info[1];
                logger.debug("Message is an answer. Host is [{}] and Realm is [{}] as per hopbyhop info from request", (Object)destHost, (Object)destRealm);
                if (destRealm == null) {
                    logger.warn("Destination-Realm was null for hopbyhop id " + message.getHopByHopIdentifier());
                }
            } else {
                logger.debug("No Host and realm found based on hopbyhop id of the answer associated request");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Looking up peer for answer: [{}], DestHost=[{}], DestRealm=[{}]", new Object[]{message, destHost, destRealm});
            }
            matchedRealm = (IRealm)this.realmTable.matchRealm(message, destRealm);
        }
        if (matchedRealm == null) {
            throw new RouteException("Unknown realm name [" + destRealm + "]");
        }
        if (message.getPeer() != null && destHost != null && destHost.equals(message.getPeer().getUri().getFQDN()) && message.getPeer().hasValidConnection()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Select previous message usage peer [{}]", (Object)message.getPeer());
            }
            return message.getPeer();
        }
        IPeer iPeer = c = destHost != null ? manager.getPeer(destHost) : null;
        if (c != null && c.hasValidConnection()) {
            logger.debug("Found a peer using destination host avp [{}] peer is [{}] with a valid connection.", (Object)destHost, (Object)c);
            return c;
        }
        logger.debug("Finding peer by destination host avp [host={}] did not find anything. Now going to try finding one by destination realm [{}]", (Object)destHost, (Object)destRealm);
        String[] peers = matchedRealm.getPeerNames();
        if (peers == null || peers.length == 0) {
            throw new RouteException("Unable to find context by route information [" + destRealm + " ," + destHost + "]");
        }
        ArrayList<IPeer> availablePeers = new ArrayList<IPeer>(5);
        logger.debug("Looping through peers in realm [{}]", (Object)destRealm);
        for (String peerName : peers) {
            IPeer localPeer = manager.getPeer(peerName);
            if (logger.isDebugEnabled()) {
                logger.debug("Checking peer [{}] for name [{}]", new Object[]{localPeer, peerName});
            }
            if (localPeer == null || localPeer.getState(PeerState.class) != PeerState.OKAY) continue;
            if (localPeer.hasValidConnection()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found available peer to add to available peer list with uri [{}] with a valid connection", (Object)localPeer.getUri().toString());
                }
                availablePeers.add(localPeer);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Found a peer with uri [{}] with no valid connection", (Object)localPeer.getUri());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Performing Realm routing. Realm [{}] has the following peers available [{}] from list [{}]", new Object[]{destRealm, availablePeers, Arrays.asList(peers)});
        }
        if ((peer = this.selectPeer(availablePeers)) == null) {
            throw new RouteException("Unable to find valid connection to peer[" + destHost + "] in realm[" + destRealm + "]");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Load balancing selected peer with uri [{}]", (Object)peer.getUri());
        }
        return peer;
    }

    @Override
    public IRealmTable getRealmTable() {
        return this.realmTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRedirectAnswer(IRequest request, IAnswer answer, IPeerTable table) throws InternalException, RouteException {
        try {
            Avp destinationRealmAvp = request.getAvps().getAvp(283);
            if (destinationRealmAvp == null) {
                throw new RouteException("Request to be routed has no Destination-Realm AVP!");
            }
            String destinationRealm = destinationRealmAvp.getDiameterIdentity();
            String[] redirectHosts = null;
            if (answer.getAvps().getAvps(292) != null) {
                AvpSet avps = answer.getAvps().getAvps(292);
                redirectHosts = new String[avps.size()];
                int i = 0;
                for (Avp avp : avps) {
                    String r = avp.getDiameterIdentity();
                    if (r.equals(this.metaData.getLocalPeer().getUri().getFQDN())) {
                        throw new RouteException("Loop detected");
                    }
                    redirectHosts[i++] = r;
                }
            }
            int redirectUsage = 0;
            Avp redirectHostUsageAvp = answer.getAvps().getAvp(261);
            if (redirectHostUsageAvp != null) {
                redirectUsage = redirectHostUsageAvp.getInteger32();
            }
            if (redirectUsage != 0) {
                long redirectCacheTime = 0L;
                Avp redirectCacheMaxTimeAvp = answer.getAvps().getAvp(262);
                if (redirectCacheMaxTimeAvp != null) {
                    redirectCacheTime = redirectCacheMaxTimeAvp.getUnsigned32();
                }
                String primaryKey = null;
                ApplicationId secondaryKey = null;
                switch (redirectUsage) {
                    case 1: {
                        primaryKey = request.getSessionId();
                        break;
                    }
                    case 2: {
                        primaryKey = destinationRealm;
                        break;
                    }
                    case 3: {
                        primaryKey = destinationRealm;
                        secondaryKey = ((IMessage)request).getSingleApplicationId();
                        break;
                    }
                    case 4: {
                        secondaryKey = ((IMessage)request).getSingleApplicationId();
                        break;
                    }
                    case 5: {
                        Avp destinationHostAvp = request.getAvps().getAvp(293);
                        if (destinationHostAvp == null) {
                            throw new RouteException("Request to be routed has no Destination-Host AVP!");
                        }
                        primaryKey = destinationHostAvp.getDiameterIdentity();
                        break;
                    }
                    case 6: {
                        Avp userNameAvp = answer.getAvps().getAvp(1);
                        if (userNameAvp == null) {
                            throw new RouteException("Request to be routed has no User-Name AVP!");
                        }
                        primaryKey = userNameAvp.getUTF8String();
                    }
                }
                if (this.redirectTable.size() > 1024) {
                    try {
                        this.redirectTableLock.writeLock().lock();
                        this.trimRedirectTable();
                    }
                    finally {
                        this.redirectTableLock.writeLock().unlock();
                    }
                }
                if (1024 > this.redirectTable.size()) {
                    RedirectEntry e = new RedirectEntry(primaryKey, secondaryKey, redirectCacheTime, redirectUsage, redirectHosts, destinationRealm);
                    this.redirectTable.add(e);
                    this.updateRoute(request, e.getRedirectHost());
                } else if (redirectHosts != null && redirectHosts.length > 0) {
                    String destHost = redirectHosts[0];
                    this.updateRoute(request, destHost);
                }
            } else if (redirectHosts != null && redirectHosts.length > 0) {
                String destHost = redirectHosts[0];
                this.updateRoute(request, destHost);
            }
            table.sendMessage((IMessage)request);
        }
        catch (AvpDataException exc) {
            throw new InternalException((Throwable)exc);
        }
        catch (IllegalDiameterStateException e) {
            throw new InternalException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void trimRedirectTable() {
        for (int index = 0; index < this.redirectTable.size(); ++index) {
            try {
                if (this.redirectTable.get(index).getExpiredTime() > System.currentTimeMillis()) continue;
                this.redirectTable.remove(index);
                --index;
                continue;
            }
            catch (Exception e) {
                logger.debug("Error in redirect task cleanup.", (Throwable)e);
                break;
            }
        }
    }

    private void updateRoute(IRequest request, String destHost) {
        request.getAvps().removeAvp(293);
        request.getAvps().addAvp(293, destHost, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateRoute(IRequest message) throws RouteException, AvpDataException {
        AvpSet set = message.getAvps();
        Avp destRealmAvp = set.getAvp(283);
        Avp destHostAvp = set.getAvp(293);
        if (destRealmAvp == null) {
            throw new RouteException("Request does not have Destination-Realm AVP!");
        }
        String destRealm = destRealmAvp.getDiameterIdentity();
        String destHost = destHostAvp != null ? destHostAvp.getDiameterIdentity() : null;
        boolean matchedEntry = false;
        String userName = null;
        String sessionId = message.getSessionId();
        Avp avpUserName = message.getAvps().getAvp(1);
        ApplicationId appId = ((IMessage)message).getSingleApplicationId();
        if (avpUserName != null) {
            userName = avpUserName.getUTF8String();
        }
        try {
            this.redirectTableLock.readLock().lock();
            for (int index = 0; index < this.redirectTable.size(); ++index) {
                RedirectEntry e = this.redirectTable.get(index);
                switch (e.getUsageType()) {
                    case 1: {
                        matchedEntry = sessionId != null && e.primaryKey != null & sessionId.equals(e.primaryKey);
                        break;
                    }
                    case 2: {
                        matchedEntry = destRealm != null && e.primaryKey != null & destRealm.equals(e.primaryKey);
                        break;
                    }
                    case 3: {
                        matchedEntry = destRealm != null & appId != null & e.primaryKey != null & e.secondaryKey != null & destRealm.equals(e.primaryKey) & appId.equals((Object)e.secondaryKey);
                        break;
                    }
                    case 4: {
                        matchedEntry = appId != null & e.secondaryKey != null & appId.equals((Object)e.secondaryKey);
                        break;
                    }
                    case 5: {
                        matchedEntry = destHost != null & e.primaryKey != null & destHost.equals(e.primaryKey);
                        break;
                    }
                    case 6: {
                        matchedEntry = userName != null & e.primaryKey != null & userName.equals(e.primaryKey);
                    }
                }
                if (!matchedEntry) continue;
                String newDestHost = e.getRedirectHost();
                this.updateRoute(message, newDestHost);
                logger.debug("Redirect message from host={}; to new-host={}, realm={} ", new Object[]{destHost, newDestHost, destRealm});
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.redirectTableLock.readLock().unlock();
        }
        return false;
    }

    protected IPeer getPeerPredProcessing(IMessage message, String destRealm, String destHost) {
        return null;
    }

    @Override
    public void start() {
        if (this.isStopped) {
            this.isStopped = false;
        }
    }

    @Override
    public void stop() {
        this.isStopped = true;
        if (this.redirectTable != null) {
            this.redirectTable.clear();
        }
        if (this.requestEntryMap != null) {
            this.requestEntryMap.clear();
        }
    }

    @Override
    public void destroy() {
        try {
            if (!this.isStopped) {
                this.stop();
            }
        }
        catch (Exception exc) {
            logger.error("Unable to stop router", (Throwable)exc);
        }
        this.redirectTable = null;
        this.requestEntryMap = null;
    }

    protected IPeer selectPeer(List<IPeer> availablePeers) {
        IPeer p = null;
        for (IPeer c : availablePeers) {
            if (p != null && c.getRating() < p.getRating()) continue;
            p = c;
        }
        return p;
    }

    protected class AnswerEntry {
        final long createTime = System.nanoTime();
        Long hopByHopId;
        String host;
        String realm;

        public AnswerEntry(Long hopByHopId) {
            this.hopByHopId = hopByHopId;
        }

        public AnswerEntry(Long hopByHopId, String host, String realm) throws InternalError {
            this.hopByHopId = hopByHopId;
            this.host = host;
            this.realm = realm;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public Long getHopByHopId() {
            return this.hopByHopId;
        }

        public String getHost() {
            return this.host;
        }

        public String getRealm() {
            return this.realm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnswerEntry that = (AnswerEntry)o;
            return this.hopByHopId == that.hopByHopId;
        }

        public String toString() {
            return "AnswerEntry{createTime=" + this.createTime + ", hopByHopId=" + this.hopByHopId + '}';
        }
    }

    protected class RedirectEntry {
        final long createTime = System.currentTimeMillis();
        String primaryKey;
        ApplicationId secondaryKey;
        long liveTime;
        int usageType;
        String[] hosts;
        String destinationRealm;

        public RedirectEntry(String key1, ApplicationId key2, long time, int usage, String[] aHosts, String destinationRealm) throws InternalError {
            if (key1 == null && key2 == null) {
                throw new InternalError("Incorrect redirection key.");
            }
            if (aHosts == null || aHosts.length == 0) {
                throw new InternalError("Incorrect redirection hosts.");
            }
            this.primaryKey = key1;
            this.secondaryKey = key2;
            this.liveTime = time * 1000L;
            this.usageType = usage;
            this.hosts = aHosts;
            this.destinationRealm = destinationRealm;
        }

        public int getUsageType() {
            return this.usageType;
        }

        public String[] getRedirectHosts() {
            return this.hosts;
        }

        public String getRedirectHost() {
            return this.hosts[this.hosts.length - 1];
        }

        public long getExpiredTime() {
            return this.createTime + this.liveTime;
        }

        public int hashCode() {
            int result = this.primaryKey != null ? this.primaryKey.hashCode() : 0;
            result = 31 * result + (this.secondaryKey != null ? this.secondaryKey.hashCode() : 0);
            result = 31 * result + (int)(this.liveTime ^ this.liveTime >>> 32);
            result = 31 * result + this.usageType;
            result = 31 * result + (this.hosts != null ? this.hosts.hashCode() : 0);
            return result;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof RedirectEntry) {
                RedirectEntry that = (RedirectEntry)other;
                return this.liveTime == that.liveTime && this.usageType == that.usageType && Arrays.equals(this.hosts, that.hosts) && !(this.primaryKey == null ? that.primaryKey != null : !this.primaryKey.equals(that.primaryKey)) && !(this.secondaryKey == null ? that.secondaryKey != null : !this.secondaryKey.equals((Object)that.secondaryKey));
            }
            return false;
        }
    }
}

