/*
 * Decompiled with CFR 0.152.
 */
package org.jdiameter.client.impl.app.s13;

import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.NetworkReqListener;
import org.jdiameter.api.OverloadException;
import org.jdiameter.api.Request;
import org.jdiameter.api.RouteException;
import org.jdiameter.api.app.AppAnswerEvent;
import org.jdiameter.api.app.AppEvent;
import org.jdiameter.api.app.AppRequestEvent;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.app.StateEvent;
import org.jdiameter.api.s13.ClientS13Session;
import org.jdiameter.api.s13.ClientS13SessionListener;
import org.jdiameter.api.s13.events.JMEIdentityCheckAnswer;
import org.jdiameter.api.s13.events.JMEIdentityCheckRequest;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.s13.Event;
import org.jdiameter.client.impl.app.s13.IClientS13SessionData;
import org.jdiameter.common.api.app.s13.IS13MessageFactory;
import org.jdiameter.common.api.app.s13.S13SessionState;
import org.jdiameter.common.impl.app.AppAnswerEventImpl;
import org.jdiameter.common.impl.app.AppRequestEventImpl;
import org.jdiameter.common.impl.app.s13.S13Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S13ClientSessionImpl
extends S13Session
implements ClientS13Session,
EventListener<Request, Answer>,
NetworkReqListener {
    private static final Logger logger = LoggerFactory.getLogger(S13ClientSessionImpl.class);
    private transient ClientS13SessionListener listener;
    protected long appId = -1L;
    protected IClientS13SessionData sessionData;

    public S13ClientSessionImpl(IClientS13SessionData sessionData, IS13MessageFactory fct, ISessionFactory sf, ClientS13SessionListener lst) {
        super(sf, sessionData);
        if (lst == null) {
            throw new IllegalArgumentException("Listener can not be null");
        }
        if (fct.getApplicationId() < 0L) {
            throw new IllegalArgumentException("ApplicationId can not be less than zero");
        }
        this.appId = fct.getApplicationId();
        this.listener = lst;
        this.messageFactory = fct;
        this.sessionData = sessionData;
    }

    public <E> E getState(Class<E> stateType) {
        return (E)((Object)(stateType == S13SessionState.class ? this.sessionData.getS13SessionState() : null));
    }

    public Answer processRequest(Request request) {
        RequestDelivery rd = new RequestDelivery();
        rd.session = this;
        rd.request = request;
        this.scheduler.execute(rd);
        return null;
    }

    public void sendMEIdentityCheckRequest(JMEIdentityCheckRequest request) throws InternalException, IllegalDiameterStateException, RouteException, OverloadException {
        this.send(Event.Type.SEND_MESSAGE, (AppEvent)request, null);
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        AnswerDelivery rd = new AnswerDelivery();
        rd.session = this;
        rd.request = request;
        rd.answer = answer;
        this.scheduler.execute(rd);
    }

    public void timeoutExpired(Request request) {
        try {
            this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)request), null));
        }
        catch (Exception e) {
            logger.debug("Failed to process timeout message", (Throwable)e);
        }
    }

    protected void send(Event.Type type, AppEvent request, AppEvent answer) throws InternalException {
        try {
            if (type != null) {
                this.handleEvent(new Event(type, request, answer));
            }
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean handleEvent(StateEvent event) throws InternalException, OverloadException {
        block21: {
            this.sendAndStateLock.lock();
            if (this.session.isValid()) break block21;
            var2_2 = false;
            var9_5 = null;
            this.sendAndStateLock.unlock();
            return var2_2;
        }
        try {
            try {
                state = this.sessionData.getS13SessionState();
                newState = null;
                localEvent = (Event)event;
                eventType = (Event.Type)event.getType();
                switch (1.$SwitchMap$org$jdiameter$common$api$app$s13$S13SessionState[state.ordinal()]) {
                    case 1: {
                        switch (1.$SwitchMap$org$jdiameter$client$impl$app$s13$Event$Type[eventType.ordinal()]) {
                            case 1: {
                                newState = S13SessionState.MESSAGE_SENT_RECEIVED;
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                this.setState(newState);
                                ** break;
                            }
                        }
                        S13ClientSessionImpl.logger.error("Invalid Event Type {} for S13 Client Session at state {}.", (Object)eventType, (Object)this.sessionData.getS13SessionState());
                        ** break;
                    }
                    case 2: {
                        switch (1.$SwitchMap$org$jdiameter$client$impl$app$s13$Event$Type[eventType.ordinal()]) {
                            case 2: {
                                newState = S13SessionState.TIMEDOUT;
                                this.setState(newState);
                                ** break;
                            }
                            case 1: {
                                this.session.send(((AppEvent)event.getData()).getMessage(), (EventListener)this);
                                var7_11 = null;
                                newState = S13SessionState.TERMINATED;
                                this.setState(newState);
                                ** break;
                            }
                            catch (Throwable var6_13) {
                                var7_12 = null;
                                newState = S13SessionState.TERMINATED;
                                this.setState(newState);
                                throw var6_13;
                            }
                            case 3: {
                                newState = S13SessionState.TERMINATED;
                                this.setState(newState);
                                super.cancelMsgTimer();
                                this.listener.doMEIdentityCheckAnswerEvent((ClientS13Session)this, (JMEIdentityCheckRequest)localEvent.getRequest(), (JMEIdentityCheckAnswer)localEvent.getAnswer());
                                ** break;
                            }
                        }
                        throw new InternalException("Unexpected/Unknown message received: " + event.getData());
                    }
                    case 3: {
                        throw new InternalException("Cant receive message in state TERMINATED. Command: " + event.getData());
                    }
                    case 4: {
                        throw new InternalException("Cant receive message in state TIMEDOUT. Command: " + event.getData());
                    }
                    default: {
                        S13ClientSessionImpl.logger.error("S13 Client FSM in wrong state: {}", (Object)state);
                    }
                }
            }
            catch (Exception e) {
                throw new InternalException((Throwable)e);
            }
lbl61:
            // 6 sources

            var9_6 = null;
            this.sendAndStateLock.unlock();
        }
        catch (Throwable var8_14) {
            var9_7 = null;
            this.sendAndStateLock.unlock();
            throw var8_14;
        }
        return true;
    }

    protected void setState(S13SessionState newState) {
        S13SessionState oldState = this.sessionData.getS13SessionState();
        this.sessionData.setS13SessionState(newState);
        for (StateChangeListener i : this.stateListeners) {
            i.stateChanged((Object)this, (Enum)oldState, (Enum)newState);
        }
        if (newState == S13SessionState.TERMINATED || newState == S13SessionState.TIMEDOUT) {
            super.cancelMsgTimer();
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimer(String timerName) {
        if (timerName.equals("MSG_TIMEOUT")) {
            try {
                this.sendAndStateLock.lock();
                try {
                    this.handleEvent(new Event(Event.Type.TIMEOUT_EXPIRES, new AppRequestEventImpl((Message)this.sessionData.getBuffer()), null));
                }
                catch (Exception e) {
                    logger.debug("Failure handling Timeout event.");
                }
                this.sessionData.setBuffer(null);
                this.sessionData.setTsTimerId(null);
                Object var4_3 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.appId ^ this.appId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S13ClientSessionImpl other = (S13ClientSessionImpl)obj;
        return this.appId == other.appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.isValid()) {
            try {
                try {
                    this.sendAndStateLock.lock();
                    super.release();
                }
                catch (Exception e) {
                    logger.debug("Failed to release session", (Throwable)e);
                    Object var3_2 = null;
                    this.sendAndStateLock.unlock();
                }
                Object var3_1 = null;
                this.sendAndStateLock.unlock();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.sendAndStateLock.unlock();
                throw throwable;
            }
        } else {
            logger.debug("Trying to release an already invalid session, with Session ID '{}'", (Object)this.getSessionId());
        }
    }

    private class AnswerDelivery
    implements Runnable {
        ClientS13Session session;
        Answer answer;
        Request request;

        private AnswerDelivery() {
        }

        public void run() {
            try {
                switch (this.answer.getCommandCode()) {
                    case 324: {
                        S13ClientSessionImpl.this.handleEvent(new Event(Event.Type.RECEIVE_ECA, (AppEvent)S13ClientSessionImpl.this.messageFactory.createMEIdentityCheckRequest(this.request), (AppEvent)S13ClientSessionImpl.this.messageFactory.createMEIdentityCheckAnswer(this.answer)));
                        break;
                    }
                    default: {
                        S13ClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), (AppAnswerEvent)new AppAnswerEventImpl(this.answer));
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Failed to process success message", (Throwable)e);
            }
        }
    }

    private class RequestDelivery
    implements Runnable {
        ClientS13Session session;
        Request request;

        private RequestDelivery() {
        }

        public void run() {
            try {
                switch (this.request.getCommandCode()) {
                    default: 
                }
                S13ClientSessionImpl.this.listener.doOtherEvent((AppSession)this.session, (AppRequestEvent)new AppRequestEventImpl((Message)this.request), null);
            }
            catch (Exception e) {
                logger.debug("Failed to process request message", (Throwable)e);
            }
        }
    }
}

