/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jdiameter.api.app;

/**
 * The Event class holds information about the different events that can be handled
 * by the state machine. Events are prioritized depending on the importance of the event.
 * The priority model tries to ensure that old messages are handled before any new ones.
 * 
 * @version 1.5.1 Final
 * 
 * @author erick.svenson@yahoo.com
 * @author <a href="mailto:brainslog@gmail.com"> Alexandre Mendonca </a>
 * @author <a href="mailto:baranowb@gmail.com"> Bartosz Baranowski </a>
 */
public interface StateEvent extends Comparable {

    /**
     * This method should be adapted by any subclass 
     * to return the type corresponding to the actual event.
     * @return type of this StateEvent
     */
    public <E> E encodeType(Class<E> enumType);

    /**
     * Return type of this StateEvent
     * @return type of this StateEvent
     */
    public Enum getType();

    /**
     * Returns a negative value if the priority for this object
     * is higher than the priority for the supplied object.
     * @param obj the Event to compare to.
     * @return compare result
     */

    /**
     * Set information object to this StateEvent
     * @param data information object
     */
    public void setData(Object data);

    /**
     * Return information object of this StateEvent
     * @return information object of this StateEvent
     */
    public Object getData();

}
