/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.spark.autologging;

import java.io.Serializable;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.mlflow.spark.autologging.DatasourceAttributeExtractorBase;
import org.mlflow.spark.autologging.MlflowAutologEventPublisherImpl;
import org.mlflow.spark.autologging.ReplAwareDatasourceAttributeExtractor$;
import org.mlflow.spark.autologging.ReplAwareSparkDataSourceListener$;
import org.mlflow.spark.autologging.SparkDataSourceListener;
import org.mlflow.spark.autologging.SparkTableInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001-\u0011\u0001EU3qY\u0006;\u0018M]3Ta\u0006\u00148\u000eR1uCN{WO]2f\u0019&\u001cH/\u001a8fe*\u00111\u0001B\u0001\fCV$x\u000e\\8hO&twM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007[24Gn\\<\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!aF*qCJ\\G)\u0019;b'>,(oY3MSN$XM\\3s\u0011!\t\u0002A!A!\u0002\u0013\u0011\u0012!\u00039vE2L7\u000f[3s!\ti1#\u0003\u0002\u0015\u0005\tyR\n\u001c4m_^\fU\u000f^8m_\u001e,e/\u001a8u!V\u0014G.[:iKJLU\u000e\u001d7\t\u000bY\u0001A\u0011A\f\u0002\rqJg.\u001b;?)\tA\u0012\u0004\u0005\u0002\u000e\u0001!9\u0011#\u0006I\u0001\u0002\u0004\u0011\u0002bB\u000e\u0001\u0005\u0004%I\u0001H\u0001\u0014Kb,7-\u001e;j_:LE\rV8SKBd\u0017\nZ\u000b\u0002;A!a$J\u0014,\u001b\u0005y\"B\u0001\u0011\"\u0003\u001diW\u000f^1cY\u0016T!AI\u0012\u0002\u0015\r|G\u000e\\3di&|gNC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t1sDA\u0002NCB\u0004\"\u0001K\u0015\u000e\u0003\rJ!AK\u0012\u0003\t1{gn\u001a\t\u0003YMr!!L\u0019\u0011\u00059\u001aS\"A\u0018\u000b\u0005AR\u0011A\u0002\u001fs_>$h(\u0003\u00023G\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u00114\u0005\u0003\u00048\u0001\u0001\u0006I!H\u0001\u0015Kb,7-\u001e;j_:LE\rV8SKBd\u0017\n\u001a\u0011\t\u000be\u0002A\u0011\u000b\u001e\u0002?\u001d,G\u000fR1uCN|WO]2f\u0003R$(/\u001b2vi\u0016,\u0005\u0010\u001e:bGR|'/F\u0001<!\tiA(\u0003\u0002>\u0005\t\u0001C)\u0019;bg>,(oY3BiR\u0014\u0018NY;uK\u0016CHO]1di>\u0014()Y:f\u0011\u0019y\u0004\u0001\"\u0001\u0003\u0001\u0006iq-\u001a;Qe>\u0004XM\u001d;jKN$\"!Q\"\u0011\t1\u00125fK\u0005\u0003MUBQ\u0001\u0012 A\u0002\u0015\u000bQ!\u001a<f]R\u0004\"A\u0012'\u000e\u0003\u001dS!\u0001S%\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0003K\u0015\tY\u0005\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001b\u001e\u0013Qc\u00159be.d\u0015n\u001d;f]\u0016\u0014(j\u001c2Ti\u0006\u0014H\u000fC\u0003P\u0001\u0011\u0005\u0003+\u0001\u0006p]*{'m\u0015;beR$\"!\u0015+\u0011\u0005!\u0012\u0016BA*$\u0005\u0011)f.\u001b;\t\u000b\u0011s\u0005\u0019A#\t\rY\u0003A\u0011\u000b\u0002X\u0003EygnU)M\u000bb,7-\u001e;j_:,e\u000e\u001a\u000b\u0003#bCQ\u0001R+A\u0002e\u0003\"AW1\u000e\u0003mS!\u0001X/\u0002\u0005UL'B\u00010`\u0003%)\u00070Z2vi&|gN\u0003\u0002a\u0013\u0006\u00191/\u001d7\n\u0005\t\\&\u0001H*qCJ\\G*[:uK:,'oU)M\u000bb,7-\u001e;j_:,e\u000e\u001a\u0005\u0006I\u0002!I!Z\u0001\ra>\u0004(+\u001a9m\u0013\u0012|\u0005\u000f\u001e\u000b\u0003M&\u00042\u0001K4,\u0013\tA7E\u0001\u0004PaRLwN\u001c\u0005\u0006\t\u000e\u0004\r!W\u0004\bW\n\t\t\u0011#\u0001m\u0003\u0001\u0012V\r\u001d7Bo\u0006\u0014Xm\u00159be.$\u0015\r^1T_V\u00148-\u001a'jgR,g.\u001a:\u0011\u00055igaB\u0001\u0003\u0003\u0003E\tA\\\n\u0003[>\u0004\"\u0001\u000b9\n\u0005E\u001c#AB!osJ+g\rC\u0003\u0017[\u0012\u00051\u000fF\u0001m\u0011\u001d)X.%A\u0005\u0002Y\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#A<+\u0005IA8&A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018!C;oG\",7m[3e\u0015\tq8%\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001|\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReplAwareSparkDataSourceListener
extends SparkDataSourceListener {
    private final MlflowAutologEventPublisherImpl publisher;
    private final Map<Object, String> executionIdToReplId;

    public static MlflowAutologEventPublisherImpl $lessinit$greater$default$1() {
        return ReplAwareSparkDataSourceListener$.MODULE$.$lessinit$greater$default$1();
    }

    private Map<Object, String> executionIdToReplId() {
        return this.executionIdToReplId;
    }

    @Override
    public DatasourceAttributeExtractorBase getDatasourceAttributeExtractor() {
        return ReplAwareDatasourceAttributeExtractor$.MODULE$;
    }

    public scala.collection.immutable.Map<String, String> getProperties(SparkListenerJobStart event) {
        return (scala.collection.immutable.Map)Option$.MODULE$.apply((Object)event.properties()).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(x$1).asScala()).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public void onJobStart(SparkListenerJobStart event) {
        scala.collection.immutable.Map<String, String> properties = this.getProperties(event);
        Option executionIdOpt = properties.get((Object)SQLExecution$.MODULE$.EXECUTION_ID_KEY()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ReplAwareSparkDataSourceListener.$anonfun$onJobStart$1(x$2)));
        if (executionIdOpt.isEmpty()) {
            this.logger().warn(new StringBuilder(121).append("Unable to find execution ID of current Spark Job, ").append("refusing to autolog datasource reads performed within current Spark job").toString());
            return;
        }
        long executionId = BoxesRunTime.unboxToLong((Object)executionIdOpt.get());
        Option replIdOpt = properties.get((Object)"spark.databricks.replId");
        if (replIdOpt.isEmpty()) {
            this.logger().warn(new StringBuilder(144).append("Unable to find ID of REPL that triggered current Spark Job (execution ID ").append(new StringBuilder(3).append(executionId).append("), ").toString()).append("refusing to autolog datasource reads performed within current Spark job").toString());
            return;
        }
        this.executionIdToReplId().put((Object)BoxesRunTime.boxToLong((long)executionId), replIdOpt.get());
    }

    @Override
    public void onSQLExecutionEnd(SparkListenerSQLExecutionEnd event) {
        block0: {
            DatasourceAttributeExtractorBase extractor = this.getDatasourceAttributeExtractor();
            Seq<SparkTableInfo> tableInfos = extractor.getTableInfos(event);
            Option<String> replIdOpt = this.popReplIdOpt(event);
            if (!replIdOpt.isDefined()) break block0;
            tableInfos.foreach((Function1 & Serializable & scala.Serializable)tableInfo -> {
                this.publisher.publishEvent((Option<String>)replIdOpt, tableInfo);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Option<String> popReplIdOpt(SparkListenerSQLExecutionEnd event) {
        return this.executionIdToReplId().remove((Object)BoxesRunTime.boxToLong((long)event.executionId()));
    }

    public static final /* synthetic */ long $anonfun$onJobStart$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public ReplAwareSparkDataSourceListener(MlflowAutologEventPublisherImpl publisher) {
        this.publisher = publisher;
        super(publisher);
        this.executionIdToReplId = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

