/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.spark.autologging;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.mlflow.spark.autologging.DatasourceAttributeExtractorBase;
import org.mlflow.spark.autologging.ExceptionUtils$;
import org.mlflow.spark.autologging.ReflectionUtils$;
import org.mlflow.spark.autologging.SparkTableInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.util.control.NonFatal$;

public final class ReplAwareDatasourceAttributeExtractor$
implements DatasourceAttributeExtractorBase {
    public static ReplAwareDatasourceAttributeExtractor$ MODULE$;
    private final Logger logger;

    static {
        new ReplAwareDatasourceAttributeExtractor$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void org$mlflow$spark$autologging$DatasourceAttributeExtractorBase$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public Option<SparkTableInfo> maybeGetDeltaTableInfo(LogicalPlan leafNode) {
        None$ none$;
        LogicalPlan logicalPlan = leafNode;
        if (logicalPlan instanceof LogicalRelation) {
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan;
            Object obj = ReflectionUtils$.MODULE$.getScalaObjectByName("com.databricks.sql.transaction.tahoe.DeltaTable");
            Option deltaFileIndexOpt = (Option)ReflectionUtils$.MODULE$.callMethod(obj, "unapply", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalRelation[]{logicalRelation}))));
            none$ = deltaFileIndexOpt.map((Function1 & Serializable & scala.Serializable)fileIndex -> {
                String path = ReflectionUtils$.MODULE$.getField(fileIndex, "path").toString();
                Option versionOpt = Option$.MODULE$.apply(ReflectionUtils$.MODULE$.callMethod(fileIndex, "tableVersion", (Seq<Object>)((Seq)Seq$.MODULE$.empty()))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString());
                return new SparkTableInfo(path, (Option<String>)versionOpt, (Option<String>)Option$.MODULE$.apply((Object)"delta"));
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<SparkTableInfo> getTableInfoToLog(LogicalPlan leafNode) {
        Option option;
        Option res = DatasourceAttributeExtractorBase.getTableInfoToLog$(this, leafNode);
        if (res.isDefined()) {
            option = res;
        } else {
            None$ none$;
            LogicalRelation logicalRelation;
            BaseRelation baseRelation;
            LogicalPlan logicalPlan = leafNode;
            if (logicalPlan instanceof LogicalRelation && (baseRelation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation) {
                None$ none$2;
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                FileIndex index = hadoopFsRelation.location();
                FileFormat fileFormat = hadoopFsRelation.fileFormat();
                String path = (String)index.rootPaths().headOption().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown");
                FileFormat fileFormat2 = fileFormat;
                if (fileFormat2 instanceof DataSourceRegister) {
                    FileFormat fileFormat3 = fileFormat2;
                    none$2 = Option$.MODULE$.apply((Object)((DataSourceRegister)fileFormat3).shortName());
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ formatOpt = none$2;
                none$ = Option$.MODULE$.apply((Object)new SparkTableInfo(path, (Option<String>)None$.MODULE$, (Option<String>)formatOpt));
            } else {
                none$ = None$.MODULE$;
            }
            option = none$;
        }
        return option;
    }

    private String tryRedactString(String value) {
        String string;
        try {
            Object redactor = ReflectionUtils$.MODULE$.getScalaObjectByName("com.databricks.spark.util.DatabricksSparkLogRedactor");
            string = (String)ReflectionUtils$.MODULE$.callMethod(redactor, "redact", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{value}))));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String msg = ExceptionUtils$.MODULE$.getUnexpectedExceptionMessage(e, "while applying redaction to datasource paths");
                this.logger().error(msg);
                throw e;
            }
            throw throwable;
        }
        return string;
    }

    private SparkTableInfo applyRedaction(SparkTableInfo tableInfo) {
        SparkTableInfo sparkTableInfo = tableInfo;
        if (sparkTableInfo == null) {
            throw new MatchError((Object)sparkTableInfo);
        }
        String path = sparkTableInfo.path();
        Option<String> versionOpt = sparkTableInfo.versionOpt();
        Option<String> formatOpt = sparkTableInfo.formatOpt();
        SparkTableInfo sparkTableInfo2 = new SparkTableInfo(this.tryRedactString(path), versionOpt, formatOpt);
        return sparkTableInfo2;
    }

    @Override
    public Seq<SparkTableInfo> getTableInfos(SparkListenerSQLExecutionEnd event) {
        return (Seq)DatasourceAttributeExtractorBase.getTableInfos$(this, event).map((Function1 & Serializable & scala.Serializable)tableInfo -> MODULE$.applyRedaction((SparkTableInfo)tableInfo), Seq$.MODULE$.canBuildFrom());
    }

    private ReplAwareDatasourceAttributeExtractor$() {
        MODULE$ = this;
        DatasourceAttributeExtractorBase.$init$(this);
    }
}

