/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.sagemaker;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import ml.combust.mleap.core.types.StructType;
import ml.combust.mleap.runtime.MleapContext;
import ml.combust.mleap.runtime.frame.DefaultLeapFrame;
import ml.combust.mleap.runtime.frame.FrameBuilder;
import ml.combust.mleap.runtime.frame.Transformer;
import ml.combust.mleap.runtime.javadsl.BundleBuilder;
import ml.combust.mleap.runtime.javadsl.ContextBuilder;
import ml.combust.mleap.runtime.javadsl.LeapFrameSupport;
import org.mlflow.sagemaker.InvalidSchemaException;
import org.mlflow.sagemaker.MLeapSchemaReader;
import org.mlflow.sagemaker.PandasSplitOrientedDataFrame;
import org.mlflow.sagemaker.Predictor;
import org.mlflow.sagemaker.PredictorDataWrapper;
import org.mlflow.sagemaker.PredictorEvaluationException;
import org.mlflow.sagemaker.PredictorLoadingException;
import org.mlflow.utils.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLeapPredictor
implements Predictor {
    private final Transformer pipelineTransformer;
    private static final String PREDICTION_COLUMN_NAME = "prediction";
    private static final Logger logger = LoggerFactory.getLogger(MLeapPredictor.class);
    private final LeapFrameSupport leapFrameSupport;
    private final StructType inputSchema;

    @Deprecated
    public MLeapPredictor(String modelDataPath, String inputSchemaPath) {
        MleapContext mleapContext = new ContextBuilder().createMleapContext();
        BundleBuilder bundleBuilder = new BundleBuilder();
        this.leapFrameSupport = new LeapFrameSupport();
        this.pipelineTransformer = (Transformer)bundleBuilder.load(new File(modelDataPath), mleapContext).root();
        try {
            this.inputSchema = new MLeapSchemaReader().fromFile(inputSchemaPath);
        }
        catch (Exception e) {
            logger.error("Could not read the model input schema from the specified path", (Throwable)e);
            throw new PredictorLoadingException(String.format("Failed to load model input schema from specified path: %s", inputSchemaPath), e);
        }
    }

    public MLeapPredictor(String modelDataPath) {
        MleapContext mleapContext = new ContextBuilder().createMleapContext();
        BundleBuilder bundleBuilder = new BundleBuilder();
        this.leapFrameSupport = new LeapFrameSupport();
        this.pipelineTransformer = (Transformer)bundleBuilder.load(new File(modelDataPath), mleapContext).root();
        this.inputSchema = this.pipelineTransformer.inputSchema();
    }

    @Override
    public PredictorDataWrapper predict(PredictorDataWrapper input) throws PredictorEvaluationException {
        DefaultLeapFrame leapFrame;
        PandasSplitOrientedDataFrame pandasFrame;
        try {
            pandasFrame = PandasSplitOrientedDataFrame.fromJson(input.toJson());
        }
        catch (IOException e) {
            logger.error("Encountered a JSON parsing error during conversion of input to a Pandas DataFrame representation.", (Throwable)e);
            throw new PredictorEvaluationException("Encountered a JSON parsing error while transforming input into a Pandas DataFrame representation. Ensure that the input is a JSON-serialized Pandas DataFrame with the `split` orientation.", e);
        }
        catch (InvalidSchemaException e) {
            logger.error("Encountered a schema mismatch while transforming input into a Pandas DataFrame representation.", (Throwable)e);
            throw new PredictorEvaluationException("Encountered a schema mismatch while transforming input into a Pandas DataFrame representation. Ensure that the input is a JSON-serialized Pandas DataFrame with the `split` orientation.", e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Failed to transform input into a Pandas DataFrame because the parsed frame is invalid.", (Throwable)e);
            throw new PredictorEvaluationException("Failed to transform input into a Pandas DataFrame because the parsed frame is invalid. Ensure that the input is a JSON-serialized Pandas DataFrame with the `split` orientation.", e);
        }
        try {
            leapFrame = pandasFrame.toLeapFrame(this.inputSchema);
        }
        catch (InvalidSchemaException e) {
            logger.error("Encountered a schema mismatch when converting the input dataframe to a LeapFrame.", (Throwable)e);
            throw new PredictorEvaluationException("Encountered a schema mismatch when converting the input dataframe to a LeapFrame.");
        }
        catch (Exception e) {
            logger.error("Encountered an unknown error during conversion of Pandas dataframe to LeapFrame.", (Throwable)e);
            throw new PredictorEvaluationException("An unknown error occurred while converting the input dataframe to a LeapFrame.", e);
        }
        DefaultLeapFrame predictionsFrame = this.leapFrameSupport.select((DefaultLeapFrame)this.pipelineTransformer.transform((FrameBuilder)leapFrame).get(), Collections.singletonList(PREDICTION_COLUMN_NAME));
        List predictions = this.leapFrameSupport.collect(predictionsFrame).stream().map(row -> row.getRaw(0)).collect(Collectors.toList());
        try {
            HashMap predictionMap = new HashMap();
            predictionMap.put("predictions", predictions);
            String predictionsJson = SerializationUtils.toJson(predictionMap);
            return new PredictorDataWrapper(predictionsJson, PredictorDataWrapper.ContentType.Json);
        }
        catch (JsonProcessingException e) {
            logger.error("Encountered an error while serializing the output dataframe.", (Throwable)e);
            throw new PredictorEvaluationException("Failed to serialize prediction results as a JSON list!");
        }
    }

    public Transformer getPipeline() {
        return this.pipelineTransformer;
    }
}

