/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.mlflow.Flavor;
import org.mlflow.utils.FileUtils;
import org.mlflow.utils.SerializationUtils;

public class Model {
    @JsonProperty(value="artifact_path")
    private String artifactPath;
    @JsonProperty(value="run_id")
    private String runId;
    @JsonProperty(value="utc_time_created")
    private String utcTimeCreated;
    @JsonProperty(value="flavors")
    private Map<String, Object> flavors;
    @JsonProperty(value="signature")
    Signature signature;
    @JsonProperty(value="input_example")
    private Map<String, Object> input_example;
    @JsonProperty(value="model_uuid")
    private String modelUuid;
    @JsonProperty(value="mlflow_version")
    private String mlflowVersion;
    private String rootPath;

    public static Model fromRootPath(String modelRootPath) throws IOException {
        String configPath = FileUtils.join(modelRootPath, "MLmodel");
        return Model.fromConfigPath(configPath);
    }

    public static Model fromConfigPath(String configPath) throws IOException {
        File configFile = new File(configPath);
        Model model = SerializationUtils.parseYamlFromFile(configFile, Model.class);
        model.setRootPath(configFile.getParentFile().getAbsolutePath());
        return model;
    }

    public Optional<String> getArtifactPath() {
        return Optional.ofNullable(this.artifactPath);
    }

    public Optional<String> getUtcTimeCreated() {
        return Optional.ofNullable(this.utcTimeCreated);
    }

    public Optional<String> getRunId() {
        return Optional.ofNullable(this.runId);
    }

    public Optional<String> getModelUuid() {
        return Optional.ofNullable(this.modelUuid);
    }

    public Optional<String> getMlflowVersion() {
        return Optional.ofNullable(this.mlflowVersion);
    }

    public Optional<String> getRootPath() {
        return Optional.ofNullable(this.rootPath);
    }

    public <T extends Flavor> Optional<T> getFlavor(String flavorName, Class<T> flavorClass) {
        if (this.flavors.containsKey(flavorName)) {
            ObjectMapper mapper = new ObjectMapper();
            Flavor flavor = (Flavor)mapper.convertValue(this.flavors.get(flavorName), flavorClass);
            return Optional.of(flavor);
        }
        return Optional.empty();
    }

    private void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public static class Signature {
        @JsonProperty(value="inputs")
        private String inputsSchemaJson;
        @JsonProperty(value="outputs")
        private String outputSchemaJson;
    }
}

