/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;

public class SerializationUtils {
    private static final ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String toJson(Object object) throws JsonProcessingException {
        return jsonMapper.writeValueAsString(object);
    }

    public static <T> T fromJson(String json, Class<T> objectClass) throws IOException {
        return (T)jsonMapper.readValue(json, objectClass);
    }

    public static <T> T parseJsonFromFile(String filePath, Class<T> objectClass) throws IOException {
        File jsonFile = new File(filePath);
        return SerializationUtils.parseJsonFromFile(jsonFile, objectClass);
    }

    public static <T> T parseJsonFromFile(File jsonFile, Class<T> objectClass) throws IOException {
        return SerializationUtils.parseFromFile(jsonFile, objectClass, jsonMapper);
    }

    public static <T> T parseYamlFromFile(String filePath, Class<T> objectClass) throws IOException {
        File yamlFile = new File(filePath);
        return SerializationUtils.parseYamlFromFile(yamlFile, objectClass);
    }

    public static <T> T parseYamlFromFile(File yamlFile, Class<T> objectClass) throws IOException {
        return SerializationUtils.parseFromFile(yamlFile, objectClass, yamlMapper);
    }

    private static <T> T parseFromFile(File file, Class<T> objectClass, ObjectMapper mapper) throws IOException {
        return (T)mapper.readValue(file, objectClass);
    }
}

