/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.sagemaker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ml.combust.mleap.core.types.StructField;
import ml.combust.mleap.core.types.StructType;
import ml.combust.mleap.runtime.frame.DefaultLeapFrame;
import ml.combust.mleap.runtime.frame.Row;
import ml.combust.mleap.runtime.javadsl.LeapFrameBuilder;
import ml.combust.mleap.runtime.javadsl.LeapFrameSupport;
import org.mlflow.sagemaker.InvalidSchemaException;
import org.mlflow.utils.SerializationUtils;

class PandasSplitOrientedDataFrame {
    private static final LeapFrameBuilder leapFrameBuilder = new LeapFrameBuilder();
    private static final LeapFrameSupport leapFrameSupport = new LeapFrameSupport();
    private final List<LinkedHashMap<String, Object>> entries = new ArrayList<LinkedHashMap<String, Object>>();
    private static final String PANDAS_FRAME_KEY_COLUMN_NAMES = "columns";
    private static final String PANDAS_FRAME_KEY_ROWS = "data";

    private PandasSplitOrientedDataFrame(List<String> columnNames, List<List<Object>> rows) {
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            List<Object> row = rows.get(rowIndex);
            if (row.size() != columnNames.size()) {
                throw new IllegalArgumentException(String.format("Row %d of the DataFrame does not contain the expected number of columns! Found %d columns, expected %d columns", rowIndex, row.size(), columnNames.size()));
            }
            LinkedHashMap<String, Object> newEntry = new LinkedHashMap<String, Object>(row.size());
            for (int i = 0; i < row.size(); ++i) {
                newEntry.put(columnNames.get(i), row.get(i));
            }
            this.entries.add(newEntry);
        }
    }

    static PandasSplitOrientedDataFrame fromJson(String frameJson) throws IOException {
        Map parsedFrame = SerializationUtils.fromJson(frameJson, Map.class);
        PandasSplitOrientedDataFrame.validatePandasDataFrameJsonRepresentation(parsedFrame);
        return new PandasSplitOrientedDataFrame((List)parsedFrame.get(PANDAS_FRAME_KEY_COLUMN_NAMES), (List)parsedFrame.get(PANDAS_FRAME_KEY_ROWS));
    }

    private static void validatePandasDataFrameJsonRepresentation(Map<String, List<?>> parsedFrame) throws InvalidSchemaException {
        String[] expectedColumnNames;
        for (String columnName : expectedColumnNames = new String[]{PANDAS_FRAME_KEY_COLUMN_NAMES, PANDAS_FRAME_KEY_ROWS}) {
            if (parsedFrame.containsKey(columnName)) continue;
            throw new InvalidSchemaException(String.format("The JSON representation of the serialized Pandas DataFrame is missing an expected  column with name: `%s` that is required by the Pandas `split` orientation.", columnName));
        }
    }

    int size() {
        return this.entries.size();
    }

    DefaultLeapFrame toLeapFrame(StructType leapFrameSchema) {
        ArrayList<Row> mleapRows = new ArrayList<Row>();
        for (Map map : this.entries) {
            ArrayList mleapRow = new ArrayList();
            for (StructField field : leapFrameSupport.getFields(leapFrameSchema)) {
                String fieldName = field.name();
                if (!map.containsKey(fieldName)) {
                    throw new InvalidSchemaException(String.format("Pandas DataFrame is missing a required field: `%s`", fieldName));
                }
                mleapRow.add(map.get(fieldName));
            }
            mleapRows.add(leapFrameBuilder.createRowFromIterable(mleapRow));
        }
        return leapFrameBuilder.createFrame(leapFrameSchema, mleapRows);
    }
}

