/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.sagemaker;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.combust.mleap.runtime.frame.DefaultLeapFrame;
import org.mlflow.sagemaker.InvalidSchemaException;
import org.mlflow.sagemaker.LeapFrameSchema;
import org.mlflow.sagemaker.LeapFrameUtils;
import org.mlflow.utils.SerializationUtils;

class PandasRecordOrientedDataFrame {
    private final List<Map<String, Object>> records;
    private static final String LEAP_FRAME_KEY_ROWS = "rows";
    private static final String LEAP_FRAME_KEY_SCHEMA = "schema";

    private PandasRecordOrientedDataFrame(List<Map<String, Object>> records) {
        this.records = records;
    }

    static PandasRecordOrientedDataFrame fromJson(String frameJson) throws IOException {
        return new PandasRecordOrientedDataFrame(SerializationUtils.fromJson(frameJson, List.class));
    }

    int size() {
        return this.records.size();
    }

    DefaultLeapFrame toLeapFrame(LeapFrameSchema leapFrameSchema) throws JsonProcessingException {
        ArrayList mleapRows = new ArrayList();
        for (Map<String, Object> record : this.records) {
            ArrayList<Object> mleapRow = new ArrayList<Object>();
            for (String fieldName : leapFrameSchema.getFieldNames()) {
                if (!record.containsKey(fieldName)) {
                    throw new InvalidSchemaException(String.format("Pandas dataframe is missing a required field: `%s`", fieldName));
                }
                mleapRow.add(record.get(fieldName));
            }
            mleapRows.add(mleapRow);
        }
        HashMap<String, Object> rawFrame = new HashMap<String, Object>();
        rawFrame.put(LEAP_FRAME_KEY_ROWS, mleapRows);
        rawFrame.put(LEAP_FRAME_KEY_SCHEMA, leapFrameSchema.getRawSchema());
        String leapFrameJson = SerializationUtils.toJson(rawFrame);
        DefaultLeapFrame leapFrame = LeapFrameUtils.getLeapFrameFromJson(leapFrameJson);
        return leapFrame;
    }
}

