/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.protocol;

import java.io.IOException;
import org.mlflow_project.apachehttp.HttpEntityEnclosingRequest;
import org.mlflow_project.apachehttp.HttpException;
import org.mlflow_project.apachehttp.HttpRequest;
import org.mlflow_project.apachehttp.HttpRequestInterceptor;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.protocol.HttpContext;
import org.mlflow_project.apachehttp.protocol.HttpDateGenerator;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

