/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.google.common.graph;

import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.mlflow_project.google.common.annotations.Beta;
import org.mlflow_project.google.common.graph.ElementOrder;
import org.mlflow_project.google.common.graph.EndpointPair;
import org.mlflow_project.google.common.graph.Graph;
import org.mlflow_project.google.common.graph.PredecessorsFunction;
import org.mlflow_project.google.common.graph.SuccessorsFunction;
import org.mlflow_project.google.errorprone.annotations.DoNotMock;

@DoNotMock(value="Use NetworkBuilder to create a real instance")
@Beta
public interface Network<N, E>
extends SuccessorsFunction<N>,
PredecessorsFunction<N> {
    public Set<N> nodes();

    public Set<E> edges();

    public Graph<N> asGraph();

    public boolean isDirected();

    public boolean allowsParallelEdges();

    public boolean allowsSelfLoops();

    public ElementOrder<N> nodeOrder();

    public ElementOrder<E> edgeOrder();

    public Set<N> adjacentNodes(N var1);

    @Override
    public Set<N> predecessors(N var1);

    @Override
    public Set<N> successors(N var1);

    public Set<E> incidentEdges(N var1);

    public Set<E> inEdges(N var1);

    public Set<E> outEdges(N var1);

    public int degree(N var1);

    public int inDegree(N var1);

    public int outDegree(N var1);

    public EndpointPair<N> incidentNodes(E var1);

    public Set<E> adjacentEdges(E var1);

    public Set<E> edgesConnecting(N var1, N var2);

    public Set<E> edgesConnecting(EndpointPair<N> var1);

    @NullableDecl
    public E edgeConnectingOrNull(N var1, N var2);

    @NullableDecl
    public E edgeConnectingOrNull(EndpointPair<N> var1);

    public boolean hasEdgeConnecting(N var1, N var2);

    public boolean hasEdgeConnecting(EndpointPair<N> var1);

    public boolean equals(@NullableDecl Object var1);

    public int hashCode();
}

