/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking;

import java.net.URISyntaxException;
import org.mlflow.api.proto.ModelRegistry;
import org.mlflow.api.proto.Service;
import org.mlflow.tracking.MlflowClientException;
import org.mlflow_project.apachehttp.client.utils.URIBuilder;
import org.mlflow_project.google.protobuf.InvalidProtocolBufferException;
import org.mlflow_project.google.protobuf.Message;
import org.mlflow_project.google.protobuf.MessageOrBuilder;
import org.mlflow_project.google.protobuf.util.JsonFormat;

class MlflowProtobufMapper {
    MlflowProtobufMapper() {
    }

    String makeCreateExperimentRequest(String expName) {
        Service.CreateExperiment.Builder builder = Service.CreateExperiment.newBuilder();
        builder.setName(expName);
        return this.print(builder);
    }

    String makeDeleteExperimentRequest(String experimentId) {
        Service.DeleteExperiment.Builder builder = Service.DeleteExperiment.newBuilder();
        builder.setExperimentId(experimentId);
        return this.print(builder);
    }

    String makeRestoreExperimentRequest(String experimentId) {
        Service.RestoreExperiment.Builder builder = Service.RestoreExperiment.newBuilder();
        builder.setExperimentId(experimentId);
        return this.print(builder);
    }

    String makeUpdateExperimentRequest(String experimentId, String newExperimentName) {
        Service.UpdateExperiment.Builder builder = Service.UpdateExperiment.newBuilder();
        builder.setExperimentId(experimentId);
        builder.setNewName(newExperimentName);
        return this.print(builder);
    }

    String makeLogParam(String runId, String key, String value) {
        Service.LogParam.Builder builder = Service.LogParam.newBuilder();
        builder.setRunUuid(runId);
        builder.setRunId(runId);
        builder.setKey(key);
        builder.setValue(value);
        return this.print(builder);
    }

    String makeLogMetric(String runId, String key, double value, long timestamp, long step) {
        Service.LogMetric.Builder builder = Service.LogMetric.newBuilder();
        builder.setRunUuid(runId);
        builder.setRunId(runId);
        builder.setKey(key);
        builder.setValue(value);
        builder.setTimestamp(timestamp);
        builder.setStep(step);
        return this.print(builder);
    }

    String makeSetExperimentTag(String expId, String key, String value) {
        Service.SetExperimentTag.Builder builder = Service.SetExperimentTag.newBuilder();
        builder.setExperimentId(expId);
        builder.setKey(key);
        builder.setValue(value);
        return this.print(builder);
    }

    String makeSetTag(String runId, String key, String value) {
        Service.SetTag.Builder builder = Service.SetTag.newBuilder();
        builder.setRunUuid(runId);
        builder.setRunId(runId);
        builder.setKey(key);
        builder.setValue(value);
        return this.print(builder);
    }

    String makeDeleteTag(String runId, String key) {
        Service.DeleteTag.Builder builder = Service.DeleteTag.newBuilder();
        builder.setRunId(runId);
        builder.setKey(key);
        return this.print(builder);
    }

    String makeLogBatch(String runId, Iterable<Service.Metric> metrics, Iterable<Service.Param> params, Iterable<Service.RunTag> tags) {
        Service.LogBatch.Builder builder = Service.LogBatch.newBuilder();
        builder.setRunId(runId);
        if (metrics != null) {
            builder.addAllMetrics(metrics);
        }
        if (params != null) {
            builder.addAllParams(params);
        }
        if (tags != null) {
            builder.addAllTags(tags);
        }
        return this.print(builder);
    }

    String makeUpdateRun(String runId, Service.RunStatus status, long endTime) {
        Service.UpdateRun.Builder builder = Service.UpdateRun.newBuilder();
        builder.setRunUuid(runId);
        builder.setRunId(runId);
        builder.setStatus(status);
        builder.setEndTime(endTime);
        return this.print(builder);
    }

    String makeDeleteRun(String runId) {
        Service.DeleteRun.Builder builder = Service.DeleteRun.newBuilder();
        builder.setRunId(runId);
        return this.print(builder);
    }

    String makeRestoreRun(String runId) {
        Service.RestoreRun.Builder builder = Service.RestoreRun.newBuilder();
        builder.setRunId(runId);
        return this.print(builder);
    }

    String makeGetLatestVersion(String modelName, Iterable<String> stages) {
        try {
            URIBuilder builder = new URIBuilder("registered-models/get-latest-versions").addParameter("name", modelName);
            if (stages != null) {
                for (String stage : stages) {
                    builder.addParameter("stages", stage);
                }
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new MlflowClientException("Failed to construct request URI for get latest versions.", e);
        }
    }

    String makeUpdateModelVersion(String modelName, String version) {
        return this.print(ModelRegistry.UpdateModelVersion.newBuilder().setName(modelName).setVersion(version));
    }

    String makeTransitionModelVersionStage(String modelName, String version, String stage) {
        return this.print(ModelRegistry.TransitionModelVersionStage.newBuilder().setName(modelName).setVersion(version).setStage(stage));
    }

    String makeCreateModel(String modelName) {
        ModelRegistry.CreateRegisteredModel.Builder builder = ModelRegistry.CreateRegisteredModel.newBuilder().setName(modelName);
        return this.print(builder);
    }

    String makeCreateModelVersion(String modelName, String runId, String source) {
        ModelRegistry.CreateModelVersion.Builder builder = ModelRegistry.CreateModelVersion.newBuilder().setName(modelName).setRunId(runId).setSource(source);
        return this.print(builder);
    }

    String makeGetRegisteredModel(String modelName) {
        try {
            return new URIBuilder("registered-models/get").addParameter("name", modelName).build().toString();
        }
        catch (URISyntaxException e) {
            throw new MlflowClientException("Failed to construct request URI for get model version.", e);
        }
    }

    String makeGetModelVersion(String modelName, String modelVersion) {
        try {
            return new URIBuilder("model-versions/get").addParameter("name", modelName).addParameter("version", modelVersion).build().toString();
        }
        catch (URISyntaxException e) {
            throw new MlflowClientException("Failed to construct request URI for get model version.", e);
        }
    }

    String makeGetModelVersionDownloadUri(String modelName, String modelVersion) {
        try {
            return new URIBuilder("model-versions/get-download-uri").addParameter("name", modelName).addParameter("version", modelVersion).build().toString();
        }
        catch (URISyntaxException e) {
            throw new MlflowClientException("Failed to construct request URI for get version download uri.", e);
        }
    }

    String toJson(MessageOrBuilder mb) {
        return this.print(mb);
    }

    Service.GetExperiment.Response toGetExperimentResponse(String json) {
        Service.GetExperiment.Response.Builder builder = Service.GetExperiment.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetExperimentByName.Response toGetExperimentByNameResponse(String json) {
        Service.GetExperimentByName.Response.Builder builder = Service.GetExperimentByName.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.SearchExperiments.Response toSearchExperimentsResponse(String json) {
        Service.SearchExperiments.Response.Builder builder = Service.SearchExperiments.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.CreateExperiment.Response toCreateExperimentResponse(String json) {
        Service.CreateExperiment.Response.Builder builder = Service.CreateExperiment.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetRun.Response toGetRunResponse(String json) {
        Service.GetRun.Response.Builder builder = Service.GetRun.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetMetricHistory.Response toGetMetricHistoryResponse(String json) {
        Service.GetMetricHistory.Response.Builder builder = Service.GetMetricHistory.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.CreateRun.Response toCreateRunResponse(String json) {
        Service.CreateRun.Response.Builder builder = Service.CreateRun.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.SearchRuns.Response toSearchRunsResponse(String json) {
        Service.SearchRuns.Response.Builder builder = Service.SearchRuns.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    ModelRegistry.GetLatestVersions.Response toGetLatestVersionsResponse(String json) {
        ModelRegistry.GetLatestVersions.Response.Builder builder = ModelRegistry.GetLatestVersions.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    ModelRegistry.GetModelVersion.Response toGetModelVersionResponse(String json) {
        ModelRegistry.GetModelVersion.Response.Builder builder = ModelRegistry.GetModelVersion.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    ModelRegistry.GetRegisteredModel.Response toGetRegisteredModelResponse(String json) {
        ModelRegistry.GetRegisteredModel.Response.Builder builder = ModelRegistry.GetRegisteredModel.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    String toGetModelVersionDownloadUriResponse(String json) {
        ModelRegistry.GetModelVersionDownloadUri.Response.Builder builder = ModelRegistry.GetModelVersionDownloadUri.Response.newBuilder();
        this.merge(json, builder);
        return builder.getArtifactUri();
    }

    private String print(MessageOrBuilder message) {
        try {
            return JsonFormat.printer().preservingProtoFieldNames().print(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new MlflowClientException("Failed to serialize message " + message, e);
        }
    }

    private void merge(String json, Message.Builder builder) {
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(json, builder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new MlflowClientException("Failed to serialize json " + json + " into " + builder, e);
        }
    }
}

