/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking.utils;

import java.util.HashMap;
import java.util.Map;
import org.mlflow_project.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabricksContext {
    public static final String CONFIG_PROVIDER_CLASS_NAME = "com.databricks.config.DatabricksClientSettingsProvider";
    private static final Logger logger = LoggerFactory.getLogger(DatabricksContext.class);
    private final Map<String, String> configProvider;

    private DatabricksContext(Map<String, String> configProvider) {
        this.configProvider = configProvider;
    }

    public static DatabricksContext createIfAvailable() {
        return DatabricksContext.createIfAvailable(CONFIG_PROVIDER_CLASS_NAME);
    }

    @VisibleForTesting
    static DatabricksContext createIfAvailable(String className) {
        Map<String, String> configProvider = DatabricksContext.getConfigProviderIfAvailable(className);
        if (configProvider == null) {
            return null;
        }
        return new DatabricksContext(configProvider);
    }

    public Map<String, String> getTags() {
        String webappUrl;
        String notebookPath;
        HashMap<String, String> tags = new HashMap<String, String>();
        if (!this.isInDatabricksNotebook()) {
            return tags;
        }
        String notebookId = this.getNotebookId();
        if (notebookId != null) {
            tags.put("mlflow.databricks.notebookID", notebookId);
        }
        if ((notebookPath = this.getNotebookPath()) != null) {
            tags.put("mlflow.source.name", notebookPath);
            tags.put("mlflow.databricks.notebookPath", notebookPath);
            tags.put("mlflow.source.type", "NOTEBOOK");
        }
        if ((webappUrl = this.getWebappUrl()) != null) {
            tags.put("mlflow.databricks.webappURL", webappUrl);
        }
        return tags;
    }

    public boolean isInDatabricksNotebook() {
        return this.configProvider.get("notebookId") != null;
    }

    public String getNotebookId() {
        return this.configProvider.get("notebookId");
    }

    private String getNotebookPath() {
        if (!this.isInDatabricksNotebook()) {
            throw new IllegalArgumentException("getNotebookPath() should not be called when isInDatabricksNotebook() is false");
        }
        return this.configProvider.get("notebookPath");
    }

    private String getWebappUrl() {
        if (!this.isInDatabricksNotebook()) {
            throw new IllegalArgumentException("getWebappUrl() should not be called when isInDatabricksNotebook() is false");
        }
        return this.configProvider.get("host");
    }

    public static Map<String, String> getConfigProviderIfAvailable(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return (Map)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn("Found but failed to invoke dynamic config provider", (Throwable)e);
            return null;
        }
    }
}

