/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.protocol;

import java.io.IOException;
import org.mlflow_project.apachehttp.HttpException;
import org.mlflow_project.apachehttp.HttpResponse;
import org.mlflow_project.apachehttp.HttpResponseInterceptor;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.protocol.HttpContext;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

