/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking.samples;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mlflow.tracking.ActiveRun;
import org.mlflow.tracking.MlflowContext;
import org.mlflow_project.google.common.collect.ImmutableMap;

public class FluentExample {
    public static void main(String[] args) {
        int i;
        MlflowContext mlflow = new MlflowContext();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ActiveRun run = mlflow.startRun("run");
        run.logParam("alpha", "0.0");
        run.logMetric("MSE", 0.0);
        run.setTags(ImmutableMap.of("company", "databricks", "org", "engineering"));
        run.endRun();
        mlflow.withActiveRun("lambda run", activeRun -> activeRun.logParam("layers", "4"));
        run = mlflow.startRun("parent run");
        for (i = 0; i <= 5; ++i) {
            ActiveRun childRun = mlflow.startRun("child run", run.getId());
            childRun.logParam("iteration", Integer.toString(i));
            childRun.endRun();
        }
        run.endRun();
        run = mlflow.startRun("parent run (multithreaded)");
        i = 0;
        while (i <= 5) {
            int i0 = i++;
            executor.submit(() -> {
                ActiveRun childRun = mlflow.startRun("child run (multithreaded)", run.getId());
                childRun.logParam("iteration", Integer.toString(i0));
                childRun.endRun();
            });
        }
        run.endRun();
        executor.shutdown();
    }
}

