/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking;

import org.mlflow.api.proto.Service;
import org.mlflow.tracking.MlflowClientException;
import org.mlflow_project.google.protobuf.InvalidProtocolBufferException;
import org.mlflow_project.google.protobuf.Message;
import org.mlflow_project.google.protobuf.MessageOrBuilder;
import org.mlflow_project.google.protobuf.util.JsonFormat;

class MlflowProtobufMapper {
    MlflowProtobufMapper() {
    }

    String makeCreateExperimentRequest(String expName) {
        Service.CreateExperiment.Builder builder = Service.CreateExperiment.newBuilder();
        builder.setName(expName);
        return this.print(builder);
    }

    String makeLogParam(String runUuid, String key, String value) {
        Service.LogParam.Builder builder = Service.LogParam.newBuilder();
        builder.setRunUuid(runUuid);
        builder.setKey(key);
        builder.setValue(value);
        return this.print(builder);
    }

    String makeLogMetric(String runUuid, String key, double value, long timestamp) {
        Service.LogMetric.Builder builder = Service.LogMetric.newBuilder();
        builder.setRunUuid(runUuid);
        builder.setKey(key);
        builder.setValue(value);
        builder.setTimestamp(timestamp);
        return this.print(builder);
    }

    String makeSetTag(String runUuid, String key, String value) {
        Service.SetTag.Builder builder = Service.SetTag.newBuilder();
        builder.setRunUuid(runUuid);
        builder.setKey(key);
        builder.setValue(value);
        return this.print(builder);
    }

    String makeUpdateRun(String runUuid, Service.RunStatus status, long endTime) {
        Service.UpdateRun.Builder builder = Service.UpdateRun.newBuilder();
        builder.setRunUuid(runUuid);
        builder.setStatus(status);
        builder.setEndTime(endTime);
        return this.print(builder);
    }

    String makeDeleteRun(String runUuid) {
        Service.DeleteRun.Builder builder = Service.DeleteRun.newBuilder();
        builder.setRunId(runUuid);
        return this.print(builder);
    }

    String makeRestoreRun(String runUuid) {
        Service.RestoreRun.Builder builder = Service.RestoreRun.newBuilder();
        builder.setRunId(runUuid);
        return this.print(builder);
    }

    String toJson(MessageOrBuilder mb) {
        return this.print(mb);
    }

    Service.GetExperiment.Response toGetExperimentResponse(String json) {
        Service.GetExperiment.Response.Builder builder = Service.GetExperiment.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.ListExperiments.Response toListExperimentsResponse(String json) {
        Service.ListExperiments.Response.Builder builder = Service.ListExperiments.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.CreateExperiment.Response toCreateExperimentResponse(String json) {
        Service.CreateExperiment.Response.Builder builder = Service.CreateExperiment.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetRun.Response toGetRunResponse(String json) {
        Service.GetRun.Response.Builder builder = Service.GetRun.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.CreateRun.Response toCreateRunResponse(String json) {
        Service.CreateRun.Response.Builder builder = Service.CreateRun.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetMetric.Response toGetMetricResponse(String json) {
        Service.GetMetric.Response.Builder builder = Service.GetMetric.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetMetricHistory.Response toGetMetricHistoryResponse(String json) {
        Service.GetMetricHistory.Response.Builder builder = Service.GetMetricHistory.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.GetParam.Response toGeParamResponse(String json) {
        Service.GetParam.Response.Builder builder = Service.GetParam.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.ListArtifacts.Response toListArtifactsResponse(String json) {
        Service.ListArtifacts.Response.Builder builder = Service.ListArtifacts.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    Service.SearchRuns.Response toSearchRunsResponse(String json) {
        Service.SearchRuns.Response.Builder builder = Service.SearchRuns.Response.newBuilder();
        this.merge(json, builder);
        return builder.build();
    }

    private String print(MessageOrBuilder message) {
        try {
            return JsonFormat.printer().preservingProtoFieldNames().print(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new MlflowClientException("Failed to serialize message " + message, e);
        }
    }

    private void merge(String json, Message.Builder builder) {
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(json, builder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new MlflowClientException("Failed to serialize json " + json + " into " + builder, e);
        }
    }
}

