/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.assertion;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.mitre.jwt.signer.service.impl.ClientKeyCacheService;
import org.mitre.oauth2.model.ClientDetailsEntity;
import org.mitre.oauth2.service.ClientDetailsEntityService;
import org.mitre.openid.connect.assertion.JWTBearerAssertionAuthenticationToken;
import org.mitre.openid.connect.config.ConfigurationPropertiesBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;

public class JWTBearerAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(JWTBearerAuthenticationProvider.class);
    private static final GrantedAuthority ROLE_CLIENT = new SimpleGrantedAuthority("ROLE_CLIENT");
    @Autowired
    private ClientKeyCacheService validators;
    private int timeSkewAllowance = 300;
    @Autowired
    private ClientDetailsEntityService clientService;
    @Autowired
    private ConfigurationPropertiesBean config;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        JWTBearerAssertionAuthenticationToken jwtAuth = (JWTBearerAssertionAuthenticationToken)authentication;
        try {
            ClientDetailsEntity client = this.clientService.loadClientByClientId(jwtAuth.getName());
            JWT jwt = jwtAuth.getJwt();
            JWTClaimsSet jwtClaims = jwt.getJWTClaimsSet();
            if (!(jwt instanceof SignedJWT)) {
                throw new AuthenticationServiceException("Unsupported JWT type: " + jwt.getClass().getName());
            }
            SignedJWT jws = (SignedJWT)jwt;
            JWSAlgorithm alg = jws.getHeader().getAlgorithm();
            if (client.getTokenEndpointAuthSigningAlg() != null && !client.getTokenEndpointAuthSigningAlg().equals((Object)alg)) {
                throw new AuthenticationServiceException("Client's registered token endpoint signing algorithm (" + client.getTokenEndpointAuthSigningAlg() + ") does not match token's actual algorithm (" + alg.getName() + ")");
            }
            if (client.getTokenEndpointAuthMethod() == null || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.NONE) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_BASIC) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_POST)) {
                throw new AuthenticationServiceException("Client does not support this authentication method.");
            }
            if (client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY) && (alg.equals((Object)JWSAlgorithm.RS256) || alg.equals((Object)JWSAlgorithm.RS384) || alg.equals((Object)JWSAlgorithm.RS512) || alg.equals((Object)JWSAlgorithm.ES256) || alg.equals((Object)JWSAlgorithm.ES384) || alg.equals((Object)JWSAlgorithm.ES512) || alg.equals((Object)JWSAlgorithm.PS256) || alg.equals((Object)JWSAlgorithm.PS384) || alg.equals((Object)JWSAlgorithm.PS512)) || client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.SECRET_JWT) && (alg.equals((Object)JWSAlgorithm.HS256) || alg.equals((Object)JWSAlgorithm.HS384) || alg.equals((Object)JWSAlgorithm.HS512))) {
                if (this.config.isHeartMode() && !client.getTokenEndpointAuthMethod().equals((Object)ClientDetailsEntity.AuthMethod.PRIVATE_KEY)) {
                    throw new AuthenticationServiceException("[HEART mode] Invalid authentication method");
                }
                JWTSigningAndValidationService validator = this.validators.getValidator(client, alg);
                if (validator == null) {
                    throw new AuthenticationServiceException("Unable to create signature validator for client " + client + " and algorithm " + alg);
                }
                if (!validator.validateSignature(jws)) {
                    throw new AuthenticationServiceException("Signature did not validate for presented JWT authentication.");
                }
            } else {
                throw new AuthenticationServiceException("Unable to create signature validator for method " + client.getTokenEndpointAuthMethod() + " and algorithm " + alg);
            }
            if (jwtClaims.getIssuer() == null) {
                throw new AuthenticationServiceException("Assertion Token Issuer is null");
            }
            if (!jwtClaims.getIssuer().equals(client.getClientId())) {
                throw new AuthenticationServiceException("Issuers do not match, expected " + client.getClientId() + " got " + jwtClaims.getIssuer());
            }
            if (jwtClaims.getExpirationTime() == null) {
                throw new AuthenticationServiceException("Assertion Token does not have required expiration claim");
            }
            Date now = new Date(System.currentTimeMillis() - (long)(this.timeSkewAllowance * 1000));
            if (now.after(jwtClaims.getExpirationTime())) {
                throw new AuthenticationServiceException("Assertion Token is expired: " + jwtClaims.getExpirationTime());
            }
            if (jwtClaims.getNotBeforeTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(jwtClaims.getNotBeforeTime())) {
                throw new AuthenticationServiceException("Assertion Token not valid untill: " + jwtClaims.getNotBeforeTime());
            }
            if (jwtClaims.getIssueTime() != null && (now = new Date(System.currentTimeMillis() + (long)(this.timeSkewAllowance * 1000))).before(jwtClaims.getIssueTime())) {
                throw new AuthenticationServiceException("Assertion Token was issued in the future: " + jwtClaims.getIssueTime());
            }
            if (jwtClaims.getAudience() == null) {
                throw new AuthenticationServiceException("Assertion token audience is null");
            }
            if (!jwtClaims.getAudience().contains(this.config.getIssuer()) && !jwtClaims.getAudience().contains(this.config.getIssuer() + "token")) {
                throw new AuthenticationServiceException("Audience does not match, expected " + this.config.getIssuer() + " or " + this.config.getIssuer() + "token" + " got " + jwtClaims.getAudience());
            }
            HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>(client.getAuthorities());
            authorities.add(ROLE_CLIENT);
            return new JWTBearerAssertionAuthenticationToken(jwt, authorities);
        }
        catch (InvalidClientException e) {
            throw new UsernameNotFoundException("Could not find client: " + jwtAuth.getName());
        }
        catch (ParseException e) {
            logger.error("Failure during authentication, error was: ", (Throwable)e);
            throw new AuthenticationServiceException("Invalid JWT format");
        }
    }

    public boolean supports(Class<?> authentication) {
        return JWTBearerAssertionAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

