/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model.convert;

import com.nimbusds.jose.jwk.JWKSet;
import java.text.ParseException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public class JWKSetStringConverter
implements AttributeConverter<JWKSet, String> {
    private static Logger logger = LoggerFactory.getLogger(JWKSetStringConverter.class);

    public String convertToDatabaseColumn(JWKSet attribute) {
        if (attribute != null) {
            return attribute.toString();
        }
        return null;
    }

    public JWKSet convertToEntityAttribute(String dbData) {
        if (dbData != null) {
            try {
                JWKSet jwks = JWKSet.parse((String)dbData);
                return jwks;
            }
            catch (ParseException e) {
                logger.error("Unable to parse JWK Set", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

