/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.oauth2.model;

import java.util.Collection;
import java.util.HashSet;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.mitre.oauth2.model.convert.SimpleGrantedAuthorityStringConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

@Entity
@Table(name="saved_user_auth")
public class SavedUserAuthentication
implements Authentication {
    private static final long serialVersionUID = -1804249963940323488L;
    private Long id;
    private String name;
    private Collection<GrantedAuthority> authorities;
    private boolean authenticated;
    private String sourceClass;

    public SavedUserAuthentication(Authentication src) {
        this.setName(src.getName());
        this.setAuthorities(new HashSet<GrantedAuthority>(src.getAuthorities()));
        this.setAuthenticated(src.isAuthenticated());
        if (src instanceof SavedUserAuthentication) {
            this.setSourceClass(((SavedUserAuthentication)src).getSourceClass());
        } else {
            this.setSourceClass(src.getClass().getName());
        }
    }

    public SavedUserAuthentication() {
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Basic
    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="saved_user_auth_authority", joinColumns={@JoinColumn(name="owner_id")})
    @Convert(converter=SimpleGrantedAuthorityStringConverter.class)
    @Column(name="authority")
    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Transient
    public Object getCredentials() {
        return "";
    }

    @Transient
    public Object getDetails() {
        return null;
    }

    @Transient
    public Object getPrincipal() {
        return this.getName();
    }

    @Basic
    @Column(name="authenticated")
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        this.authenticated = isAuthenticated;
    }

    @Basic
    @Column(name="source_class")
    public String getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(String sourceClass) {
        this.sourceClass = sourceClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthorities(Collection<GrantedAuthority> authorities) {
        this.authorities = authorities;
    }
}

