/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jwt.signer.service.impl;

import com.google.common.base.Strings;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.mitre.jose.keystore.JWKSetKeyStore;
import org.mitre.jwt.signer.service.JWTSigningAndValidationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJWTSigningAndValidationService
implements JWTSigningAndValidationService {
    private Map<String, JWSSigner> signers = new HashMap<String, JWSSigner>();
    private Map<String, JWSVerifier> verifiers = new HashMap<String, JWSVerifier>();
    private static final Logger logger = LoggerFactory.getLogger(DefaultJWTSigningAndValidationService.class);
    private String defaultSignerKeyId;
    private JWSAlgorithm defaultAlgorithm;
    private Map<String, JWK> keys = new HashMap<String, JWK>();

    public DefaultJWTSigningAndValidationService(Map<String, JWK> keys) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this.keys = keys;
        this.buildSignersAndVerifiers();
    }

    public DefaultJWTSigningAndValidationService(JWKSetKeyStore keyStore) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (keyStore != null && keyStore.getJwkSet() != null) {
            for (JWK key : keyStore.getKeys()) {
                if (!Strings.isNullOrEmpty((String)key.getKeyID())) {
                    this.keys.put(key.getKeyID(), key);
                    continue;
                }
                String fakeKid = UUID.randomUUID().toString();
                this.keys.put(fakeKid, key);
            }
        }
        this.buildSignersAndVerifiers();
    }

    @Override
    public String getDefaultSignerKeyId() {
        return this.defaultSignerKeyId;
    }

    public void setDefaultSignerKeyId(String defaultSignerId) {
        this.defaultSignerKeyId = defaultSignerId;
    }

    @Override
    public JWSAlgorithm getDefaultSigningAlgorithm() {
        return this.defaultAlgorithm;
    }

    public void setDefaultSigningAlgorithmName(String algName) {
        this.defaultAlgorithm = JWSAlgorithm.parse((String)algName);
    }

    public String getDefaultSigningAlgorithmName() {
        if (this.defaultAlgorithm != null) {
            return this.defaultAlgorithm.getName();
        }
        return null;
    }

    private void buildSignersAndVerifiers() throws NoSuchAlgorithmException, InvalidKeySpecException {
        for (Map.Entry<String, JWK> jwkEntry : this.keys.entrySet()) {
            String id = jwkEntry.getKey();
            JWK jwk = jwkEntry.getValue();
            try {
                RSASSAVerifier verifier;
                RSASSASigner signer;
                if (jwk instanceof RSAKey) {
                    if (jwk.isPrivate()) {
                        signer = new RSASSASigner((RSAKey)jwk);
                        this.signers.put(id, (JWSSigner)signer);
                    }
                    verifier = new RSASSAVerifier((RSAKey)jwk);
                    this.verifiers.put(id, (JWSVerifier)verifier);
                    continue;
                }
                if (jwk instanceof ECKey) {
                    if (jwk.isPrivate()) {
                        signer = new ECDSASigner((ECKey)jwk);
                        this.signers.put(id, (JWSSigner)signer);
                    }
                    verifier = new ECDSAVerifier((ECKey)jwk);
                    this.verifiers.put(id, (JWSVerifier)verifier);
                    continue;
                }
                if (jwk instanceof OctetSequenceKey) {
                    if (jwk.isPrivate()) {
                        signer = new MACSigner((OctetSequenceKey)jwk);
                        this.signers.put(id, (JWSSigner)signer);
                    }
                    verifier = new MACVerifier((OctetSequenceKey)jwk);
                    this.verifiers.put(id, (JWSVerifier)verifier);
                    continue;
                }
                logger.warn("Unknown key type: " + jwk);
            }
            catch (JOSEException e) {
                logger.warn("Exception loading signer/verifier", (Throwable)e);
            }
        }
        if (this.defaultSignerKeyId == null && this.keys.size() == 1) {
            this.setDefaultSignerKeyId(this.keys.keySet().iterator().next());
        }
    }

    @Override
    public void signJwt(SignedJWT jwt) {
        if (this.getDefaultSignerKeyId() == null) {
            throw new IllegalStateException("Tried to call default signing with no default signer ID set");
        }
        JWSSigner signer = this.signers.get(this.getDefaultSignerKeyId());
        try {
            jwt.sign(signer);
        }
        catch (JOSEException e) {
            logger.error("Failed to sign JWT, error was: ", (Throwable)e);
        }
    }

    @Override
    public void signJwt(SignedJWT jwt, JWSAlgorithm alg) {
        JWSSigner signer = null;
        for (JWSSigner s : this.signers.values()) {
            if (!s.supportedJWSAlgorithms().contains(alg)) continue;
            signer = s;
            break;
        }
        if (signer == null) {
            logger.error("No matching algirthm found for alg=" + alg);
        }
        try {
            jwt.sign(signer);
        }
        catch (JOSEException e) {
            logger.error("Failed to sign JWT, error was: ", (Throwable)e);
        }
    }

    @Override
    public boolean validateSignature(SignedJWT jwt) {
        for (JWSVerifier verifier : this.verifiers.values()) {
            try {
                if (!jwt.verify(verifier)) continue;
                return true;
            }
            catch (JOSEException e) {
                logger.error("Failed to validate signature with " + verifier + " error message: " + e.getMessage());
            }
        }
        return false;
    }

    @Override
    public Map<String, JWK> getAllPublicKeys() {
        HashMap<String, JWK> pubKeys = new HashMap<String, JWK>();
        for (String keyId : this.keys.keySet()) {
            JWK key = this.keys.get(keyId);
            JWK pub = key.toPublicJWK();
            if (pub == null) continue;
            pubKeys.put(keyId, pub);
        }
        return pubKeys;
    }

    @Override
    public Collection<JWSAlgorithm> getAllSigningAlgsSupported() {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        for (JWSSigner signer : this.signers.values()) {
            algs.addAll(signer.supportedJWSAlgorithms());
        }
        for (JWSVerifier verifier : this.verifiers.values()) {
            algs.addAll(verifier.supportedJWSAlgorithms());
        }
        return algs;
    }
}

