/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.openid.connect.client.service.impl;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.mitre.openid.connect.client.model.IssuerServiceResponse;
import org.mitre.openid.connect.client.service.IssuerService;
import org.mitre.openid.connect.client.service.impl.ThirdPartyIssuerService;
import org.mitre.openid.connect.client.service.impl.WebfingerIssuerService;

public class HybridIssuerService
implements IssuerService {
    private ThirdPartyIssuerService thirdPartyIssuerService = new ThirdPartyIssuerService();
    private WebfingerIssuerService webfingerIssuerService = new WebfingerIssuerService();

    public String getAccountChooserUrl() {
        return this.thirdPartyIssuerService.getAccountChooserUrl();
    }

    public void setAccountChooserUrl(String accountChooserUrl) {
        this.thirdPartyIssuerService.setAccountChooserUrl(accountChooserUrl);
    }

    public boolean isForceHttps() {
        return this.webfingerIssuerService.isForceHttps();
    }

    public void setForceHttps(boolean forceHttps) {
        this.webfingerIssuerService.setForceHttps(forceHttps);
    }

    @Override
    public IssuerServiceResponse getIssuer(HttpServletRequest request) {
        IssuerServiceResponse resp = this.thirdPartyIssuerService.getIssuer(request);
        if (resp.shouldRedirect()) {
            return this.webfingerIssuerService.getIssuer(request);
        }
        return resp;
    }

    public Set<String> getWhitelist() {
        return Sets.union(this.thirdPartyIssuerService.getWhitelist(), this.webfingerIssuerService.getWhitelist());
    }

    public void setWhitelist(Set<String> whitelist) {
        this.thirdPartyIssuerService.setWhitelist(whitelist);
        this.webfingerIssuerService.setWhitelist(whitelist);
    }

    public Set<String> getBlacklist() {
        return Sets.union(this.thirdPartyIssuerService.getBlacklist(), this.webfingerIssuerService.getWhitelist());
    }

    public void setBlacklist(Set<String> blacklist) {
        this.thirdPartyIssuerService.setBlacklist(blacklist);
        this.webfingerIssuerService.setBlacklist(blacklist);
    }

    public String getParameterName() {
        return this.webfingerIssuerService.getParameterName();
    }

    public void setParameterName(String parameterName) {
        this.webfingerIssuerService.setParameterName(parameterName);
    }

    public String getLoginPageUrl() {
        return this.webfingerIssuerService.getLoginPageUrl();
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.webfingerIssuerService.setLoginPageUrl(loginPageUrl);
        this.thirdPartyIssuerService.setAccountChooserUrl(loginPageUrl);
    }
}

