/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.dsmiley.httpproxy;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpCookie;
import java.net.URI;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class ProxyServlet
extends HttpServlet {
    public static final String P_LOG = "log";
    public static final String P_FORWARDEDFOR = "forwardip";
    protected static final String P_TARGET_URI = "targetUri";
    protected static final String ATTR_TARGET_URI;
    protected static final String ATTR_TARGET_HOST;
    protected boolean doLog = false;
    protected boolean doForwardIP = true;
    protected boolean doSendUrlFragment = true;
    protected String targetUri;
    protected URI targetUriObj;
    protected HttpHost targetHost;
    private HttpClient proxyClient;
    protected static final HeaderGroup hopByHopHeaders;
    protected static final BitSet asciiQueryChars;

    public String getServletInfo() {
        return "A proxy servlet by David Smiley, dsmiley@apache.org";
    }

    protected String getTargetUri(HttpServletRequest servletRequest) {
        return (String)servletRequest.getAttribute(ATTR_TARGET_URI);
    }

    private HttpHost getTargetHost(HttpServletRequest servletRequest) {
        return (HttpHost)servletRequest.getAttribute(ATTR_TARGET_HOST);
    }

    protected String getConfigParam(String key) {
        return this.getServletConfig().getInitParameter(key);
    }

    public void init() throws ServletException {
        String doForwardIPString;
        String doLogStr = this.getConfigParam(P_LOG);
        if (doLogStr != null) {
            this.doLog = Boolean.parseBoolean(doLogStr);
        }
        if ((doForwardIPString = this.getConfigParam(P_FORWARDEDFOR)) != null) {
            this.doForwardIP = Boolean.parseBoolean(doForwardIPString);
        }
        this.initTarget();
        BasicHttpParams hcParams = new BasicHttpParams();
        hcParams.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        this.readConfigParam((HttpParams)hcParams, "http.protocol.handle-redirects", Boolean.class);
        this.proxyClient = this.createHttpClient((HttpParams)hcParams);
    }

    protected void initTarget() throws ServletException {
        this.targetUri = this.getConfigParam(P_TARGET_URI);
        if (this.targetUri == null) {
            throw new ServletException("targetUri is required.");
        }
        try {
            this.targetUriObj = new URI(this.targetUri);
        }
        catch (Exception e) {
            throw new ServletException("Trying to process targetUri init parameter: " + e, (Throwable)e);
        }
        this.targetHost = URIUtils.extractHost((URI)this.targetUriObj);
    }

    protected HttpClient createHttpClient(HttpParams hcParams) {
        try {
            Class<?> clientClazz = Class.forName("org.apache.http.impl.client.SystemDefaultHttpClient");
            Constructor<?> constructor = clientClazz.getConstructor(HttpParams.class);
            return (HttpClient)constructor.newInstance(hcParams);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager(), hcParams);
    }

    protected HttpClient getProxyClient() {
        return this.proxyClient;
    }

    protected void readConfigParam(HttpParams hcParams, String hcParamName, Class type) {
        Object val_obj;
        String val_str = this.getConfigParam(hcParamName);
        if (val_str == null) {
            return;
        }
        if (type == String.class) {
            val_obj = val_str;
        } else {
            try {
                val_obj = type.getMethod("valueOf", String.class).invoke((Object)type, val_str);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        hcParams.setParameter(hcParamName, val_obj);
    }

    public void destroy() {
        if (this.proxyClient instanceof Closeable) {
            try {
                ((Closeable)this.proxyClient).close();
            }
            catch (IOException e) {
                this.log("While destroying servlet, shutting down HttpClient: " + e, e);
            }
        } else if (this.proxyClient != null) {
            this.proxyClient.getConnectionManager().shutdown();
        }
        super.destroy();
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        BasicHttpRequest proxyRequest;
        if (servletRequest.getAttribute(ATTR_TARGET_URI) == null) {
            servletRequest.setAttribute(ATTR_TARGET_URI, (Object)this.targetUri);
        }
        if (servletRequest.getAttribute(ATTR_TARGET_HOST) == null) {
            servletRequest.setAttribute(ATTR_TARGET_HOST, (Object)this.targetHost);
        }
        String method = servletRequest.getMethod();
        String proxyRequestUri = this.rewriteUrlFromRequest(servletRequest);
        if (servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null) {
            BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
            eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)servletRequest.getInputStream(), (long)servletRequest.getContentLength()));
            proxyRequest = eProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(method, proxyRequestUri);
        }
        this.copyRequestHeaders(servletRequest, (HttpRequest)proxyRequest);
        this.setXForwardedForHeader(servletRequest, (HttpRequest)proxyRequest);
        HttpResponse proxyResponse = null;
        try {
            int statusCode;
            if (this.doLog) {
                this.log("proxy " + method + " uri: " + servletRequest.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
            }
            if (this.doResponseRedirectOrNotModifiedLogic(servletRequest, servletResponse, proxyResponse = this.proxyClient.execute(this.getTargetHost(servletRequest), (HttpRequest)proxyRequest), statusCode = proxyResponse.getStatusLine().getStatusCode())) {
                return;
            }
            servletResponse.setStatus(statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseHeaders(proxyResponse, servletRequest, servletResponse);
            this.copyResponseEntity(proxyResponse, servletResponse);
        }
        catch (Exception e) {
            if (proxyRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)proxyRequest;
                abortableHttpRequest.abort();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (proxyResponse != null) {
                this.consumeQuietly(proxyResponse.getEntity());
            }
        }
    }

    protected boolean doResponseRedirectOrNotModifiedLogic(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader == null) {
                throw new ServletException("Received status code: " + statusCode + " but no " + "Location" + " header was found in the response");
            }
            String locStr = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue());
            servletResponse.sendRedirect(locStr);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
        }
    }

    protected void consumeQuietly(HttpEntity entity) {
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            this.log(e.getMessage(), e);
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host")) {
                    HttpHost host = this.getTargetHost(servletRequest);
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = headerValue + ":" + host.getPort();
                    }
                } else if (headerName.equalsIgnoreCase("Cookie")) {
                    headerValue = this.getRealCookie(headerValue);
                }
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
    }

    private void setXForwardedForHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        String headerName = "X-Forwarded-For";
        if (this.doForwardIP) {
            String newHeader = servletRequest.getRemoteAddr();
            String existingHeader = servletRequest.getHeader(headerName);
            if (existingHeader != null) {
                newHeader = existingHeader + ", " + newHeader;
            }
            proxyRequest.setHeader(headerName, newHeader);
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            if (header.getName().equals("Set-Cookie") || header.getName().equals("Set-Cookie2")) {
                this.copyProxyCookie(servletRequest, servletResponse, header);
                continue;
            }
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    protected void copyProxyCookie(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Header header) {
        List<HttpCookie> cookies = HttpCookie.parse(header.getValue());
        String path = this.getServletContext().getServletContextName();
        if (path == null) {
            path = "";
        }
        path = path + servletRequest.getServletPath();
        for (HttpCookie cookie : cookies) {
            String proxyCookieName = this.getCookieNamePrefix() + cookie.getName();
            Cookie servletCookie = new Cookie(proxyCookieName, cookie.getValue());
            servletCookie.setComment(cookie.getComment());
            servletCookie.setMaxAge((int)cookie.getMaxAge());
            servletCookie.setPath(path);
            servletCookie.setSecure(cookie.getSecure());
            servletCookie.setVersion(cookie.getVersion());
            servletResponse.addCookie(servletCookie);
        }
    }

    protected String getRealCookie(String cookieValue) {
        String[] cookies;
        StringBuilder escapedCookie = new StringBuilder();
        for (String cookie : cookies = cookieValue.split("; ")) {
            String cookieName;
            String[] cookieSplit = cookie.split("=");
            if (cookieSplit.length == 2 && (cookieName = cookieSplit[0]).startsWith(this.getCookieNamePrefix())) {
                cookieName = cookieName.substring(this.getCookieNamePrefix().length());
                if (escapedCookie.length() > 0) {
                    escapedCookie.append("; ");
                }
                escapedCookie.append(cookieName).append("=").append(cookieSplit[1]);
            }
            cookieValue = escapedCookie.toString();
        }
        return cookieValue;
    }

    protected String getCookieNamePrefix() {
        return "!Proxy!" + this.getServletConfig().getServletName();
    }

    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            entity.writeTo((OutputStream)servletOutputStream);
        }
    }

    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        int fragIdx;
        StringBuilder uri = new StringBuilder(500);
        uri.append(this.getTargetUri(servletRequest));
        if (servletRequest.getPathInfo() != null) {
            uri.append(ProxyServlet.encodeUriQuery(servletRequest.getPathInfo()));
        }
        String queryString = servletRequest.getQueryString();
        String fragment = null;
        if (queryString != null && (fragIdx = queryString.indexOf(35)) >= 0) {
            fragment = queryString.substring(fragIdx + 1);
            queryString = queryString.substring(0, fragIdx);
        }
        if ((queryString = this.rewriteQueryStringFromRequest(servletRequest, queryString)) != null && queryString.length() > 0) {
            uri.append('?');
            uri.append(ProxyServlet.encodeUriQuery(queryString));
        }
        if (this.doSendUrlFragment && fragment != null) {
            uri.append('#');
            uri.append(ProxyServlet.encodeUriQuery(fragment));
        }
        return uri.toString();
    }

    protected String rewriteQueryStringFromRequest(HttpServletRequest servletRequest, String queryString) {
        return queryString;
    }

    protected String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl) {
        String targetUri = this.getTargetUri(servletRequest);
        if (theUrl.startsWith(targetUri)) {
            String curUrl = servletRequest.getRequestURL().toString();
            String pathInfo = servletRequest.getPathInfo();
            if (pathInfo != null) {
                assert (curUrl.endsWith(pathInfo));
                curUrl = curUrl.substring(0, curUrl.length() - pathInfo.length());
            }
            theUrl = curUrl + theUrl.substring(targetUri.length());
        }
        return theUrl;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    protected static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        ATTR_TARGET_URI = ProxyServlet.class.getSimpleName() + ".targetUri";
        ATTR_TARGET_HOST = ProxyServlet.class.getSimpleName() + ".targetHost";
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

