/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.NUMS512E;

import org.apache.milagro.amcl.NUMS512E.BIG;
import org.apache.milagro.amcl.NUMS512E.FP;
import org.apache.milagro.amcl.NUMS512E.ROM;

public final class ECP {
    public static final int WEIERSTRASS = 0;
    public static final int EDWARDS = 1;
    public static final int MONTGOMERY = 2;
    public static final int NOT = 0;
    public static final int BN = 1;
    public static final int BLS = 2;
    public static final int D_TYPE = 0;
    public static final int M_TYPE = 1;
    public static final int POSITIVEX = 0;
    public static final int NEGATIVEX = 1;
    public static final int CURVETYPE = 1;
    public static final int CURVE_PAIRING_TYPE = 0;
    public static final int SEXTIC_TWIST = 0;
    public static final int SIGN_OF_X = 0;
    public static final int SHA256 = 32;
    public static final int SHA384 = 48;
    public static final int SHA512 = 64;
    public static final int HASH_TYPE = 64;
    public static final int AESKEY = 32;
    private FP x;
    private FP y;
    private FP z;

    public ECP() {
        this.x = new FP(0);
        this.y = new FP(1);
        this.z = new FP(1);
    }

    public ECP(ECP e) {
        this.x = new FP(e.x);
        this.y = new FP(e.y);
        this.z = new FP(e.z);
    }

    public boolean is_infinity() {
        return this.x.iszilch() && this.y.equals(this.z);
    }

    private void cswap(ECP Q, int d) {
        this.x.cswap(Q.x, d);
        this.y.cswap(Q.y, d);
        this.z.cswap(Q.z, d);
    }

    private void cmove(ECP Q, int d) {
        this.x.cmove(Q.x, d);
        this.y.cmove(Q.y, d);
        this.z.cmove(Q.z, d);
    }

    private static int teq(int b, int c) {
        int x = b ^ c;
        return --x >> 31 & 1;
    }

    private void select(ECP[] W, int b) {
        ECP MP = new ECP();
        int m = b >> 31;
        int babs = (b ^ m) - m;
        babs = (babs - 1) / 2;
        this.cmove(W[0], ECP.teq(babs, 0));
        this.cmove(W[1], ECP.teq(babs, 1));
        this.cmove(W[2], ECP.teq(babs, 2));
        this.cmove(W[3], ECP.teq(babs, 3));
        this.cmove(W[4], ECP.teq(babs, 4));
        this.cmove(W[5], ECP.teq(babs, 5));
        this.cmove(W[6], ECP.teq(babs, 6));
        this.cmove(W[7], ECP.teq(babs, 7));
        MP.copy(this);
        MP.neg();
        this.cmove(MP, m & 1);
    }

    public boolean equals(ECP Q) {
        FP a = new FP(0);
        FP b = new FP(0);
        a.copy(this.x);
        a.mul(Q.z);
        b.copy(Q.x);
        b.mul(this.z);
        if (!a.equals(b)) {
            return false;
        }
        a.copy(this.y);
        a.mul(Q.z);
        b.copy(Q.y);
        b.mul(this.z);
        return a.equals(b);
    }

    public void copy(ECP P) {
        this.x.copy(P.x);
        this.y.copy(P.y);
        this.z.copy(P.z);
    }

    public void neg() {
        this.x.neg();
        this.x.norm();
    }

    public void inf() {
        this.x.zero();
        this.y.one();
        this.z.one();
    }

    public static FP RHS(FP x) {
        x.norm();
        FP r = new FP(x);
        r.sqr();
        FP b = new FP(new BIG(ROM.CURVE_B));
        FP one = new FP(1);
        b.mul(r);
        b.sub(one);
        b.norm();
        r.sub(one);
        r.norm();
        b.inverse();
        r.mul(b);
        r.reduce();
        return r;
    }

    public ECP(BIG ix, BIG iy) {
        this.x = new FP(ix);
        this.y = new FP(iy);
        this.z = new FP(1);
        FP rhs = ECP.RHS(this.x);
        FP y2 = new FP(this.y);
        y2.sqr();
        if (!y2.equals(rhs)) {
            this.inf();
        }
    }

    public ECP(BIG ix, int s) {
        this.x = new FP(ix);
        FP rhs = ECP.RHS(this.x);
        this.y = new FP(0);
        this.z = new FP(1);
        if (rhs.jacobi() == 1) {
            FP ny = rhs.sqrt();
            if (ny.redc().parity() != s) {
                ny.neg();
            }
            this.y.copy(ny);
        } else {
            this.inf();
        }
    }

    public ECP(BIG ix) {
        this.x = new FP(ix);
        FP rhs = ECP.RHS(this.x);
        this.y = new FP(0);
        this.z = new FP(1);
        if (rhs.jacobi() == 1) {
            this.y.copy(rhs.sqrt());
        } else {
            this.inf();
        }
    }

    public void affine() {
        if (this.is_infinity()) {
            return;
        }
        FP one = new FP(1);
        if (this.z.equals(one)) {
            return;
        }
        this.z.inverse();
        this.x.mul(this.z);
        this.x.reduce();
        this.y.mul(this.z);
        this.y.reduce();
        this.z.copy(one);
    }

    public BIG getX() {
        ECP W = new ECP(this);
        W.affine();
        return W.x.redc();
    }

    public BIG getY() {
        ECP W = new ECP(this);
        W.affine();
        return W.y.redc();
    }

    public int getS() {
        BIG y = this.getY();
        return y.parity();
    }

    public FP getx() {
        return this.x;
    }

    public FP gety() {
        return this.y;
    }

    public FP getz() {
        return this.z;
    }

    public void toBytes(byte[] b, boolean compress) {
        int i;
        byte[] t = new byte[64];
        ECP W = new ECP(this);
        W.affine();
        W.x.redc().toBytes(t);
        for (i = 0; i < 64; ++i) {
            b[i + 1] = t[i];
        }
        if (compress) {
            b[0] = 2;
            if (this.y.redc().parity() == 1) {
                b[0] = 3;
            }
            return;
        }
        b[0] = 4;
        W.y.redc().toBytes(t);
        for (i = 0; i < 64; ++i) {
            b[i + 64 + 1] = t[i];
        }
    }

    public static ECP fromBytes(byte[] b) {
        byte[] t = new byte[64];
        BIG p = new BIG(ROM.Modulus);
        for (int i = 0; i < 64; ++i) {
            t[i] = b[i + 1];
        }
        BIG px = BIG.fromBytes(t);
        if (BIG.comp(px, p) >= 0) {
            return new ECP();
        }
        if (b[0] == 4) {
            for (int i = 0; i < 64; ++i) {
                t[i] = b[i + 64 + 1];
            }
            BIG py = BIG.fromBytes(t);
            if (BIG.comp(py, p) >= 0) {
                return new ECP();
            }
            return new ECP(px, py);
        }
        if (b[0] == 2 || b[0] == 3) {
            return new ECP(px, b[0] & 1);
        }
        return new ECP();
    }

    public String toString() {
        ECP W = new ECP(this);
        W.affine();
        if (W.is_infinity()) {
            return "infinity";
        }
        return "(" + W.x.redc().toString() + "," + W.y.redc().toString() + ")";
    }

    public String toRawString() {
        ECP W = new ECP(this);
        return "(" + W.x.redc().toString() + "," + W.y.redc().toString() + "," + W.z.redc().toString() + ")";
    }

    public void dbl() {
        FP C = new FP(this.x);
        FP D = new FP(this.y);
        FP H = new FP(this.z);
        FP J = new FP(0);
        this.x.mul(this.y);
        this.x.add(this.x);
        this.x.norm();
        C.sqr();
        D.sqr();
        this.y.copy(C);
        this.y.add(D);
        this.y.norm();
        H.sqr();
        H.add(H);
        this.z.copy(this.y);
        J.copy(this.y);
        J.sub(H);
        J.norm();
        this.x.mul(J);
        C.sub(D);
        C.norm();
        this.y.mul(C);
        this.z.mul(J);
    }

    public void add(ECP Q) {
        FP A = new FP(this.z);
        FP B = new FP(0);
        FP C = new FP(this.x);
        FP D = new FP(this.y);
        FP E = new FP(0);
        FP F = new FP(0);
        FP G = new FP(0);
        A.mul(Q.z);
        B.copy(A);
        B.sqr();
        C.mul(Q.x);
        D.mul(Q.y);
        E.copy(C);
        E.mul(D);
        E.imul(-78296);
        F.copy(B);
        F.sub(E);
        G.copy(B);
        G.add(E);
        E.copy(D);
        E.sub(C);
        C.add(D);
        B.copy(this.x);
        B.add(this.y);
        D.copy(Q.x);
        D.add(Q.y);
        B.norm();
        D.norm();
        B.mul(D);
        B.sub(C);
        B.norm();
        F.norm();
        B.mul(F);
        this.x.copy(A);
        this.x.mul(B);
        G.norm();
        E.norm();
        C.copy(E);
        C.mul(G);
        this.y.copy(A);
        this.y.mul(C);
        this.z.copy(F);
        this.z.mul(G);
    }

    public void dadd(ECP Q, ECP W) {
        FP A = new FP(this.x);
        FP B = new FP(this.x);
        FP C = new FP(Q.x);
        FP D = new FP(Q.x);
        FP DA = new FP(0);
        FP CB = new FP(0);
        A.add(this.z);
        B.sub(this.z);
        C.add(Q.z);
        D.sub(Q.z);
        A.norm();
        D.norm();
        DA.copy(D);
        DA.mul(A);
        C.norm();
        B.norm();
        CB.copy(C);
        CB.mul(B);
        A.copy(DA);
        A.add(CB);
        A.norm();
        A.sqr();
        B.copy(DA);
        B.sub(CB);
        B.norm();
        B.sqr();
        this.x.copy(A);
        this.z.copy(W.x);
        this.z.mul(B);
    }

    public void sub(ECP Q) {
        ECP NQ = new ECP(Q);
        NQ.neg();
        this.add(NQ);
    }

    public ECP pinmul(int e, int bts) {
        ECP P = new ECP();
        ECP R0 = new ECP();
        ECP R1 = new ECP();
        R1.copy(this);
        for (int i = bts - 1; i >= 0; --i) {
            int b = e >> i & 1;
            P.copy(R1);
            P.add(R0);
            R0.cswap(R1, b);
            R1.copy(P);
            R0.dbl();
            R0.cswap(R1, b);
        }
        P.copy(R0);
        P.affine();
        return P;
    }

    public ECP mul(BIG e) {
        int i;
        if (e.iszilch() || this.is_infinity()) {
            return new ECP();
        }
        ECP P = new ECP();
        BIG mt = new BIG();
        BIG t = new BIG();
        ECP Q = new ECP();
        ECP C = new ECP();
        ECP[] W = new ECP[8];
        byte[] w = new byte[141];
        Q.copy(this);
        Q.dbl();
        W[0] = new ECP();
        W[0].copy(this);
        for (i = 1; i < 8; ++i) {
            W[i] = new ECP();
            W[i].copy(W[i - 1]);
            W[i].add(Q);
        }
        t.copy(e);
        int s = t.parity();
        t.inc(1);
        t.norm();
        int ns = t.parity();
        mt.copy(t);
        mt.inc(1);
        mt.norm();
        t.cmove(mt, s);
        Q.cmove(this, ns);
        C.copy(Q);
        int nb = 1 + (t.nbits() + 3) / 4;
        for (i = 0; i < nb; ++i) {
            w[i] = (byte)(t.lastbits(5) - 16);
            t.dec(w[i]);
            t.norm();
            t.fshr(4);
        }
        w[nb] = (byte)t.lastbits(5);
        P.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            Q.select(W, w[i]);
            P.dbl();
            P.dbl();
            P.dbl();
            P.dbl();
            P.add(Q);
        }
        P.sub(C);
        P.affine();
        return P;
    }

    public ECP mul2(BIG e, ECP Q, BIG f) {
        int i;
        BIG te = new BIG();
        BIG tf = new BIG();
        BIG mt = new BIG();
        ECP S = new ECP();
        ECP T = new ECP();
        ECP C = new ECP();
        ECP[] W = new ECP[8];
        byte[] w = new byte[281];
        te.copy(e);
        tf.copy(f);
        W[1] = new ECP();
        W[1].copy(this);
        W[1].sub(Q);
        W[2] = new ECP();
        W[2].copy(this);
        W[2].add(Q);
        S.copy(Q);
        S.dbl();
        W[0] = new ECP();
        W[0].copy(W[1]);
        W[0].sub(S);
        W[3] = new ECP();
        W[3].copy(W[2]);
        W[3].add(S);
        T.copy(this);
        T.dbl();
        W[5] = new ECP();
        W[5].copy(W[1]);
        W[5].add(T);
        W[6] = new ECP();
        W[6].copy(W[2]);
        W[6].add(T);
        W[4] = new ECP();
        W[4].copy(W[5]);
        W[4].sub(S);
        W[7] = new ECP();
        W[7].copy(W[6]);
        W[7].add(S);
        int s = te.parity();
        te.inc(1);
        te.norm();
        int ns = te.parity();
        mt.copy(te);
        mt.inc(1);
        mt.norm();
        te.cmove(mt, s);
        T.cmove(this, ns);
        C.copy(T);
        s = tf.parity();
        tf.inc(1);
        tf.norm();
        ns = tf.parity();
        mt.copy(tf);
        mt.inc(1);
        mt.norm();
        tf.cmove(mt, s);
        S.cmove(Q, ns);
        C.add(S);
        mt.copy(te);
        mt.add(tf);
        mt.norm();
        int nb = 1 + (mt.nbits() + 1) / 2;
        for (i = 0; i < nb; ++i) {
            byte a = (byte)(te.lastbits(3) - 4);
            te.dec(a);
            te.norm();
            te.fshr(2);
            byte b = (byte)(tf.lastbits(3) - 4);
            tf.dec(b);
            tf.norm();
            tf.fshr(2);
            w[i] = (byte)(4 * a + b);
        }
        w[nb] = (byte)(4 * te.lastbits(3) + tf.lastbits(3));
        S.copy(W[(w[nb] - 1) / 2]);
        for (i = nb - 1; i >= 0; --i) {
            T.select(W, w[i]);
            S.dbl();
            S.dbl();
            S.add(T);
        }
        S.sub(C);
        S.affine();
        return S;
    }

    public void cfp() {
        int cf = 4;
        if (cf == 1) {
            return;
        }
        if (cf == 4) {
            this.dbl();
            this.dbl();
            return;
        }
        if (cf == 8) {
            this.dbl();
            this.dbl();
            this.dbl();
            return;
        }
        BIG c = new BIG(ROM.CURVE_Cof);
        this.copy(this.mul(c));
    }

    /*
     * Unable to fully structure code
     */
    public static ECP mapit(byte[] h) {
        q = new BIG(ROM.Modulus);
        x = BIG.fromBytes(h);
        x.mod(q);
        do lbl-1000:
        // 3 sources

        {
            P = new ECP(x, 0);
            x.inc(1);
            x.norm();
            if (P.is_infinity()) ** GOTO lbl-1000
            P.cfp();
        } while (P.is_infinity());
        return P;
    }

    public static ECP generator() {
        BIG gx = new BIG(ROM.CURVE_Gx);
        BIG gy = new BIG(ROM.CURVE_Gy);
        ECP G = new ECP(gx, gy);
        return G;
    }
}

