/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl.NUMS384W;

import org.apache.milagro.amcl.AES;
import org.apache.milagro.amcl.HASH256;
import org.apache.milagro.amcl.HASH384;
import org.apache.milagro.amcl.HASH512;
import org.apache.milagro.amcl.NUMS384W.BIG;
import org.apache.milagro.amcl.NUMS384W.ECP;
import org.apache.milagro.amcl.NUMS384W.ROM;
import org.apache.milagro.amcl.RAND;

public final class ECDH {
    public static final int INVALID_PUBLIC_KEY = -2;
    public static final int ERROR = -3;
    public static final int INVALID = -4;
    public static final int EFS = 48;
    public static final int EGS = 48;

    public static byte[] inttoBytes(int n, int len) {
        int i;
        byte[] b = new byte[len];
        for (i = 0; i < len; ++i) {
            b[i] = 0;
        }
        i = len;
        while (n > 0 && i > 0) {
            b[--i] = (byte)(n & 0xFF);
            n /= 256;
        }
        return b;
    }

    public static byte[] hashit(int sha, byte[] A, int n, byte[] B, int pad) {
        Object H;
        byte[] R = null;
        if (sha == 32) {
            H = new HASH256();
            ((HASH256)H).process_array(A);
            if (n > 0) {
                ((HASH256)H).process_num(n);
            }
            if (B != null) {
                ((HASH256)H).process_array(B);
            }
            R = ((HASH256)H).hash();
        }
        if (sha == 48) {
            H = new HASH384();
            ((HASH384)H).process_array(A);
            if (n > 0) {
                ((HASH384)H).process_num(n);
            }
            if (B != null) {
                ((HASH384)H).process_array(B);
            }
            R = ((HASH384)H).hash();
        }
        if (sha == 64) {
            H = new HASH512();
            ((HASH512)H).process_array(A);
            if (n > 0) {
                ((HASH512)H).process_num(n);
            }
            if (B != null) {
                ((HASH512)H).process_array(B);
            }
            R = ((HASH512)H).hash();
        }
        if (R == null) {
            return null;
        }
        if (pad == 0) {
            return R;
        }
        byte[] W = new byte[pad];
        if (pad <= sha) {
            for (int i = 0; i < pad; ++i) {
                W[i] = R[i];
            }
        } else {
            int i;
            for (i = 0; i < sha; ++i) {
                W[i + pad - sha] = R[i];
            }
            for (i = 0; i < pad - sha; ++i) {
                W[i] = 0;
            }
        }
        return W;
    }

    public static byte[] KDF1(int sha, byte[] Z, int olen) {
        int i;
        int hlen = sha;
        byte[] K = new byte[olen];
        int k = 0;
        for (i = 0; i < K.length; ++i) {
            K[i] = 0;
        }
        int cthreshold = olen / hlen;
        if (olen % hlen != 0) {
            ++cthreshold;
        }
        for (int counter = 0; counter < cthreshold; ++counter) {
            byte[] B = ECDH.hashit(sha, Z, counter, null, 0);
            if (k + hlen > olen) {
                for (i = 0; i < olen % hlen; ++i) {
                    K[k++] = B[i];
                }
                continue;
            }
            for (i = 0; i < hlen; ++i) {
                K[k++] = B[i];
            }
        }
        return K;
    }

    public static byte[] KDF2(int sha, byte[] Z, byte[] P, int olen) {
        int i;
        int hlen = sha;
        byte[] K = new byte[olen];
        int k = 0;
        for (i = 0; i < K.length; ++i) {
            K[i] = 0;
        }
        int cthreshold = olen / hlen;
        if (olen % hlen != 0) {
            ++cthreshold;
        }
        for (int counter = 1; counter <= cthreshold; ++counter) {
            byte[] B = ECDH.hashit(sha, Z, counter, P, 0);
            if (k + hlen > olen) {
                for (i = 0; i < olen % hlen; ++i) {
                    K[k++] = B[i];
                }
                continue;
            }
            for (i = 0; i < hlen; ++i) {
                K[k++] = B[i];
            }
        }
        return K;
    }

    public static byte[] PBKDF2(int sha, byte[] Pass, byte[] Salt, int rep, int olen) {
        int i;
        int d = olen / sha;
        if (olen % sha != 0) {
            ++d;
        }
        byte[] F = new byte[sha];
        byte[] U = new byte[sha];
        byte[] S = new byte[Salt.length + 4];
        byte[] K = new byte[d * sha];
        int opt = 0;
        for (i = 1; i <= d; ++i) {
            int j;
            for (j = 0; j < Salt.length; ++j) {
                S[j] = Salt[j];
            }
            byte[] N = ECDH.inttoBytes(i, 4);
            for (j = 0; j < 4; ++j) {
                S[Salt.length + j] = N[j];
            }
            ECDH.HMAC(sha, S, Pass, F);
            for (j = 0; j < sha; ++j) {
                U[j] = F[j];
            }
            for (j = 2; j <= rep; ++j) {
                ECDH.HMAC(sha, U, Pass, U);
                for (int k = 0; k < sha; ++k) {
                    int n = k;
                    F[n] = (byte)(F[n] ^ U[k]);
                }
            }
            for (j = 0; j < sha; ++j) {
                K[opt++] = F[j];
            }
        }
        byte[] key = new byte[olen];
        for (i = 0; i < olen; ++i) {
            key[i] = K[i];
        }
        return key;
    }

    public static int HMAC(int sha, byte[] M, byte[] K, byte[] tag) {
        byte[] B;
        int i;
        int b = 64;
        if (sha > 32) {
            b = 128;
        }
        byte[] K0 = new byte[b];
        int olen = tag.length;
        if (olen < 4) {
            return 0;
        }
        for (i = 0; i < b; ++i) {
            K0[i] = 0;
        }
        if (K.length > b) {
            B = ECDH.hashit(sha, K, 0, null, 0);
            for (i = 0; i < sha; ++i) {
                K0[i] = B[i];
            }
        } else {
            for (i = 0; i < K.length; ++i) {
                K0[i] = K[i];
            }
        }
        i = 0;
        while (i < b) {
            int n = i++;
            K0[n] = (byte)(K0[n] ^ 0x36);
        }
        B = ECDH.hashit(sha, K0, 0, M, 0);
        i = 0;
        while (i < b) {
            int n = i++;
            K0[n] = (byte)(K0[n] ^ 0x6A);
        }
        B = ECDH.hashit(sha, K0, 0, B, olen);
        for (i = 0; i < olen; ++i) {
            tag[i] = B[i];
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] AES_CBC_IV0_ENCRYPT(byte[] K, byte[] M) {
        a = new AES();
        buff = new byte[16];
        clen = 16 + M.length / 16 * 16;
        C = new byte[clen];
        a.init(1, K.length, K, null);
        opt = 0;
        ipt = 0;
        fin = false;
        while (true) {
            for (i = 0; i < 16; ++i) {
                if (ipt >= M.length) {
                    fin = true;
                    break;
                }
                buff[i] = M[ipt++];
            }
            if (fin) break;
            a.encrypt(buff);
            i = 0;
            while (true) {
                if (i >= 16) ** continue;
                C[opt++] = buff[i];
                ++i;
            }
            break;
        }
        padlen = 16 - i;
        for (j = i; j < 16; ++j) {
            buff[j] = (byte)padlen;
        }
        a.encrypt(buff);
        for (i = 0; i < 16; ++i) {
            C[opt++] = buff[i];
        }
        a.end();
        return C;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] AES_CBC_IV0_DECRYPT(byte[] K, byte[] C) {
        a = new AES();
        buff = new byte[16];
        MM = new byte[C.length];
        opt = 0;
        ipt = 0;
        a.init(1, K.length, K, null);
        if (C.length == 0) {
            return new byte[0];
        }
        ch = C[ipt++];
        fin = false;
        while (true) {
            for (i = 0; i < 16; ++i) {
                buff[i] = ch;
                if (ipt >= C.length) {
                    fin = true;
                    break;
                }
                ch = C[ipt++];
            }
            a.decrypt(buff);
            if (fin) break;
            i = 0;
            while (true) {
                if (i >= 16) ** continue;
                MM[opt++] = buff[i];
                ++i;
            }
            break;
        }
        a.end();
        bad = false;
        padlen = buff[15];
        if (i != 15 || padlen < 1 || padlen > 16) {
            bad = true;
        }
        if (padlen >= 2 && padlen <= 16) {
            for (i = 16 - padlen; i < 16; ++i) {
                if (buff[i] == padlen) continue;
                bad = true;
            }
        }
        if (!bad) {
            for (i = 0; i < 16 - padlen; ++i) {
                MM[opt++] = buff[i];
            }
        }
        if (bad) {
            return new byte[0];
        }
        M = new byte[opt];
        for (i = 0; i < opt; ++i) {
            M[i] = MM[i];
        }
        return M;
    }

    public static int KEY_PAIR_GENERATE(RAND RNG, byte[] S, byte[] W) {
        BIG s;
        int res = 0;
        ECP G = ECP.generator();
        BIG r = new BIG(ROM.CURVE_Order);
        if (RNG == null) {
            s = BIG.fromBytes(S);
            s.mod(r);
        } else {
            s = BIG.randomnum(r, RNG);
        }
        s.toBytes(S);
        ECP WP = G.mul(s);
        WP.toBytes(W, false);
        return res;
    }

    public static int PUBLIC_KEY_VALIDATE(byte[] W) {
        ECP WP = ECP.fromBytes(W);
        int res = 0;
        BIG r = new BIG(ROM.CURVE_Order);
        if (WP.is_infinity()) {
            res = -2;
        }
        if (res == 0) {
            BIG q = new BIG(ROM.Modulus);
            int nb = q.nbits();
            BIG k = new BIG(1);
            k.shl((nb + 4) / 2);
            k.add(q);
            k.div(r);
            while (k.parity() == 0) {
                k.shr(1);
                WP.dbl();
            }
            if (!k.isunity()) {
                WP = WP.mul(k);
            }
            if (WP.is_infinity()) {
                res = -2;
            }
        }
        return res;
    }

    public static int SVDP_DH(byte[] S, byte[] WD, byte[] Z) {
        int res = 0;
        byte[] T = new byte[48];
        BIG s = BIG.fromBytes(S);
        ECP W = ECP.fromBytes(WD);
        if (W.is_infinity()) {
            res = -3;
        }
        if (res == 0) {
            BIG r = new BIG(ROM.CURVE_Order);
            s.mod(r);
            W = W.mul(s);
            if (W.is_infinity()) {
                res = -3;
            } else {
                W.getX().toBytes(T);
                for (int i = 0; i < 48; ++i) {
                    Z[i] = T[i];
                }
            }
        }
        return res;
    }

    public static int SP_DSA(int sha, RAND RNG, byte[] S, byte[] F, byte[] C, byte[] D) {
        int i;
        byte[] T = new byte[48];
        byte[] B = ECDH.hashit(sha, F, 0, null, 48);
        ECP G = ECP.generator();
        BIG r = new BIG(ROM.CURVE_Order);
        BIG s = BIG.fromBytes(S);
        BIG f = BIG.fromBytes(B);
        BIG c = new BIG(0);
        BIG d = new BIG(0);
        ECP V = new ECP();
        do {
            BIG u = BIG.randomnum(r, RNG);
            BIG w = BIG.randomnum(r, RNG);
            V.copy(G);
            V = V.mul(u);
            BIG vx = V.getX();
            c.copy(vx);
            c.mod(r);
            if (c.iszilch()) continue;
            u.copy(BIG.modmul(u, w, r));
            u.invmodp(r);
            d.copy(BIG.modmul(s, c, r));
            d.add(f);
            d.copy(BIG.modmul(d, w, r));
            d.copy(BIG.modmul(u, d, r));
        } while (d.iszilch());
        c.toBytes(T);
        for (i = 0; i < 48; ++i) {
            C[i] = T[i];
        }
        d.toBytes(T);
        for (i = 0; i < 48; ++i) {
            D[i] = T[i];
        }
        return 0;
    }

    public static int VP_DSA(int sha, byte[] W, byte[] F, byte[] C, byte[] D) {
        int res = 0;
        byte[] B = ECDH.hashit(sha, F, 0, null, 48);
        ECP G = ECP.generator();
        BIG r = new BIG(ROM.CURVE_Order);
        BIG c = BIG.fromBytes(C);
        BIG d = BIG.fromBytes(D);
        BIG f = BIG.fromBytes(B);
        if (c.iszilch() || BIG.comp(c, r) >= 0 || d.iszilch() || BIG.comp(d, r) >= 0) {
            res = -4;
        }
        if (res == 0) {
            d.invmodp(r);
            f.copy(BIG.modmul(f, d, r));
            BIG h2 = BIG.modmul(c, d, r);
            ECP WP = ECP.fromBytes(W);
            if (WP.is_infinity()) {
                res = -3;
            } else {
                ECP P = new ECP();
                P.copy(WP);
                P = P.mul2(h2, G, f);
                if (P.is_infinity()) {
                    res = -4;
                } else {
                    d = P.getX();
                    d.mod(r);
                    if (BIG.comp(d, c) != 0) {
                        res = -4;
                    }
                }
            }
        }
        return res;
    }

    public static byte[] ECIES_ENCRYPT(int sha, byte[] P1, byte[] P2, RAND RNG, byte[] W, byte[] M, byte[] V, byte[] T) {
        int i;
        byte[] Z = new byte[48];
        byte[] VZ = new byte[145];
        byte[] K1 = new byte[24];
        byte[] K2 = new byte[24];
        byte[] U = new byte[48];
        if (ECDH.KEY_PAIR_GENERATE(RNG, U, V) != 0) {
            return new byte[0];
        }
        if (ECDH.SVDP_DH(U, W, Z) != 0) {
            return new byte[0];
        }
        for (i = 0; i < 97; ++i) {
            VZ[i] = V[i];
        }
        for (i = 0; i < 48; ++i) {
            VZ[97 + i] = Z[i];
        }
        byte[] K = ECDH.KDF2(sha, VZ, P1, 48);
        for (i = 0; i < 24; ++i) {
            K1[i] = K[i];
            K2[i] = K[24 + i];
        }
        byte[] C = ECDH.AES_CBC_IV0_ENCRYPT(K1, M);
        byte[] L2 = ECDH.inttoBytes(P2.length, 8);
        byte[] AC = new byte[C.length + P2.length + 8];
        for (i = 0; i < C.length; ++i) {
            AC[i] = C[i];
        }
        for (i = 0; i < P2.length; ++i) {
            AC[C.length + i] = P2[i];
        }
        for (i = 0; i < 8; ++i) {
            AC[C.length + P2.length + i] = L2[i];
        }
        ECDH.HMAC(sha, AC, K2, T);
        return C;
    }

    public static byte[] ECIES_DECRYPT(int sha, byte[] P1, byte[] P2, byte[] V, byte[] C, byte[] T, byte[] U) {
        int i;
        byte[] Z = new byte[48];
        byte[] VZ = new byte[145];
        byte[] K1 = new byte[24];
        byte[] K2 = new byte[24];
        byte[] TAG = new byte[T.length];
        if (ECDH.SVDP_DH(U, V, Z) != 0) {
            return new byte[0];
        }
        for (i = 0; i < 97; ++i) {
            VZ[i] = V[i];
        }
        for (i = 0; i < 48; ++i) {
            VZ[97 + i] = Z[i];
        }
        byte[] K = ECDH.KDF2(sha, VZ, P1, 48);
        for (i = 0; i < 24; ++i) {
            K1[i] = K[i];
            K2[i] = K[24 + i];
        }
        byte[] M = ECDH.AES_CBC_IV0_DECRYPT(K1, C);
        if (M.length == 0) {
            return M;
        }
        byte[] L2 = ECDH.inttoBytes(P2.length, 8);
        byte[] AC = new byte[C.length + P2.length + 8];
        for (i = 0; i < C.length; ++i) {
            AC[i] = C[i];
        }
        for (i = 0; i < P2.length; ++i) {
            AC[C.length + i] = P2[i];
        }
        for (i = 0; i < 8; ++i) {
            AC[C.length + P2.length + i] = L2[i];
        }
        ECDH.HMAC(sha, AC, K2, TAG);
        boolean same = true;
        for (i = 0; i < T.length; ++i) {
            if (T[i] == TAG[i]) continue;
            same = false;
        }
        if (!same) {
            return new byte[0];
        }
        return M;
    }
}

