/*
 * Decompiled with CFR 0.152.
 */
package org.apache.milagro.amcl;

public class HASH512 {
    private long[] length = new long[2];
    private long[] h = new long[8];
    private long[] w = new long[80];
    public static final long H0 = 7640891576956012808L;
    public static final long H1 = -4942790177534073029L;
    public static final long H2 = 4354685564936845355L;
    public static final long H3 = -6534734903238641935L;
    public static final long H4 = 5840696475078001361L;
    public static final long H5 = -7276294671716946913L;
    public static final long H6 = 2270897969802886507L;
    public static final long H7 = 6620516959819538809L;
    public static final int len = 64;
    public static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};

    private static long S(int n, long x) {
        return x >>> n | x << 64 - n;
    }

    private static long R(int n, long x) {
        return x >>> n;
    }

    private static long Ch(long x, long y, long z) {
        return x & y ^ (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private static long Maj(long x, long y, long z) {
        return x & y ^ x & z ^ y & z;
    }

    private static long Sig0(long x) {
        return HASH512.S(28, x) ^ HASH512.S(34, x) ^ HASH512.S(39, x);
    }

    private static long Sig1(long x) {
        return HASH512.S(14, x) ^ HASH512.S(18, x) ^ HASH512.S(41, x);
    }

    private static long theta0(long x) {
        return HASH512.S(1, x) ^ HASH512.S(8, x) ^ HASH512.R(7, x);
    }

    private static long theta1(long x) {
        return HASH512.S(19, x) ^ HASH512.S(61, x) ^ HASH512.R(6, x);
    }

    private void transform() {
        int j;
        for (j = 16; j < 80; ++j) {
            this.w[j] = HASH512.theta1(this.w[j - 2]) + this.w[j - 7] + HASH512.theta0(this.w[j - 15]) + this.w[j - 16];
        }
        long a = this.h[0];
        long b = this.h[1];
        long c = this.h[2];
        long d = this.h[3];
        long e = this.h[4];
        long f = this.h[5];
        long g = this.h[6];
        long hh = this.h[7];
        for (j = 0; j < 80; ++j) {
            long t1 = hh + HASH512.Sig1(e) + HASH512.Ch(e, f, g) + K[j] + this.w[j];
            long t2 = HASH512.Sig0(a) + HASH512.Maj(a, b, c);
            hh = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t2;
        }
        this.h[0] = this.h[0] + a;
        this.h[1] = this.h[1] + b;
        this.h[2] = this.h[2] + c;
        this.h[3] = this.h[3] + d;
        this.h[4] = this.h[4] + e;
        this.h[5] = this.h[5] + f;
        this.h[6] = this.h[6] + g;
        this.h[7] = this.h[7] + hh;
    }

    public void init() {
        for (int i = 0; i < 80; ++i) {
            this.w[i] = 0L;
        }
        this.length[1] = 0L;
        this.length[0] = 0L;
        this.h[0] = 7640891576956012808L;
        this.h[1] = -4942790177534073029L;
        this.h[2] = 4354685564936845355L;
        this.h[3] = -6534734903238641935L;
        this.h[4] = 5840696475078001361L;
        this.h[5] = -7276294671716946913L;
        this.h[6] = 2270897969802886507L;
        this.h[7] = 6620516959819538809L;
    }

    public HASH512() {
        this.init();
    }

    public void process(int byt) {
        int cnt;
        int n = cnt = (int)(this.length[0] / 64L) % 16;
        this.w[n] = this.w[n] << 8;
        int n2 = cnt;
        this.w[n2] = this.w[n2] | (long)(byt & 0xFF);
        this.length[0] = this.length[0] + 8L;
        if (this.length[0] == 0L) {
            this.length[1] = this.length[1] + 1L;
            this.length[0] = 0L;
        }
        if (this.length[0] % 1024L == 0L) {
            this.transform();
        }
    }

    public void process_array(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            this.process(b[i]);
        }
    }

    public void process_num(int n) {
        this.process(n >> 24 & 0xFF);
        this.process(n >> 16 & 0xFF);
        this.process(n >> 8 & 0xFF);
        this.process(n & 0xFF);
    }

    public byte[] hash() {
        byte[] digest = new byte[64];
        long len0 = this.length[0];
        long len1 = this.length[1];
        this.process(128);
        while (this.length[0] % 1024L != 896L) {
            this.process(0);
        }
        this.w[14] = len1;
        this.w[15] = len0;
        this.transform();
        for (int i = 0; i < 64; ++i) {
            digest[i] = (byte)(this.h[i / 8] >> 8 * (7 - i % 8) & 0xFFL);
        }
        this.init();
        return digest;
    }

    public static void main(String[] args) {
        int i;
        byte[] test = "abcdefghbcdefghicdefghijdefghijkefghijklfghijklmghijklmnhijklmnoijklmnopjklmnopqklmnopqrlmnopqrsmnopqrstnopqrstu".getBytes();
        HASH512 sh = new HASH512();
        for (i = 0; i < test.length; ++i) {
            sh.process(test[i]);
        }
        byte[] digest = sh.hash();
        for (i = 0; i < 64; ++i) {
            System.out.format("%02x", digest[i]);
        }
        System.out.println("");
    }
}

