/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsname;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import org.minidns.dnslabel.DnsLabel;
import org.minidns.dnsname.InvalidDnsNameException;
import org.minidns.idna.MiniDnsIdna;

public class DnsName
implements CharSequence,
Serializable,
Comparable<DnsName> {
    private static final long serialVersionUID = 1L;
    private static final String LABEL_SEP_REGEX = "[.\u3002\uff0e\uff61]";
    static final int MAX_DNSNAME_LENGTH_IN_OCTETS = 255;
    public static final int MAX_LABELS = 128;
    public static final DnsName ROOT = new DnsName(".");
    public static final DnsName IN_ADDR_ARPA = new DnsName("in-addr.arpa");
    public static final DnsName IP6_ARPA = new DnsName("ip6.arpa");
    public static boolean VALIDATE = true;
    public final String ace;
    private final String rawAce;
    private transient byte[] bytes;
    private transient byte[] rawBytes;
    private transient String idn;
    private transient String domainpart;
    private transient String hostpart;
    private transient DnsLabel[] labels;
    private transient DnsLabel[] rawLabels;
    private transient int hashCode;
    private int size = -1;

    private DnsName(String name) {
        this(name, true);
    }

    private DnsName(String name, boolean inAce) {
        if (name.isEmpty()) {
            this.rawAce = DnsName.ROOT.rawAce;
        } else {
            int nameLength = name.length();
            int nameLastPos = nameLength - 1;
            if (nameLength >= 2 && name.charAt(nameLastPos) == '.') {
                name = name.subSequence(0, nameLastPos).toString();
            }
            this.rawAce = inAce ? name : MiniDnsIdna.toASCII(name);
        }
        this.ace = this.rawAce.toLowerCase(Locale.US);
        if (!VALIDATE) {
            return;
        }
        this.validateMaxDnsnameLengthInOctets();
    }

    private DnsName(DnsLabel[] rawLabels, boolean validateMaxDnsnameLength) {
        this.rawLabels = rawLabels;
        this.labels = new DnsLabel[rawLabels.length];
        int size = 0;
        for (int i = 0; i < rawLabels.length; ++i) {
            size += rawLabels[i].length() + 1;
            this.labels[i] = rawLabels[i].asLowercaseVariant();
        }
        this.rawAce = DnsName.labelsToString(rawLabels, size);
        this.ace = DnsName.labelsToString(this.labels, size);
        if (!validateMaxDnsnameLength || !VALIDATE) {
            return;
        }
        this.validateMaxDnsnameLengthInOctets();
    }

    private static String labelsToString(DnsLabel[] labels, int stringLength) {
        StringBuilder sb = new StringBuilder(stringLength);
        for (int i = labels.length - 1; i >= 0; --i) {
            sb.append(labels[i]).append('.');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void validateMaxDnsnameLengthInOctets() {
        this.setBytesIfRequired();
        if (this.bytes.length > 255) {
            throw new InvalidDnsNameException.DNSNameTooLongException(this.ace, this.bytes);
        }
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.setBytesIfRequired();
        os.write(this.bytes);
    }

    public byte[] getBytes() {
        this.setBytesIfRequired();
        return (byte[])this.bytes.clone();
    }

    public byte[] getRawBytes() {
        if (this.rawBytes == null) {
            this.setLabelsIfRequired();
            this.rawBytes = DnsName.toBytes(this.rawLabels);
        }
        return (byte[])this.rawBytes.clone();
    }

    private void setBytesIfRequired() {
        if (this.bytes != null) {
            return;
        }
        this.setLabelsIfRequired();
        this.bytes = DnsName.toBytes(this.labels);
    }

    private static byte[] toBytes(DnsLabel[] labels) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        for (int i = labels.length - 1; i >= 0; --i) {
            labels[i].writeToBoas(baos);
        }
        baos.write(0);
        assert (baos.size() <= 255);
        return baos.toByteArray();
    }

    private void setLabelsIfRequired() {
        if (this.labels != null && this.rawLabels != null) {
            return;
        }
        if (this.isRootLabel()) {
            this.labels = new DnsLabel[0];
            this.rawLabels = this.labels;
            return;
        }
        this.labels = DnsName.getLabels(this.ace);
        this.rawLabels = DnsName.getLabels(this.rawAce);
    }

    private static DnsLabel[] getLabels(String ace) {
        String[] labels = ace.split(LABEL_SEP_REGEX, 128);
        for (int i = 0; i < labels.length / 2; ++i) {
            String t = labels[i];
            int j = labels.length - i - 1;
            labels[i] = labels[j];
            labels[j] = t;
        }
        try {
            return DnsLabel.from(labels);
        }
        catch (DnsLabel.LabelToLongException e) {
            throw new InvalidDnsNameException.LabelTooLongException(ace, e.label);
        }
    }

    public String getRawAce() {
        return this.rawAce;
    }

    public String asIdn() {
        if (this.idn != null) {
            return this.idn;
        }
        this.idn = MiniDnsIdna.toUnicode(this.ace);
        return this.idn;
    }

    public String getDomainpart() {
        this.setHostnameAndDomainpartIfRequired();
        return this.domainpart;
    }

    public String getHostpart() {
        this.setHostnameAndDomainpartIfRequired();
        return this.hostpart;
    }

    private void setHostnameAndDomainpartIfRequired() {
        if (this.hostpart != null) {
            return;
        }
        String[] parts = this.ace.split(LABEL_SEP_REGEX, 2);
        this.hostpart = parts[0];
        this.domainpart = parts.length > 1 ? parts[1] : "";
    }

    public int size() {
        if (this.size < 0) {
            this.size = this.isRootLabel() ? 1 : this.ace.length() + 2;
        }
        return this.size;
    }

    @Override
    public int length() {
        return this.ace.length();
    }

    @Override
    public char charAt(int index) {
        return this.ace.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.ace.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.ace;
    }

    public static DnsName from(CharSequence name) {
        return DnsName.from(name.toString());
    }

    public static DnsName from(String name) {
        return new DnsName(name, false);
    }

    public static DnsName from(DnsName child, DnsName parent) {
        child.setLabelsIfRequired();
        parent.setLabelsIfRequired();
        DnsLabel[] rawLabels = new DnsLabel[child.rawLabels.length + parent.rawLabels.length];
        System.arraycopy(parent.rawLabels, 0, rawLabels, 0, parent.rawLabels.length);
        System.arraycopy(child.rawLabels, 0, rawLabels, parent.rawLabels.length, child.rawLabels.length);
        return new DnsName(rawLabels, true);
    }

    public static DnsName from(DnsName ... nameComponents) {
        int labelCount = 0;
        for (DnsName component : nameComponents) {
            component.setLabelsIfRequired();
            labelCount += component.rawLabels.length;
        }
        DnsLabel[] rawLabels = new DnsLabel[labelCount];
        int destLabelPos = 0;
        for (int i = nameComponents.length - 1; i >= 0; --i) {
            DnsName component;
            component = nameComponents[i];
            System.arraycopy(component.rawLabels, 0, rawLabels, destLabelPos, component.rawLabels.length);
            destLabelPos += component.rawLabels.length;
        }
        return new DnsName(rawLabels, true);
    }

    public static DnsName from(String[] parts) {
        DnsLabel[] rawLabels = DnsLabel.from(parts);
        return new DnsName(rawLabels, true);
    }

    public static DnsName parse(DataInputStream dis, byte[] data) throws IOException {
        int c = dis.readUnsignedByte();
        if ((c & 0xC0) == 192) {
            c = ((c & 0x3F) << 8) + dis.readUnsignedByte();
            HashSet<Integer> jumps = new HashSet<Integer>();
            jumps.add(c);
            return DnsName.parse(data, c, jumps);
        }
        if (c == 0) {
            return ROOT;
        }
        byte[] b = new byte[c];
        dis.readFully(b);
        String childLabelString = new String(b);
        DnsName child = new DnsName(childLabelString);
        DnsName parent = DnsName.parse(dis, data);
        return DnsName.from(child, parent);
    }

    private static DnsName parse(byte[] data, int offset, HashSet<Integer> jumps) throws IllegalStateException {
        int c = data[offset] & 0xFF;
        if ((c & 0xC0) == 192) {
            if (jumps.contains(c = ((c & 0x3F) << 8) + (data[offset + 1] & 0xFF))) {
                throw new IllegalStateException("Cyclic offsets detected.");
            }
            jumps.add(c);
            return DnsName.parse(data, c, jumps);
        }
        if (c == 0) {
            return ROOT;
        }
        String childLabelString = new String(data, offset + 1, c);
        DnsName child = new DnsName(childLabelString);
        DnsName parent = DnsName.parse(data, offset + 1 + c, jumps);
        return DnsName.from(child, parent);
    }

    @Override
    public int compareTo(DnsName other) {
        return this.ace.compareTo(other.ace);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof DnsName) {
            DnsName otherDnsName = (DnsName)other;
            this.setBytesIfRequired();
            otherDnsName.setBytesIfRequired();
            return Arrays.equals(this.bytes, otherDnsName.bytes);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0 && !this.isRootLabel()) {
            this.setBytesIfRequired();
            this.hashCode = Arrays.hashCode(this.bytes);
        }
        return this.hashCode;
    }

    public boolean isDirectChildOf(DnsName parent) {
        this.setLabelsIfRequired();
        parent.setLabelsIfRequired();
        int parentLabelsCount = parent.labels.length;
        if (this.labels.length - 1 != parentLabelsCount) {
            return false;
        }
        for (int i = 0; i < parent.labels.length; ++i) {
            if (this.labels[i].equals(parent.labels[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isChildOf(DnsName parent) {
        this.setLabelsIfRequired();
        parent.setLabelsIfRequired();
        if (this.labels.length < parent.labels.length) {
            return false;
        }
        for (int i = 0; i < parent.labels.length; ++i) {
            if (this.labels[i].equals(parent.labels[i])) continue;
            return false;
        }
        return true;
    }

    public int getLabelCount() {
        this.setLabelsIfRequired();
        return this.labels.length;
    }

    public DnsLabel[] getLabels() {
        this.setLabelsIfRequired();
        return (DnsLabel[])this.labels.clone();
    }

    public DnsLabel[] getRawLabels() {
        this.setLabelsIfRequired();
        return (DnsLabel[])this.rawLabels.clone();
    }

    public DnsName stripToLabels(int labelCount) {
        this.setLabelsIfRequired();
        if (labelCount > this.labels.length) {
            throw new IllegalArgumentException();
        }
        if (labelCount == this.labels.length) {
            return this;
        }
        if (labelCount == 0) {
            return ROOT;
        }
        DnsLabel[] stripedLabels = Arrays.copyOfRange(this.rawLabels, 0, labelCount);
        return new DnsName(stripedLabels, false);
    }

    public DnsName getParent() {
        if (this.isRootLabel()) {
            return ROOT;
        }
        return this.stripToLabels(this.getLabelCount() - 1);
    }

    public boolean isRootLabel() {
        return this.ace.isEmpty() || this.ace.equals(".");
    }
}

