/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsserverlookup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.minidns.dnsserverlookup.AbstractDnsServerLookupMechanism;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;
import org.minidns.util.PlatformDetection;

public final class UnixUsingEtcResolvConf
extends AbstractDnsServerLookupMechanism {
    public static final DnsServerLookupMechanism INSTANCE = new UnixUsingEtcResolvConf();
    public static final int PRIORITY = 2000;
    private static final Logger LOGGER = Logger.getLogger(UnixUsingEtcResolvConf.class.getName());
    private static final String RESOLV_CONF_FILE = "/etc/resolv.conf";
    private static final Pattern NAMESERVER_PATTERN = Pattern.compile("^nameserver\\s+(.*)$");
    private static List<String> cached;
    private static long lastModified;

    private UnixUsingEtcResolvConf() {
        super(UnixUsingEtcResolvConf.class.getSimpleName(), 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDnsServerAddresses() {
        File file = new File(RESOLV_CONF_FILE);
        if (!file.exists()) {
            return null;
        }
        long currentLastModified = file.lastModified();
        if (currentLastModified == lastModified && cached != null) {
            return cached;
        }
        ArrayList<String> servers = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = NAMESERVER_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                servers.add(matcher.group(1).trim());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not read from /etc/resolv.conf", e);
            List<String> list = null;
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Could not close reader", e);
                }
            }
        }
        if (servers.isEmpty()) {
            LOGGER.fine("Could not find any nameservers in /etc/resolv.conf");
            return null;
        }
        cached = servers;
        lastModified = currentLastModified;
        return cached;
    }

    @Override
    public boolean isAvailable() {
        boolean resolvConfFileExists;
        if (PlatformDetection.isAndroid()) {
            return false;
        }
        File file = new File(RESOLV_CONF_FILE);
        try {
            resolvConfFileExists = file.exists();
        }
        catch (SecurityException securityException) {
            LOGGER.log(Level.FINE, "Access to /etc/resolv.conf not possible", securityException);
            return false;
        }
        return resolvConfFileExists;
    }
}

