/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.minidns.util.CallbackRecipient;
import org.minidns.util.ExceptionCallback;
import org.minidns.util.MultipleIoException;
import org.minidns.util.SuccessCallback;

public abstract class MiniDnsFuture<V, E extends Exception>
implements Future<V>,
CallbackRecipient<V, E> {
    private boolean cancelled;
    protected V result;
    protected E exception;
    private SuccessCallback<V> successCallback;
    private ExceptionCallback<E> exceptionCallback;
    private static final ExecutorService EXECUTOR_SERVICE;

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        if (mayInterruptIfRunning) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.hasResult() || this.hasException();
    }

    public final synchronized boolean hasResult() {
        return this.result != null;
    }

    public final synchronized boolean hasException() {
        return this.exception != null;
    }

    public CallbackRecipient<V, E> onSuccess(SuccessCallback<V> successCallback) {
        this.successCallback = successCallback;
        this.maybeInvokeCallbacks();
        return this;
    }

    public CallbackRecipient<V, E> onError(ExceptionCallback<E> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        this.maybeInvokeCallbacks();
        return this;
    }

    private V getOrThrowExecutionException() throws ExecutionException {
        assert (this.result != null || this.exception != null || this.cancelled);
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            throw new ExecutionException((Throwable)this.exception);
        }
        assert (this.cancelled);
        throw new CancellationException();
    }

    @Override
    public final synchronized V get() throws InterruptedException, ExecutionException {
        while (this.result == null && this.exception == null && !this.cancelled) {
            this.wait();
        }
        return this.getOrThrowExecutionException();
    }

    public final synchronized V getOrThrow() throws E {
        while (this.result == null && this.exception == null && !this.cancelled) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        assert (this.result != null);
        return this.result;
    }

    @Override
    public final synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.result != null && this.exception != null && !this.cancelled) {
            long waitTimeRemaining = deadline - System.currentTimeMillis();
            if (waitTimeRemaining <= 0L) continue;
            this.wait(waitTimeRemaining);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.result == null || this.exception == null) {
            throw new TimeoutException();
        }
        return this.getOrThrowExecutionException();
    }

    protected final synchronized void maybeInvokeCallbacks() {
        if (this.cancelled) {
            return;
        }
        if (this.result != null && this.successCallback != null) {
            EXECUTOR_SERVICE.submit(new Runnable(){

                @Override
                public void run() {
                    MiniDnsFuture.this.successCallback.onSuccess(MiniDnsFuture.this.result);
                }
            });
        } else if (this.exception != null && this.exceptionCallback != null) {
            EXECUTOR_SERVICE.submit(new Runnable(){

                @Override
                public void run() {
                    MiniDnsFuture.this.exceptionCallback.processException(MiniDnsFuture.this.exception);
                }
            });
        }
    }

    public static <V, E extends Exception> MiniDnsFuture<V, E> from(V result) {
        InternalMiniDnsFuture future = new InternalMiniDnsFuture();
        future.setResult(result);
        return future;
    }

    public static <V> MiniDnsFuture<V, IOException> anySuccessfulOf(Collection<MiniDnsFuture<V, IOException>> futures) {
        return MiniDnsFuture.anySuccessfulOf(futures, exceptions -> MultipleIoException.toIOException((List)exceptions));
    }

    public static <V, EI extends Exception, EO extends Exception> MiniDnsFuture<V, EO> anySuccessfulOf(final Collection<MiniDnsFuture<V, EI>> futures, final ExceptionsWrapper<EI, EO> exceptionsWrapper) {
        final InternalMiniDnsFuture returnedFuture = new InternalMiniDnsFuture();
        final List exceptions = Collections.synchronizedList(new ArrayList(futures.size()));
        for (MiniDnsFuture<V, EI> future : futures) {
            future.onSuccess(new SuccessCallback<V>(){

                public void onSuccess(V result) {
                    for (MiniDnsFuture futureToCancel : futures) {
                        futureToCancel.cancel(true);
                    }
                    returnedFuture.setResult(result);
                }
            });
            future.onError(new ExceptionCallback<EI>(){

                public void processException(EI exception) {
                    exceptions.add(exception);
                    if (exceptions.size() == futures.size()) {
                        Object returnedException = exceptionsWrapper.wrap(exceptions);
                        returnedFuture.setException(returnedException);
                    }
                }
            });
        }
        return returnedFuture;
    }

    static {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName("MiniDnsFuture Thread");
                return thread;
            }
        };
        ArrayBlockingQueue<Runnable> blockingQueue = new ArrayBlockingQueue<Runnable>(128);
        RejectedExecutionHandler rejectedExecutionHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                r.run();
            }
        };
        int cores = Runtime.getRuntime().availableProcessors();
        int maximumPoolSize = cores <= 4 ? 2 : cores;
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, maximumPoolSize, 60L, TimeUnit.SECONDS, blockingQueue, threadFactory, rejectedExecutionHandler);
        EXECUTOR_SERVICE = executorService;
    }

    public static interface ExceptionsWrapper<EI extends Exception, EO extends Exception> {
        public EO wrap(List<EI> var1);
    }

    public static class InternalMiniDnsFuture<V, E extends Exception>
    extends MiniDnsFuture<V, E> {
        public final synchronized void setResult(V result) {
            if (this.isDone()) {
                return;
            }
            this.result = result;
            this.notifyAll();
            this.maybeInvokeCallbacks();
        }

        public final synchronized void setException(E exception) {
            if (this.isDone()) {
                return;
            }
            this.exception = exception;
            this.notifyAll();
            this.maybeInvokeCallbacks();
        }
    }
}

