/*
 * Decompiled with CFR 0.152.
 */
package org.minidns;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import org.minidns.AbstractDnsClient;
import org.minidns.DnsCache;
import org.minidns.MiniDnsException;
import org.minidns.MiniDnsFuture;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsqueryresult.CachedDnsQueryResult;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnsserverlookup.AndroidUsingExec;
import org.minidns.dnsserverlookup.AndroidUsingReflection;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;
import org.minidns.dnsserverlookup.UnixUsingEtcResolvConf;
import org.minidns.record.Record;
import org.minidns.util.CollectionsUtil;
import org.minidns.util.InetAddressUtil;
import org.minidns.util.MultipleIoException;

public class DnsClient
extends AbstractDnsClient {
    static final List<DnsServerLookupMechanism> LOOKUP_MECHANISMS = new CopyOnWriteArrayList<DnsServerLookupMechanism>();
    static final Set<Inet4Address> STATIC_IPV4_DNS_SERVERS = new CopyOnWriteArraySet<Inet4Address>();
    static final Set<Inet6Address> STATIC_IPV6_DNS_SERVERS = new CopyOnWriteArraySet<Inet6Address>();
    private static final Set<String> blacklistedDnsServers;
    private final Set<InetAddress> nonRaServers = Collections.newSetFromMap(new ConcurrentHashMap(4));
    private boolean askForDnssec = false;
    private boolean disableResultFilter = false;
    private boolean useHardcodedDnsServers = true;

    public DnsClient() {
    }

    public DnsClient(DnsCache dnsCache) {
        super(dnsCache);
    }

    @Override
    protected DnsMessage.Builder newQuestion(DnsMessage.Builder message) {
        message.setRecursionDesired(true);
        message.getEdnsBuilder().setUdpPayloadSize(this.dataSource.getUdpPayloadSize()).setDnssecOk(this.askForDnssec);
        return message;
    }

    private List<InetAddress> getServerAddresses() {
        List<InetAddress> dnsServerAddresses = DnsClient.findDnsAddresses();
        if (this.useHardcodedDnsServers) {
            InetAddress primaryHardcodedDnsServer;
            InetAddress secondaryHardcodedDnsServer = null;
            switch (this.ipVersionSetting) {
                case v4v6: {
                    primaryHardcodedDnsServer = this.getRandomHardcodedIpv4DnsServer();
                    secondaryHardcodedDnsServer = this.getRandomHarcodedIpv6DnsServer();
                    break;
                }
                case v6v4: {
                    primaryHardcodedDnsServer = this.getRandomHarcodedIpv6DnsServer();
                    secondaryHardcodedDnsServer = this.getRandomHardcodedIpv4DnsServer();
                    break;
                }
                case v4only: {
                    primaryHardcodedDnsServer = this.getRandomHardcodedIpv4DnsServer();
                    break;
                }
                case v6only: {
                    primaryHardcodedDnsServer = this.getRandomHarcodedIpv6DnsServer();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown ipVersionSetting: " + (Object)((Object)this.ipVersionSetting)));
                }
            }
            dnsServerAddresses.add(primaryHardcodedDnsServer);
            if (secondaryHardcodedDnsServer != null) {
                dnsServerAddresses.add(secondaryHardcodedDnsServer);
            }
        }
        return dnsServerAddresses;
    }

    @Override
    public DnsQueryResult query(DnsMessage.Builder queryBuilder) throws IOException {
        DnsQueryResult dnsQueryResult;
        DnsMessage q = this.newQuestion(queryBuilder).build();
        CachedDnsQueryResult cachedDnsQueryResult = dnsQueryResult = this.cache == null ? null : this.cache.get(q);
        if (dnsQueryResult != null) {
            return dnsQueryResult;
        }
        List<InetAddress> dnsServerAddresses = this.getServerAddresses();
        ArrayList<IOException> ioExceptions = new ArrayList<IOException>(dnsServerAddresses.size());
        block5: for (InetAddress dns : dnsServerAddresses) {
            if (this.nonRaServers.contains(dns)) {
                LOGGER.finer("Skipping " + dns + " because it was marked as \"recursion not available\"");
                continue;
            }
            try {
                dnsQueryResult = this.query(q, dns);
            }
            catch (IOException ioe) {
                ioExceptions.add(ioe);
                continue;
            }
            DnsMessage responseMessage = dnsQueryResult.response;
            if (!responseMessage.recursionAvailable) {
                boolean newRaServer = this.nonRaServers.add(dns);
                if (!newRaServer) continue;
                LOGGER.warning("The DNS server " + dns + " returned a response without the \"recursion available\" (RA) flag set. This likely indicates a misconfiguration because the server is not suitable for DNS resolution");
                continue;
            }
            if (this.disableResultFilter) {
                return dnsQueryResult;
            }
            switch (responseMessage.responseCode) {
                case NO_ERROR: 
                case NX_DOMAIN: {
                    break;
                }
                default: {
                    String warning = "Response from " + dns + " asked for " + q.getQuestion() + " with error code: " + responseMessage.responseCode + '.';
                    if (!LOGGER.isLoggable(Level.FINE)) {
                        warning = warning + "\n" + responseMessage;
                    }
                    LOGGER.warning(warning);
                    MiniDnsException.ErrorResponseException exception = new MiniDnsException.ErrorResponseException(q, dnsQueryResult);
                    ioExceptions.add(exception);
                    continue block5;
                }
            }
            return dnsQueryResult;
        }
        MultipleIoException.throwIfRequired(ioExceptions);
        throw new MiniDnsException.NoQueryPossibleException(q);
    }

    @Override
    protected MiniDnsFuture<DnsQueryResult, IOException> queryAsync(DnsMessage.Builder queryBuilder) {
        CachedDnsQueryResult responseMessage;
        DnsMessage q = this.newQuestion(queryBuilder).build();
        CachedDnsQueryResult cachedDnsQueryResult = responseMessage = this.cache == null ? null : this.cache.get(q);
        if (responseMessage != null) {
            return MiniDnsFuture.from(responseMessage);
        }
        List<InetAddress> dnsServerAddresses = this.getServerAddresses();
        Iterator<InetAddress> it = dnsServerAddresses.iterator();
        while (it.hasNext()) {
            InetAddress dns = it.next();
            if (!this.nonRaServers.contains(dns)) continue;
            it.remove();
            LOGGER.finer("Skipping " + dns + " because it was marked as \"recursion not available\"");
        }
        ArrayList futures = new ArrayList(dnsServerAddresses.size());
        for (InetAddress dns : dnsServerAddresses) {
            MiniDnsFuture<DnsQueryResult, IOException> f = this.queryAsync(q, dns);
            futures.add(f);
        }
        return MiniDnsFuture.anySuccessfulOf(futures);
    }

    public static List<String> findDNS() {
        List<String> res = null;
        for (DnsServerLookupMechanism mechanism : LOOKUP_MECHANISMS) {
            try {
                res = mechanism.getDnsServerAddresses();
            }
            catch (SecurityException exception) {
                LOGGER.log(Level.WARNING, "Could not lookup DNS server", exception);
            }
            if (res == null) continue;
            assert (!res.isEmpty());
            Iterator<String> it = res.iterator();
            while (it.hasNext()) {
                String potentialDnsServer = it.next();
                if (!InetAddressUtil.isIpAddress((CharSequence)potentialDnsServer)) {
                    LOGGER.warning("The DNS server lookup mechanism '" + mechanism.getName() + "' returned an invalid non-IP address result: '" + potentialDnsServer + "'");
                    it.remove();
                    continue;
                }
                if (!blacklistedDnsServers.contains(potentialDnsServer)) continue;
                LOGGER.fine("The DNS server lookup mechanism '" + mechanism.getName() + "' returned a blacklisted result: '" + potentialDnsServer + "'");
                it.remove();
            }
            if (!res.isEmpty()) break;
            LOGGER.warning("The DNS server lookup mechanism '" + mechanism.getName() + "' returned not a single valid IP address after sanitazion");
            res = null;
        }
        return res;
    }

    public static List<InetAddress> findDnsAddresses() {
        List<String> res = DnsClient.findDNS();
        if (res == null) {
            return new ArrayList<InetAddress>();
        }
        AbstractDnsClient.IpVersionSetting setting = DEFAULT_IP_VERSION_SETTING;
        ArrayList<Inet4Address> ipv4DnsServer = null;
        ArrayList<Inet6Address> ipv6DnsServer = null;
        if (setting.v4) {
            ipv4DnsServer = new ArrayList<Inet4Address>(res.size());
        }
        if (setting.v6) {
            ipv6DnsServer = new ArrayList<Inet6Address>(res.size());
        }
        int validServerAddresses = 0;
        for (String dnsServerString : res) {
            InetAddress dnsServerAddress;
            assert (InetAddressUtil.isIpAddress((CharSequence)dnsServerString));
            try {
                dnsServerAddress = InetAddress.getByName(dnsServerString);
            }
            catch (UnknownHostException e) {
                LOGGER.log(Level.SEVERE, "Could not transform '" + dnsServerString + "' to InetAddress", e);
                continue;
            }
            if (dnsServerAddress instanceof Inet4Address) {
                if (!setting.v4) continue;
                Inet4Address ipv4DnsServerAddress = (Inet4Address)dnsServerAddress;
                ipv4DnsServer.add(ipv4DnsServerAddress);
            } else if (dnsServerAddress instanceof Inet6Address) {
                if (!setting.v6) continue;
                Inet6Address ipv6DnsServerAddress = (Inet6Address)dnsServerAddress;
                ipv6DnsServer.add(ipv6DnsServerAddress);
            } else {
                throw new AssertionError((Object)("The address '" + dnsServerAddress + "' is neither of type Inet(4|6)Address"));
            }
            ++validServerAddresses;
        }
        ArrayList<InetAddress> dnsServers = new ArrayList<InetAddress>(validServerAddresses);
        switch (setting) {
            case v4v6: {
                dnsServers.addAll(ipv4DnsServer);
                dnsServers.addAll(ipv6DnsServer);
                break;
            }
            case v6v4: {
                dnsServers.addAll(ipv6DnsServer);
                dnsServers.addAll(ipv4DnsServer);
                break;
            }
            case v4only: {
                dnsServers.addAll(ipv4DnsServer);
                break;
            }
            case v6only: {
                dnsServers.addAll(ipv6DnsServer);
            }
        }
        return dnsServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDnsServerLookupMechanism(DnsServerLookupMechanism dnsServerLookup) {
        if (!dnsServerLookup.isAvailable()) {
            LOGGER.fine("Not adding " + dnsServerLookup.getName() + " as it is not available.");
            return;
        }
        List<DnsServerLookupMechanism> list = LOOKUP_MECHANISMS;
        synchronized (list) {
            ArrayList<DnsServerLookupMechanism> tempList = new ArrayList<DnsServerLookupMechanism>(LOOKUP_MECHANISMS.size() + 1);
            tempList.addAll(LOOKUP_MECHANISMS);
            tempList.add(dnsServerLookup);
            Collections.sort(tempList);
            LOOKUP_MECHANISMS.clear();
            LOOKUP_MECHANISMS.addAll(tempList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDNSServerLookupMechanism(DnsServerLookupMechanism dnsServerLookup) {
        List<DnsServerLookupMechanism> list = LOOKUP_MECHANISMS;
        synchronized (list) {
            return LOOKUP_MECHANISMS.remove(dnsServerLookup);
        }
    }

    public static boolean addBlacklistedDnsServer(String dnsServer) {
        return blacklistedDnsServers.add(dnsServer);
    }

    public static boolean removeBlacklistedDnsServer(String dnsServer) {
        return blacklistedDnsServers.remove(dnsServer);
    }

    public boolean isAskForDnssec() {
        return this.askForDnssec;
    }

    public void setAskForDnssec(boolean askForDnssec) {
        this.askForDnssec = askForDnssec;
    }

    public boolean isDisableResultFilter() {
        return this.disableResultFilter;
    }

    public void setDisableResultFilter(boolean disableResultFilter) {
        this.disableResultFilter = disableResultFilter;
    }

    public boolean isUseHardcodedDnsServersEnabled() {
        return this.useHardcodedDnsServers;
    }

    public void setUseHardcodedDnsServers(boolean useHardcodedDnsServers) {
        this.useHardcodedDnsServers = useHardcodedDnsServers;
    }

    public InetAddress getRandomHardcodedIpv4DnsServer() {
        return (InetAddress)CollectionsUtil.getRandomFrom(STATIC_IPV4_DNS_SERVERS, (Random)this.insecureRandom);
    }

    public InetAddress getRandomHarcodedIpv6DnsServer() {
        return (InetAddress)CollectionsUtil.getRandomFrom(STATIC_IPV6_DNS_SERVERS, (Random)this.insecureRandom);
    }

    private static Question getReverseIpLookupQuestionFor(DnsName dnsName) {
        return new Question(dnsName, Record.TYPE.PTR);
    }

    public static Question getReverseIpLookupQuestionFor(Inet4Address inet4Address) {
        DnsName reversedIpAddress = InetAddressUtil.reverseIpAddressOf((Inet4Address)inet4Address);
        DnsName dnsName = DnsName.from((DnsName)reversedIpAddress, (DnsName)DnsName.IN_ADDR_ARPA);
        return DnsClient.getReverseIpLookupQuestionFor(dnsName);
    }

    public static Question getReverseIpLookupQuestionFor(Inet6Address inet6Address) {
        DnsName reversedIpAddress = InetAddressUtil.reverseIpAddressOf((Inet6Address)inet6Address);
        DnsName dnsName = DnsName.from((DnsName)reversedIpAddress, (DnsName)DnsName.IP6_ARPA);
        return DnsClient.getReverseIpLookupQuestionFor(dnsName);
    }

    public static Question getReverseIpLookupQuestionFor(InetAddress inetAddress) {
        if (inetAddress instanceof Inet4Address) {
            return DnsClient.getReverseIpLookupQuestionFor((Inet4Address)inetAddress);
        }
        if (inetAddress instanceof Inet6Address) {
            return DnsClient.getReverseIpLookupQuestionFor((Inet6Address)inetAddress);
        }
        throw new IllegalArgumentException("The provided inetAddress '" + inetAddress + "' is neither of type Inet4Address nor Inet6Address");
    }

    static {
        DnsClient.addDnsServerLookupMechanism(AndroidUsingExec.INSTANCE);
        DnsClient.addDnsServerLookupMechanism(AndroidUsingReflection.INSTANCE);
        DnsClient.addDnsServerLookupMechanism(UnixUsingEtcResolvConf.INSTANCE);
        try {
            Inet4Address googleV4Dns = InetAddressUtil.ipv4From((CharSequence)"8.8.8.8");
            STATIC_IPV4_DNS_SERVERS.add(googleV4Dns);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Could not add static IPv4 DNS Server", e);
        }
        try {
            Inet6Address googleV6Dns = InetAddressUtil.ipv6From((CharSequence)"[2001:4860:4860::8888]");
            STATIC_IPV6_DNS_SERVERS.add(googleV6Dns);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Could not add static IPv6 DNS Server", e);
        }
        blacklistedDnsServers = Collections.newSetFromMap(new ConcurrentHashMap(4));
    }
}

