/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.register;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.register.AbstractDaoRegister;
import org.milyn.scribe.register.DaoRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDaoRegister<T>
extends AbstractDaoRegister<T> {
    private Map<String, DaoRegister<T>> daoRegisterMap = new HashMap<String, DaoRegister<T>>();

    public static <T> MultiDaoRegister<T> newInstance(Map<String, ? extends DaoRegister<T>> map) {
        AssertArgument.isNotNull(map, (String)"map");
        return new MultiDaoRegister<T>(new HashMap<String, DaoRegister<T>>(map));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Map<String, ? extends DaoRegister<T>> map) {
        return new Builder(map);
    }

    private MultiDaoRegister(Map<String, DaoRegister<T>> daoRegisterMap) {
        this.daoRegisterMap = daoRegisterMap;
    }

    @Override
    public T getDao(String name) {
        DaoRegister<T> subDaoRegister;
        int sepIndex = name.indexOf(".");
        String key = name;
        String subName = null;
        if (sepIndex >= 0) {
            key = name.substring(0, sepIndex);
            subName = name.substring(sepIndex + 1);
        }
        if ((subDaoRegister = this.daoRegisterMap.get(key)) == null) {
            return null;
        }
        if (subName == null) {
            return subDaoRegister.getDefaultDao();
        }
        return subDaoRegister.getDao(subName);
    }

    public int size() {
        return this.daoRegisterMap.size();
    }

    public Map<String, DaoRegister<T>> getDaoRegisterMap() {
        return new HashMap<String, DaoRegister<T>>(this.daoRegisterMap);
    }

    public int hashCode() {
        return ((Object)this.daoRegisterMap).hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("daoRegisterMap", this.daoRegisterMap, true).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiDaoRegister)) {
            return false;
        }
        MultiDaoRegister other = (MultiDaoRegister)obj;
        return ((Object)this.daoRegisterMap).equals(other.daoRegisterMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Builder<T> {
        private final Map<String, DaoRegister<T>> map;

        public Builder() {
            this.map = new HashMap<String, DaoRegister<T>>();
        }

        public Builder(Map<String, ? extends DaoRegister<T>> map) {
            AssertArgument.isNotNull(map, (String)"map");
            this.map = new HashMap<String, DaoRegister<T>>(map);
        }

        public Builder<T> put(String name, DaoRegister<T> daoRegister) {
            AssertArgument.isNotNull((Object)name, (String)"name");
            AssertArgument.isNotNull(daoRegister, (String)"daoRegister");
            this.map.put(name, daoRegister);
            return this;
        }

        public Builder<T> putAll(Map<String, ? extends DaoRegister<T>> map) {
            AssertArgument.isNotNull(map, (String)"map");
            this.map.putAll(map);
            return this;
        }

        public MultiDaoRegister<T> build() {
            return new MultiDaoRegister(this.map);
        }
    }
}

