/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.registry;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.registry.AbstractMappingsRegistry;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.SAXException;

public class DefaultMappingsRegistry
extends AbstractMappingsRegistry {
    private final Map<String, URI> modelReferences = new HashMap<String, URI>();

    public DefaultMappingsRegistry(EdifactModel ... models) {
        for (EdifactModel model : models) {
            this.content.put(EDIUtils.toLookupName(model.getDescription()), model);
        }
    }

    public DefaultMappingsRegistry(String mappingModelFiles, URI baseURI) throws EDIConfigurationException, IOException, SAXException {
        this.addModelReferences(mappingModelFiles, baseURI);
    }

    public void addModelReferences(String models, URI baseURI) {
        String[] mappingModelFileTokens;
        for (String modelRef : mappingModelFileTokens = models.split(",")) {
            this.modelReferences.put(modelRef, baseURI);
        }
    }

    @Override
    protected synchronized Map<String, EdifactModel> demandLoading(String[] nameComponents) throws EDIConfigurationException, IOException, SAXException {
        LinkedHashMap<String, EdifactModel> result = new LinkedHashMap<String, EdifactModel>();
        Set<Map.Entry<String, URI>> set = this.modelReferences.entrySet();
        for (Map.Entry<String, URI> entry : set) {
            EDIUtils.loadMappingModels(entry.getKey(), result, entry.getValue());
        }
        return result;
    }
}

