/**
 * This class was generated by Smooks EJC (http://www.smooks.org).
 */
package org.milyn.edi.unedifact.d95b.common;

import java.io.Serializable;    
import org.milyn.smooks.edi.EDIWritable;    
import java.math.BigDecimal;    
import org.milyn.javabean.decoders.DABigDecimalDecoder;    
import java.io.Writer;    
import org.milyn.edisax.model.internal.Delimiters;    
import java.io.IOException;    
import java.io.StringWriter;    
import java.util.List;    
import java.util.ArrayList;    
import org.milyn.edisax.util.EDIUtils;    
import org.milyn.edisax.model.internal.DelimiterType;    

public class DLIDocumentLineIdentification implements Serializable, EDIWritable {

    private static final long serialVersionUID = 1L;

    private String e1073DocumentLineIndicatorCoded;
    private BigDecimal e1082LineItemNumber;
    private DABigDecimalDecoder e1082LineItemNumberEncoder;

    public DLIDocumentLineIdentification() {
        
        e1082LineItemNumberEncoder = new DABigDecimalDecoder();
    }

    public void write(Writer writer, Delimiters delimiters) throws IOException {
        
        Writer nodeWriter = new StringWriter();

        List<String> nodeTokens = new ArrayList<String>();

        if(e1073DocumentLineIndicatorCoded != null) {
            nodeWriter.write(delimiters.escape(e1073DocumentLineIndicatorCoded.toString()));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeWriter.write(delimiters.getField());
        if(e1082LineItemNumber != null) {
            nodeWriter.write(delimiters.escape(e1082LineItemNumberEncoder.encode(e1082LineItemNumber, delimiters)));
            nodeTokens.add(nodeWriter.toString());
            ((StringWriter)nodeWriter).getBuffer().setLength(0);
        }
        nodeTokens.add(nodeWriter.toString());
        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.FIELD, delimiters));
        writer.write(delimiters.getSegmentDelimiter());
        writer.flush();
    }

    public String getE1073DocumentLineIndicatorCoded() {
        return e1073DocumentLineIndicatorCoded;
    }

    public DLIDocumentLineIdentification setE1073DocumentLineIndicatorCoded(String e1073DocumentLineIndicatorCoded) {
        this.e1073DocumentLineIndicatorCoded = e1073DocumentLineIndicatorCoded;  return this;
    }

    public BigDecimal getE1082LineItemNumber() {
        return e1082LineItemNumber;
    }

    public DLIDocumentLineIdentification setE1082LineItemNumber(BigDecimal e1082LineItemNumber) {
        this.e1082LineItemNumber = e1082LineItemNumber;  return this;
    }
}