/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.microedition.lcdui.Graphics;
import org.microemu.device.MutableImage;
import org.microemu.device.j2se.J2SEDisplayGraphics;

public class J2SEMutableImage
extends MutableImage {
    private Image img;
    private J2SEDisplayGraphics displayGraphics = null;
    private PixelGrabber grabber = null;
    private int[] pixels;

    public J2SEMutableImage(int width, int height) {
        this.img = new BufferedImage(width, height, 2);
    }

    public Graphics getGraphics() {
        if (this.displayGraphics == null) {
            this.displayGraphics = new J2SEDisplayGraphics((Graphics2D)this.img.getGraphics(), this);
            this.displayGraphics.setGrayScale(255);
            this.displayGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.displayGraphics.setGrayScale(0);
        }
        return this.displayGraphics;
    }

    public boolean isMutable() {
        return true;
    }

    public int getHeight() {
        return this.img.getHeight(null);
    }

    public Image getImage() {
        return this.img;
    }

    public int getWidth() {
        return this.img.getWidth(null);
    }

    public int[] getData() {
        if (this.grabber == null) {
            this.pixels = new int[this.getWidth() * this.getHeight()];
            this.grabber = new PixelGrabber(this.img, 0, 0, this.getWidth(), this.getHeight(), this.pixels, 0, this.getWidth());
        }
        try {
            this.grabber.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.pixels;
    }

    public void getRGB(int[] argb, int offset, int scanlength, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0 || y < 0 || x + width > this.getWidth() || y + height > this.getHeight()) {
            throw new IllegalArgumentException("Specified area exceeds bounds of image");
        }
        if ((scanlength < 0 ? -scanlength : scanlength) < width) {
            throw new IllegalArgumentException("abs value of scanlength is less than width");
        }
        if (argb == null) {
            throw new NullPointerException("null rgbData");
        }
        if (offset < 0 || offset + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (scanlength < 0 ? offset + scanlength * (height - 1) < 0 : offset + scanlength * (height - 1) + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            new PixelGrabber(this.img, x, y, width, height, argb, offset, scanlength).grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

