/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Iterator;
import javax.microedition.lcdui.Command;
import org.microemu.CommandManager;
import org.microemu.DisplayAccess;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.device.DeviceFactory;
import org.microemu.device.InputMethodEvent;
import org.microemu.device.impl.InputMethodImpl;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.j2se.J2SEButton;

public class J2SEInputMethod
extends InputMethodImpl {
    private boolean eventAlreadyConsumed;

    public int getGameAction(int keyCode) {
        int key = keyCode;
        Iterator it = DeviceFactory.getDevice().getButtons().iterator();
        while (it.hasNext()) {
            J2SEButton button = (J2SEButton)it.next();
            if (button.getKeyCode() != keyCode) continue;
            key = button.getKeyboardKey();
            break;
        }
        switch (key) {
            case 38: {
                return 1;
            }
            case 40: {
                return 6;
            }
            case 37: {
                return 2;
            }
            case 39: {
                return 5;
            }
            case 10: {
                return 8;
            }
            case 49: 
            case 65: {
                return 9;
            }
            case 51: 
            case 66: {
                return 10;
            }
            case 55: 
            case 67: {
                return 11;
            }
            case 57: 
            case 68: {
                return 12;
            }
        }
        return 0;
    }

    public int getKeyCode(int gameAction) {
        int keyCode;
        switch (gameAction) {
            case 1: {
                keyCode = 38;
                break;
            }
            case 6: {
                keyCode = 40;
                break;
            }
            case 2: {
                keyCode = 37;
                break;
            }
            case 5: {
                keyCode = 39;
                break;
            }
            case 8: {
                keyCode = 10;
                break;
            }
            case 9: {
                keyCode = 49;
                break;
            }
            case 10: {
                keyCode = 51;
                break;
            }
            case 11: {
                keyCode = 55;
                break;
            }
            case 12: {
                keyCode = 57;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        Iterator it = DeviceFactory.getDevice().getButtons().iterator();
        while (it.hasNext()) {
            J2SEButton button = (J2SEButton)it.next();
            if (button.getKeyboardKey() != keyCode) continue;
            keyCode = button.getKeyCode();
            break;
        }
        return keyCode;
    }

    public String getKeyName(int keyCode) {
        J2SEButton button;
        Iterator it = DeviceFactory.getDevice().getButtons().iterator();
        while (it.hasNext()) {
            button = (J2SEButton)it.next();
            if (button.getKeyCode() != keyCode) continue;
            return button.getName();
        }
        it = DeviceFactory.getDevice().getButtons().iterator();
        while (it.hasNext()) {
            button = (J2SEButton)it.next();
            if (button.getKeyboardKey() != keyCode) continue;
            return button.getName();
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean commonKeyPressed(KeyEvent ev) {
        int keyCode = ev.getKeyCode();
        if (this.inputMethodListener == null) {
            int midpKeyCode;
            switch (keyCode) {
                case 8: {
                    return true;
                }
                case 106: {
                    midpKeyCode = 42;
                    break;
                }
                case 31: {
                    midpKeyCode = 35;
                    break;
                }
                default: {
                    midpKeyCode = keyCode;
                }
            }
            switch (ev.getKeyChar()) {
                case '*': {
                    midpKeyCode = 42;
                    break;
                }
                case '#': {
                    midpKeyCode = 35;
                }
            }
            MIDletBridge.getMIDletAccess().getDisplayAccess().keyPressed(midpKeyCode);
            return true;
        }
        if (keyCode == 38 || keyCode == 40) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().keyPressed(keyCode);
            return true;
        }
        if (keyCode == 31) {
            if (this.getInputMode() == 1) {
                this.setInputMode(2);
            } else if (this.getInputMode() == 2) {
                this.setInputMode(3);
            } else if (this.getInputMode() == 3) {
                this.setInputMode(1);
            }
            J2SEInputMethod midpKeyCode = this;
            synchronized (midpKeyCode) {
                if (this.lastButton != null) {
                    ++this.caret;
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
            }
            InputMethodEvent event = new InputMethodEvent(1, this.caret, this.text);
            this.inputMethodListener.caretPositionChanged(event);
            return true;
        }
        if (keyCode == 37 || keyCode == 39) {
            Object event = this;
            synchronized (event) {
                if (keyCode == 37 && this.caret > 0) {
                    --this.caret;
                }
                if (keyCode == 39 && this.caret < this.text.length()) {
                    ++this.caret;
                }
                this.lastButton = null;
                this.lastButtonCharIndex = -1;
            }
            event = new InputMethodEvent(1, this.caret, this.text);
            this.inputMethodListener.caretPositionChanged((InputMethodEvent)event);
            return true;
        }
        if (keyCode == 8) {
            Object event = this;
            synchronized (event) {
                if (this.lastButton != null) {
                    ++this.caret;
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
                if (this.caret > 0) {
                    --this.caret;
                    String tmp = "";
                    if (this.caret > 0) {
                        tmp = tmp + this.text.substring(0, this.caret);
                    }
                    if (this.caret < this.text.length() - 1) {
                        tmp = tmp + this.text.substring(this.caret + 1);
                    }
                    this.text = tmp;
                }
            }
            event = new InputMethodEvent(2, this.caret, this.text);
            this.inputMethodListener.inputMethodTextChanged((InputMethodEvent)event);
            event = new InputMethodEvent(1, this.caret, this.text);
            this.inputMethodListener.caretPositionChanged((InputMethodEvent)event);
            return true;
        }
        if (keyCode == 127) {
            Object event = this;
            synchronized (event) {
                if (this.lastButton != null) {
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
                if (this.caret != this.text.length()) {
                    this.text = this.text.substring(0, this.caret) + this.text.substring(this.caret + 1);
                }
            }
            event = new InputMethodEvent(2, this.caret, this.text);
            this.inputMethodListener.inputMethodTextChanged((InputMethodEvent)event);
            event = new InputMethodEvent(1, this.caret, this.text);
            this.inputMethodListener.caretPositionChanged((InputMethodEvent)event);
            return true;
        }
        return false;
    }

    public void keyTyped(KeyEvent ev) {
        if (this.eventAlreadyConsumed) {
            return;
        }
        char c = ev.getKeyChar();
        if (c == '\b') {
            return;
        }
        if (this.inputMethodListener != null && this.text != null && this.text.length() < this.maxSize) {
            this.insertText(new Character(c).toString());
        }
    }

    public void clipboardPaste(String str) {
        if (this.inputMethodListener != null && this.text != null && this.text.length() + str.length() <= this.maxSize) {
            this.insertText(str);
        }
        this.eventAlreadyConsumed = true;
    }

    public void keyPressed(KeyEvent ev) {
        Command cmd;
        this.eventAlreadyConsumed = false;
        boolean rawSoftKeys = DeviceFactory.getDevice().getDeviceDisplay().isFullScreenMode();
        J2SEButton pressedButton = this.getButton(ev);
        if (pressedButton != null && pressedButton instanceof SoftButton && !rawSoftKeys && (cmd = ((SoftButton)((Object)pressedButton)).getCommand()) != null) {
            CommandManager.getInstance().commandAction(cmd);
            this.eventAlreadyConsumed = true;
            return;
        }
        if (this.commonKeyPressed(ev)) {
            this.eventAlreadyConsumed = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(KeyEvent ev) {
        if (this.commonKeyPressed(ev)) {
            return;
        }
        if (this.text.length() < this.maxSize) {
            Enumeration e = DeviceFactory.getDevice().getButtons().elements();
            while (e.hasMoreElements()) {
                J2SEButton button = (J2SEButton)e.nextElement();
                if (ev.getKeyCode() != button.getKeyCode()) continue;
                J2SEInputMethod j2SEInputMethod = this;
                synchronized (j2SEInputMethod) {
                    ++this.lastButtonCharIndex;
                    char[] buttonChars = this.filterConstraints(this.filterInputMode(button.getChars()));
                    if (buttonChars.length > 0) {
                        if (this.lastButtonCharIndex == buttonChars.length) {
                            if (buttonChars.length == 1) {
                                if (this.lastButton != null) {
                                    ++this.caret;
                                }
                                this.lastButton = null;
                            } else {
                                this.lastButtonCharIndex = 0;
                            }
                        }
                        if (this.lastButton != button) {
                            if (this.lastButton != null) {
                                ++this.caret;
                            }
                            String tmp = "";
                            if (this.caret > 0) {
                                tmp = tmp + this.text.substring(0, this.caret);
                            }
                            tmp = tmp + buttonChars[0];
                            if (this.caret < this.text.length()) {
                                tmp = tmp + this.text.substring(this.caret);
                            }
                            this.text = tmp;
                            this.lastButton = button;
                            this.lastButtonCharIndex = 0;
                        } else {
                            String tmp = "";
                            if (this.caret > 0) {
                                tmp = tmp + this.text.substring(0, this.caret);
                            }
                            tmp = tmp + buttonChars[this.lastButtonCharIndex];
                            if (this.caret < this.text.length() - 1) {
                                tmp = tmp + this.text.substring(this.caret + 1);
                            }
                            this.text = tmp;
                            this.lastButton = button;
                        }
                    } else {
                        this.lastButton = null;
                        this.lastButtonCharIndex = -1;
                    }
                    this.resetKey = false;
                    this.notify();
                }
                InputMethodEvent event = new InputMethodEvent(2, this.caret, this.text);
                this.inputMethodListener.inputMethodTextChanged(event);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent ev) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        da.keyReleased(ev.getKeyCode());
        this.eventAlreadyConsumed = false;
    }

    public void mouseReleased(int keyCode) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        da.keyReleased(keyCode);
    }

    public J2SEButton getButton(KeyEvent ev) {
        Enumeration e = DeviceFactory.getDevice().getButtons().elements();
        while (e.hasMoreElements()) {
            J2SEButton button = (J2SEButton)e.nextElement();
            if (ev.getKeyCode() == button.getKeyCode()) {
                return button;
            }
            if (!button.isChar(ev.getKeyChar())) continue;
            return button;
        }
        return null;
    }
}

