/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import org.microemu.device.j2se.J2SEMutableImage;

public class J2SEImmutableImage
extends javax.microedition.lcdui.Image {
    private Image img;
    private int width;
    private int height;

    public J2SEImmutableImage(Image image) {
        this.img = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    public J2SEImmutableImage(J2SEMutableImage image) {
        this.img = Toolkit.getDefaultToolkit().createImage(image.getImage().getSource());
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        return this.img;
    }

    public int getWidth() {
        return this.width;
    }

    public void getRGB(int[] argb, int offset, int scanlength, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0 || y < 0 || x + width > this.getWidth() || y + height > this.getHeight()) {
            throw new IllegalArgumentException("Specified area exceeds bounds of image");
        }
        if ((scanlength < 0 ? -scanlength : scanlength) < width) {
            throw new IllegalArgumentException("abs value of scanlength is less than width");
        }
        if (argb == null) {
            throw new NullPointerException("null rgbData");
        }
        if (offset < 0 || offset + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (scanlength < 0 ? offset + scanlength * (height - 1) < 0 : offset + scanlength * (height - 1) + width > argb.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        try {
            new PixelGrabber(this.img, x, y, width, height, argb, offset, scanlength).grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

