/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.event.KeyEvent;
import org.microemu.device.impl.Button;
import org.microemu.device.impl.Shape;

public class J2SEButton
implements Button {
    private String name;
    private Shape shape;
    private int keyboardKey;
    private int keyCode;
    private char[] chars;

    public J2SEButton(String name, Shape shape, int keyCode, String keyName, char[] chars) {
        this.name = name;
        this.shape = shape;
        this.keyboardKey = this.parseKeyboardKey(keyName);
        this.keyCode = keyCode == Integer.MIN_VALUE ? (keyName != null ? this.keyboardKey : -1) : keyCode;
        this.chars = chars;
        if (chars != null) {
            for (int i = 0; i < this.chars.length; ++i) {
                this.chars[i] = Character.toLowerCase(this.chars[i]);
            }
        }
    }

    public int getKeyboardKey() {
        return this.keyboardKey;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public char[] getChars() {
        return this.chars;
    }

    public boolean isChar(char c) {
        c = Character.toLowerCase(c);
        if (this.chars != null) {
            for (int i = 0; i < this.chars.length; ++i) {
                if (c != this.chars[i]) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Shape getShape() {
        return this.shape;
    }

    private int parseKeyboardKey(String keyName) {
        int key;
        try {
            key = KeyEvent.class.getField(keyName).getInt(null);
        }
        catch (Exception ex) {
            try {
                key = Integer.parseInt(keyName);
            }
            catch (NumberFormatException ex1) {
                key = -1;
            }
        }
        return key;
    }
}

