/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.impl;

import org.microemu.MIDletBridge;
import org.microemu.device.DeviceFactory;
import org.microemu.device.InputMethod;
import org.microemu.device.InputMethodEvent;
import org.microemu.device.impl.Button;

public abstract class InputMethodImpl
extends InputMethod
implements Runnable {
    protected boolean resetKey;
    protected Button lastButton = null;
    protected int lastButtonCharIndex = -1;
    private boolean cancel = false;
    private Thread t = new Thread((Runnable)this, "InputMethodThread");

    public InputMethodImpl() {
        this.t.setDaemon(true);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.cancel = true;
        InputMethodImpl inputMethodImpl = this;
        synchronized (inputMethodImpl) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.cancel) {
            InputMethodImpl inputMethodImpl;
            try {
                this.resetKey = true;
                inputMethodImpl = this;
                synchronized (inputMethodImpl) {
                    this.wait(1500L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            inputMethodImpl = this;
            synchronized (inputMethodImpl) {
                if (this.resetKey && this.lastButton != null) {
                    ++this.caret;
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                    if (this.inputMethodListener != null) {
                        InputMethodEvent event = new InputMethodEvent(1, this.caret, this.text);
                        this.inputMethodListener.caretPositionChanged(event);
                    }
                }
            }
        }
    }

    public void pointerPressed(int x, int y) {
        if (DeviceFactory.getDevice().hasPointerEvents()) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (DeviceFactory.getDevice().hasPointerEvents()) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (DeviceFactory.getDevice().hasPointerMotionEvents()) {
            MIDletBridge.getMIDletAccess().getDisplayAccess().pointerDragged(x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertText(String str) {
        char[] test = new char[str.length()];
        test = this.filterConstraints(str.toCharArray());
        if (test.length > 0) {
            InputMethodImpl inputMethodImpl = this;
            synchronized (inputMethodImpl) {
                if (this.lastButton != null) {
                    ++this.caret;
                    this.lastButton = null;
                    this.lastButtonCharIndex = -1;
                }
                String tmp = "";
                if (this.caret > 0) {
                    tmp = tmp + this.text.substring(0, this.caret);
                }
                tmp = tmp + new String(test);
                if (this.caret < this.text.length()) {
                    tmp = tmp + this.text.substring(this.caret);
                }
                this.text = tmp;
                this.caret += test.length;
            }
            InputMethodEvent event = new InputMethodEvent(2, this.caret, this.text);
            this.inputMethodListener.inputMethodTextChanged(event);
            event = new InputMethodEvent(1, this.caret, this.text);
            this.inputMethodListener.caretPositionChanged(event);
        }
    }

    protected char[] filterConstraints(char[] chars) {
        int i;
        char[] result = new char[chars.length];
        int j = 0;
        for (i = 0; i < chars.length; ++i) {
            if ((this.constraints & 2) != 0) {
                if (!Character.isDigit(chars[i]) && chars[i] != '.') continue;
                result[j] = chars[i];
                ++j;
                continue;
            }
            if ((this.constraints & 4) != 0) {
                if (chars[i] == '\n') continue;
                result[j] = chars[i];
                ++j;
                continue;
            }
            result[j] = chars[i];
            ++j;
        }
        if (i != j) {
            char[] newresult = new char[j];
            System.arraycopy(result, 0, newresult, 0, j);
            result = newresult;
        }
        return result;
    }

    protected char[] filterInputMode(char[] chars) {
        int i;
        int inputMode = this.getInputMode();
        char[] result = new char[chars.length];
        int j = 0;
        for (i = 0; i < chars.length; ++i) {
            if (inputMode == 2) {
                result[j] = Character.toUpperCase(chars[i]);
                ++j;
                continue;
            }
            if (inputMode == 3) {
                result[j] = Character.toLowerCase(chars[i]);
                ++j;
                continue;
            }
            if (inputMode != 1 || !Character.isDigit(chars[i])) continue;
            result[j] = chars[i];
            ++j;
        }
        if (i != j) {
            char[] newresult = new char[j];
            System.arraycopy(result, 0, newresult, 0, j);
            result = newresult;
        }
        return result;
    }
}

