/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import javax.microedition.io.SocketConnection;
import org.microemu.cldc.ClosedConnection;

public class Connection
implements SocketConnection,
ClosedConnection {
    protected Socket socket;
    private int delay = -1;
    private int linger = -1;
    private int keepalive = -1;
    private int rcvbuf = -1;
    private int sndbuf = -1;

    public javax.microedition.io.Connection open(String name) throws IOException {
        int portSepIndex = name.lastIndexOf(58);
        int port = Integer.parseInt(name.substring(portSepIndex + 1));
        String host = name.substring("socket://".length(), portSepIndex);
        this.socket = new Socket(host, port);
        this.updateSocketOptions();
        return this;
    }

    public void close() throws IOException {
        if (this.socket == null) {
            return;
        }
        this.socket.close();
    }

    public InputStream openInputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException();
        }
        return this.socket.getInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.socket == null) {
            throw new IOException();
        }
        return this.socket.getOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public String getAddress() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getInetAddress().toString();
    }

    public String getLocalAddress() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getLocalAddress().toString();
    }

    public int getLocalPort() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getLocalPort();
    }

    public int getPort() throws IOException {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getPort();
    }

    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        if (this.socket != null && this.socket.isClosed()) {
            throw new IOException();
        }
        switch (option) {
            case 0: {
                if (this.socket != null) {
                    if (this.socket.getTcpNoDelay()) {
                        return 1;
                    }
                    return 0;
                }
                return this.delay;
            }
            case 1: {
                if (this.socket != null) {
                    int value = this.socket.getSoLinger();
                    if (value == -1) {
                        return 0;
                    }
                    return value;
                }
                return this.linger;
            }
            case 2: {
                if (this.socket != null) {
                    if (this.socket.getKeepAlive()) {
                        return 1;
                    }
                    return 0;
                }
                return this.keepalive;
            }
            case 3: {
                if (this.socket != null) {
                    return this.socket.getReceiveBufferSize();
                }
                return this.rcvbuf;
            }
            case 4: {
                if (this.socket != null) {
                    return this.socket.getSendBufferSize();
                }
                return this.sndbuf;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        if (this.socket != null && this.socket.isClosed()) {
            throw new IOException();
        }
        switch (option) {
            case 0: {
                this.delay = value == 0 ? 0 : 1;
                if (this.socket == null) break;
                this.socket.setTcpNoDelay(this.delay != 0);
                break;
            }
            case 1: {
                if (value < 0) {
                    throw new IllegalArgumentException();
                }
                this.linger = value;
                if (this.socket == null) break;
                this.socket.setSoLinger(this.linger != 0, this.linger);
                break;
            }
            case 2: {
                this.keepalive = value == 0 ? 0 : 1;
                if (this.socket == null) break;
                this.socket.setKeepAlive(this.keepalive != 0);
                break;
            }
            case 3: {
                if (value <= 0) {
                    throw new IllegalArgumentException();
                }
                this.rcvbuf = value;
                if (this.socket == null) break;
                this.socket.setReceiveBufferSize(this.rcvbuf);
                break;
            }
            case 4: {
                if (value <= 0) {
                    throw new IllegalArgumentException();
                }
                this.sndbuf = value;
                if (this.socket == null) break;
                this.socket.setSendBufferSize(this.sndbuf);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    protected void updateSocketOptions() throws SocketException {
        if (this.delay != -1) {
            this.socket.setTcpNoDelay(this.delay != 0);
        }
        if (this.linger != -1) {
            this.socket.setSoLinger(this.linger != 0, this.linger);
        }
        if (this.keepalive != -1) {
            this.socket.setKeepAlive(this.keepalive != 0);
        }
        if (this.rcvbuf != -1) {
            this.socket.setReceiveBufferSize(this.rcvbuf);
        }
        if (this.sndbuf != -1) {
            this.socket.setSendBufferSize(this.sndbuf);
        }
    }
}

