/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.microemu.app.util.ProgressEvent;
import org.microemu.app.util.ProgressListener;
import org.microemu.app.util.ResURLStreamHandler;
import org.microemu.app.util.SystemClassLoader;

public class ProgressJarClassLoader
extends SystemClassLoader {
    private Hashtable entries = new Hashtable();
    private Vector notLoadedRepositories = new Vector();
    private ProgressListener listener;
    private ResURLStreamHandler resUrlStreamHandler = new ResURLStreamHandler(this.entries);

    public ProgressJarClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addRepository(URL url) {
        this.notLoadedRepositories.add(url);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            byte[] b = this.loadClassData(name);
            result = this.defineClass(name, b, 0, b.length);
        }
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        this.loadRepositories();
        String newname = name.startsWith("/") ? name.substring(1) : name;
        byte[] tmp = (byte[])this.entries.get(newname);
        if (tmp != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(tmp);
            return is;
        }
        return this.getClass().getResourceAsStream(name);
    }

    private byte[] loadClassData(String name) throws ClassNotFoundException {
        this.loadRepositories();
        name = name.replace('.', '/') + ".class";
        byte[] result = (byte[])this.entries.get(name);
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
    }

    protected URL findResource(String name) {
        if (this.entries.containsKey(name)) {
            try {
                return new URL(null, "res:" + name, this.resUrlStreamHandler);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void fireProgressListener(ProgressEvent event) {
        if (this.listener != null) {
            this.listener.stateChanged(event);
        }
    }

    private synchronized void loadRepositories() {
        Enumeration en = this.notLoadedRepositories.elements();
        while (en.hasMoreElements()) {
            URL repositoryEntry = (URL)en.nextElement();
            byte[] cache = new byte[1024];
            ProgressEvent event = new ProgressEvent();
            int progress = 0;
            try {
                JarEntry entry;
                URLConnection conn = repositoryEntry.openConnection();
                int size = conn.getContentLength();
                JarInputStream jis = new JarInputStream(conn.getInputStream());
                while ((entry = jis.getNextJarEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    int offset = 0;
                    int i = 0;
                    while ((i = jis.read(cache, offset, cache.length - offset)) != -1) {
                        if ((offset += i) < cache.length) continue;
                        byte[] newcache = new byte[cache.length + 1024];
                        System.arraycopy(cache, 0, newcache, 0, cache.length);
                        cache = newcache;
                    }
                    byte[] tmp = new byte[offset];
                    System.arraycopy(cache, 0, tmp, 0, offset);
                    this.entries.put(entry.getName(), tmp);
                    progress = (int)((long)progress + entry.getCompressedSize());
                    event.setCurrent(progress);
                    event.setMax(size);
                    this.fireProgressListener(event);
                }
            }
            catch (IOException ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
            this.notLoadedRepositories.remove(repositoryEntry);
        }
    }
}

