/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.microemu.app.util.ResURLStreamHandler;
import org.microemu.app.util.SystemClassLoader;

public class MIDletClassLoader
extends SystemClassLoader {
    protected Hashtable entries = new Hashtable();
    private ResURLStreamHandler resUrlStreamHandler = new ResURLStreamHandler(this.entries);
    public static final boolean debug = false;

    public MIDletClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addURL(URL midletSource) throws IOException {
        String path = midletSource.toExternalForm();
        if (path.endsWith(".jar")) {
            this.addJarURL(midletSource);
        } else if (path.startsWith("file:")) {
            this.addPathURL(midletSource);
        } else {
            throw new IOException("URL Type not supported: " + midletSource);
        }
    }

    private void addPathURL(URL url) throws IOException {
        String path = url.toExternalForm();
        File classesDir = new File(path = path.substring("file:".length(), path.length()));
        if (!classesDir.exists() || !classesDir.isDirectory()) {
            throw new IOException("URL Type not supported: " + url);
        }
        int baseLen = path.length();
        DirectoryEnumeration en = new DirectoryEnumeration(classesDir);
        while (en.hasMoreElements()) {
            String name;
            File file = (File)en.nextElement();
            if (file.isDirectory() || !this.allowEntryName(name = file.getAbsolutePath().substring(baseLen))) continue;
            FileInputStream is = new FileInputStream(file);
            byte[] tmp = new byte[(int)file.length()];
            ((InputStream)is).read(tmp);
            this.entries.put(name, tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJarURL(URL midletSource) throws IOException {
        byte[] cache = new byte[1024];
        ZipInputStream jis = null;
        try {
            JarEntry entry;
            URLConnection conn = midletSource.openConnection();
            jis = new JarInputStream(conn.getInputStream());
            while ((entry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                if (entry.isDirectory() || !this.allowEntryName(entry.getName())) continue;
                int offset = 0;
                int i = 0;
                while ((i = ((JarInputStream)jis).read(cache, offset, cache.length - offset)) != -1) {
                    if ((offset += i) < cache.length) continue;
                    byte[] newcache = new byte[cache.length + 1024];
                    System.arraycopy(cache, 0, newcache, 0, cache.length);
                    cache = newcache;
                }
                byte[] tmp = new byte[offset];
                System.arraycopy(cache, 0, tmp, 0, offset);
                this.entries.put(entry.getName(), tmp);
            }
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            result = this.hasClassData(name) ? this.findClass(name) : super.loadClass(name, false);
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            byte[] b = this.loadClassData(name);
            result = this.defineClass(name, b, 0, b.length);
        }
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        String newname = name.startsWith("/") ? name.substring(1) : name;
        byte[] tmp = (byte[])this.entries.get(newname);
        if (tmp != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(tmp);
            return is;
        }
        return this.getClass().getResourceAsStream(name);
    }

    private boolean allowEntryName(String name) {
        return !name.startsWith("javax/") && !name.startsWith("java/");
    }

    private boolean allowClass(String name) {
        return !name.startsWith("javax.") && !name.startsWith("java.");
    }

    private boolean hasClassData(String name) {
        if (!this.allowClass(name)) {
            return false;
        }
        return this.entries.get(name = name.replace('.', '/') + ".class") != null;
    }

    protected byte[] loadClassData(String name) throws ClassNotFoundException {
        byte[] result = (byte[])this.entries.get(name = name.replace('.', '/') + ".class");
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    protected URL findResource(String name) {
        if (this.entries.containsKey(name)) {
            try {
                return new URL(null, "res:" + name, this.resUrlStreamHandler);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private class DirectoryEnumeration
    implements Enumeration {
        File[] files;
        int processing;
        Enumeration child = null;

        DirectoryEnumeration(File dir) {
            this.files = dir.listFiles();
            if (this.files == null) {
                throw new Error(dir.getAbsolutePath() + " path does not denote a directory");
            }
            this.processing = 0;
        }

        public boolean hasMoreElements() {
            return this.child != null && this.child.hasMoreElements() || this.processing < this.files.length;
        }

        public Object nextElement() {
            File next;
            if (this.child != null) {
                try {
                    return this.child.nextElement();
                }
                catch (NoSuchElementException e) {
                    this.child = null;
                }
            }
            if (this.processing >= this.files.length) {
                throw new NoSuchElementException();
            }
            if ((next = this.files[this.processing++]).isDirectory()) {
                this.child = new DirectoryEnumeration(next);
            }
            return next;
        }
    }
}

