/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import org.microemu.RecordStoreManager;
import org.microemu.app.Config;
import org.microemu.app.launcher.Launcher;
import org.microemu.util.RecordStoreImpl;

public class FileRecordStoreManager
implements RecordStoreManager {
    private static final String RECORD_STORE_SUFFIX = ".rs";
    private Launcher launcher;
    private Hashtable testOpenRecordStores = new Hashtable();
    private FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(FileRecordStoreManager.RECORD_STORE_SUFFIX);
        }
    };

    public FileRecordStoreManager(Launcher launcher) {
        this.launcher = launcher;
    }

    public void deleteRecordStore(String recordStoreName) throws RecordStoreNotFoundException, RecordStoreException {
        File suiteFolder = new File(Config.getConfigPath(), "suite-" + this.launcher.getSuiteName());
        File storeFile = new File(suiteFolder, recordStoreName + RECORD_STORE_SUFFIX);
        RecordStoreImpl recordStoreImpl = (RecordStoreImpl)this.testOpenRecordStores.get(storeFile.getName());
        if (recordStoreImpl != null && recordStoreImpl.isOpen()) {
            throw new RecordStoreException();
        }
        try {
            recordStoreImpl = this.loadFromDisk(storeFile);
        }
        catch (FileNotFoundException ex) {
            throw new RecordStoreNotFoundException();
        }
        storeFile.delete();
    }

    public RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreNotFoundException {
        RecordStoreImpl recordStoreImpl;
        File suiteFolder = new File(Config.getConfigPath(), "suite-" + this.launcher.getSuiteName());
        File storeFile = new File(suiteFolder, recordStoreName + RECORD_STORE_SUFFIX);
        try {
            recordStoreImpl = this.loadFromDisk(storeFile);
        }
        catch (FileNotFoundException e) {
            if (!createIfNecessary) {
                throw new RecordStoreNotFoundException();
            }
            recordStoreImpl = new RecordStoreImpl((RecordStoreManager)this, recordStoreName);
            suiteFolder.mkdirs();
            FileRecordStoreManager.saveToDisk(storeFile, recordStoreImpl);
        }
        recordStoreImpl.setOpen(true);
        this.testOpenRecordStores.put(storeFile.getName(), recordStoreImpl);
        return recordStoreImpl;
    }

    public String[] listRecordStores() {
        File suiteFolder = new File(Config.getConfigPath(), "suite-" + this.launcher.getSuiteName());
        String[] result = suiteFolder.list(this.filter);
        if (result != null) {
            if (result.length == 0) {
                result = null;
            } else {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = result[i].substring(0, result[i].length() - RECORD_STORE_SUFFIX.length());
                }
            }
        }
        return result;
    }

    public void saveChanges(RecordStoreImpl recordStoreImpl) throws RecordStoreNotOpenException {
        File suiteFolder = new File(Config.getConfigPath(), "suite-" + this.launcher.getSuiteName());
        File storeFile = new File(suiteFolder, recordStoreImpl.getName() + RECORD_STORE_SUFFIX);
        FileRecordStoreManager.saveToDisk(storeFile, recordStoreImpl);
    }

    public void init() {
    }

    public void deleteStores() {
        String[] stores = this.listRecordStores();
        for (int i = 0; i < stores.length; ++i) {
            String store = stores[i];
            try {
                this.deleteRecordStore(store);
                continue;
            }
            catch (RecordStoreException e) {
                e.printStackTrace();
            }
        }
    }

    private RecordStoreImpl loadFromDisk(File recordStoreFile) throws FileNotFoundException {
        RecordStoreImpl store = null;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(recordStoreFile));
            store = new RecordStoreImpl((RecordStoreManager)this, dis);
            dis.close();
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            System.out.println("RecordStore.loadFromDisk: ERROR reading " + recordStoreFile.getName());
            ex.printStackTrace();
        }
        return store;
    }

    private static void saveToDisk(File recordStoreFile, RecordStoreImpl recordStore) {
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(recordStoreFile));
            recordStore.write(dos);
            dos.close();
        }
        catch (IOException ex) {
            System.out.println("RecordStore.saveToDisk: ERROR writting object to " + recordStoreFile.getName());
            ex.printStackTrace();
        }
    }

    public int getSizeAvailable(RecordStoreImpl recordStoreImpl) {
        return 0x100000;
    }
}

