/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.microedition.lcdui.Displayable;
import org.microemu.DisplayAccess;
import org.microemu.DisplayComponent;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.DisplayRepaintListener;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.MutableImage;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEMutableImage;

public class SwingDisplayComponent
implements DisplayComponent {
    private Component deviceCanvas;
    private J2SEMutableImage displayImage = null;
    private DisplayRepaintListener displayRepaintListener;

    SwingDisplayComponent(Component deviceCanvas) {
        this.deviceCanvas = deviceCanvas;
    }

    public void init() {
        this.displayImage = null;
    }

    public void addDisplayRepaintListener(DisplayRepaintListener l) {
        this.displayRepaintListener = l;
    }

    public void removeDisplayRepaintListener(DisplayRepaintListener l) {
        if (this.displayRepaintListener == l) {
            this.displayRepaintListener = null;
        }
    }

    public MutableImage getDisplayImage() {
        return this.displayImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.displayImage != null) {
            J2SEMutableImage j2SEMutableImage = this.displayImage;
            synchronized (j2SEMutableImage) {
                g.drawImage(this.displayImage.getImage(), 0, 0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int x, int y, int width, int height) {
        MIDletAccess ma = MIDletBridge.getMIDletAccess();
        if (ma == null) {
            return;
        }
        DisplayAccess da = ma.getDisplayAccess();
        if (da == null) {
            return;
        }
        Displayable current = da.getCurrent();
        if (current == null) {
            return;
        }
        Device device = DeviceFactory.getDevice();
        if (device != null) {
            if (this.displayImage == null) {
                this.displayImage = new J2SEMutableImage(device.getDeviceDisplay().getFullWidth(), device.getDeviceDisplay().getFullHeight());
            }
            J2SEMutableImage j2SEMutableImage = this.displayImage;
            synchronized (j2SEMutableImage) {
                Graphics gc = this.displayImage.getImage().getGraphics();
                J2SEDeviceDisplay deviceDisplay = (J2SEDeviceDisplay)device.getDeviceDisplay();
                deviceDisplay.paintDisplayable(gc, x, y, width, height);
                if (!deviceDisplay.isFullScreenMode()) {
                    deviceDisplay.paintControls(gc);
                }
            }
            this.fireDisplayRepaint(this.displayImage);
        }
        this.deviceCanvas.repaint();
    }

    private void fireDisplayRepaint(MutableImage image) {
        if (this.displayRepaintListener != null) {
            this.displayRepaintListener.repaintInvoked(image);
        }
    }
}

