/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.ui.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.microedition.lcdui.Command;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.microemu.CommandManager;
import org.microemu.DisplayComponent;
import org.microemu.MIDletBridge;
import org.microemu.app.ui.swing.SwingDisplayComponent;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.impl.InputMethodImpl;
import org.microemu.device.impl.Polygon;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.j2se.J2SEButton;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEImmutableImage;
import org.microemu.device.j2se.J2SEInputMethod;

public class SwingDeviceComponent
extends JPanel
implements KeyListener {
    private static final long serialVersionUID = 1L;
    SwingDeviceComponent instance;
    SwingDisplayComponent dc;
    J2SEButton prevOverButton;
    J2SEButton overButton;
    J2SEButton pressedButton;
    private SoftButton initialPressedSoftButton = null;
    Image offi;
    Graphics offg;
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            SwingDeviceComponent.this.requestFocus();
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            Device device = DeviceFactory.getDevice();
            Rectangle rect = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
            J2SEInputMethod inputMethod = (J2SEInputMethod)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (rect.x <= e.getX() && rect.x + rect.width > e.getX() && rect.y <= e.getY() && rect.y + rect.height > e.getY()) {
                if (device.hasPointerEvents()) {
                    if (!fullScreenMode) {
                        Iterator it = device.getSoftButtons().iterator();
                        while (it.hasNext()) {
                            Rectangle pb;
                            SoftButton button = (SoftButton)it.next();
                            if (!button.isVisible() || (pb = button.getPaintable()) == null || !pb.contains(e.getX() - rect.x, e.getY() - rect.y)) continue;
                            SwingDeviceComponent.this.initialPressedSoftButton = button;
                            button.setPressed(true);
                            SwingDeviceComponent.this.dc.repaint(pb.x, pb.y, pb.width, pb.height);
                            break;
                        }
                    }
                    if (fullScreenMode) {
                        inputMethod.pointerPressed(e.getX() - rect.x, e.getY() - rect.y);
                    } else {
                        Rectangle pb = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayPaintable();
                        inputMethod.pointerPressed(e.getX() - rect.x - pb.x, e.getY() - rect.y - pb.y);
                    }
                }
            } else {
                SwingDeviceComponent.this.pressedButton = SwingDeviceComponent.this.getButton(e.getX(), e.getY());
                if (SwingDeviceComponent.this.pressedButton != null) {
                    if (SwingDeviceComponent.this.pressedButton instanceof SoftButton && !fullScreenMode) {
                        Command cmd = ((SoftButton)((Object)SwingDeviceComponent.this.pressedButton)).getCommand();
                        if (cmd != null) {
                            CommandManager.getInstance().commandAction(cmd);
                        }
                    } else {
                        int key = SwingDeviceComponent.this.pressedButton.getKeyCode();
                        KeyEvent ev = new KeyEvent(SwingDeviceComponent.this.instance, 0, 0L, 0, key, '\uffff');
                        inputMethod.mousePressed(ev);
                    }
                    Rectangle r = SwingDeviceComponent.this.pressedButton.getShape().getBounds();
                    SwingDeviceComponent.this.repaint(r.x, r.y, r.width, r.height);
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (MIDletBridge.getCurrentMIDlet() == null) {
                return;
            }
            Device device = DeviceFactory.getDevice();
            Rectangle rect = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
            J2SEInputMethod inputMethod = (J2SEInputMethod)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (rect.x <= e.getX() && rect.x + rect.width > e.getX() && rect.y <= e.getY() && rect.y + rect.height > e.getY()) {
                if (device.hasPointerEvents()) {
                    Rectangle pb;
                    if (!fullScreenMode) {
                        if (SwingDeviceComponent.this.initialPressedSoftButton != null && SwingDeviceComponent.this.initialPressedSoftButton.isPressed()) {
                            SwingDeviceComponent.this.initialPressedSoftButton.setPressed(false);
                            pb = SwingDeviceComponent.this.initialPressedSoftButton.getPaintable();
                            if (pb != null) {
                                Command cmd;
                                SwingDeviceComponent.this.dc.repaint(pb.x, pb.y, pb.width, pb.height);
                                if (pb.contains(e.getX() - rect.x, e.getY() - rect.y) && (cmd = SwingDeviceComponent.this.initialPressedSoftButton.getCommand()) != null) {
                                    CommandManager.getInstance().commandAction(cmd);
                                }
                            }
                        }
                        SwingDeviceComponent.this.initialPressedSoftButton = null;
                    }
                    if (fullScreenMode) {
                        inputMethod.pointerReleased(e.getX() - rect.x, e.getY() - rect.y);
                    } else {
                        pb = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayPaintable();
                        inputMethod.pointerReleased(e.getX() - rect.x - pb.x, e.getY() - rect.y - pb.y);
                    }
                }
            } else {
                J2SEButton prevOverButton = SwingDeviceComponent.this.getButton(e.getX(), e.getY());
                if (prevOverButton != null) {
                    int key = prevOverButton.getKeyCode();
                    KeyEvent ev = new KeyEvent(SwingDeviceComponent.this.instance, 0, 0L, 0, key, '\uffff');
                    inputMethod.mouseReleased(ev.getKeyCode());
                }
                SwingDeviceComponent.this.pressedButton = null;
                if (prevOverButton != null) {
                    Rectangle r = prevOverButton.getShape().getBounds();
                    SwingDeviceComponent.this.repaint(r.x, r.y, r.width, r.height);
                } else {
                    SwingDeviceComponent.this.repaint();
                }
            }
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        public void mouseDragged(MouseEvent e) {
            SwingDeviceComponent.this.overButton = SwingDeviceComponent.this.getButton(e.getX(), e.getY());
            Device device = DeviceFactory.getDevice();
            Rectangle rect = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
            InputMethodImpl inputMethod = (InputMethodImpl)device.getInputMethod();
            boolean fullScreenMode = device.getDeviceDisplay().isFullScreenMode();
            if (rect.x <= e.getX() && rect.x + rect.width > e.getX() && rect.y <= e.getY() && rect.y + rect.height > e.getY() && device.hasPointerMotionEvents()) {
                Rectangle pb;
                if (!fullScreenMode && SwingDeviceComponent.this.initialPressedSoftButton != null && (pb = SwingDeviceComponent.this.initialPressedSoftButton.getPaintable()) != null) {
                    if (pb.contains(e.getX() - rect.x, e.getY() - rect.y)) {
                        if (!SwingDeviceComponent.this.initialPressedSoftButton.isPressed()) {
                            SwingDeviceComponent.this.initialPressedSoftButton.setPressed(true);
                            SwingDeviceComponent.this.dc.repaint(pb.x, pb.y, pb.width, pb.height);
                        }
                    } else if (SwingDeviceComponent.this.initialPressedSoftButton.isPressed()) {
                        SwingDeviceComponent.this.initialPressedSoftButton.setPressed(false);
                        SwingDeviceComponent.this.dc.repaint(pb.x, pb.y, pb.width, pb.height);
                    }
                }
                if (fullScreenMode) {
                    inputMethod.pointerDragged(e.getX() - rect.x, e.getY() - rect.y);
                } else {
                    pb = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayPaintable();
                    inputMethod.pointerDragged(e.getX() - rect.x - pb.x, e.getY() - rect.y - pb.y);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            SwingDeviceComponent.this.prevOverButton = SwingDeviceComponent.this.overButton;
            SwingDeviceComponent.this.overButton = SwingDeviceComponent.this.getButton(e.getX(), e.getY());
            if (SwingDeviceComponent.this.overButton != SwingDeviceComponent.this.prevOverButton) {
                Rectangle r;
                if (SwingDeviceComponent.this.prevOverButton != null) {
                    r = SwingDeviceComponent.this.prevOverButton.getShape().getBounds();
                    SwingDeviceComponent.this.repaint(r.x, r.y, r.width, r.height);
                }
                if (SwingDeviceComponent.this.overButton != null) {
                    r = SwingDeviceComponent.this.overButton.getShape().getBounds();
                    SwingDeviceComponent.this.repaint(r.x, r.y, r.width, r.height);
                }
            }
        }
    };

    public SwingDeviceComponent() {
        this.instance = this;
        this.dc = new SwingDisplayComponent(this);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseMotionListener);
    }

    public DisplayComponent getDisplayComponent() {
        return this.dc;
    }

    public void init() {
        this.dc.init();
        this.revalidate();
    }

    public void keyTyped(KeyEvent ev) {
        if (MIDletBridge.getCurrentMIDlet() == null) {
            return;
        }
        ((J2SEInputMethod)DeviceFactory.getDevice().getInputMethod()).keyTyped(ev);
    }

    public void keyPressed(KeyEvent ev) {
        if (MIDletBridge.getCurrentMIDlet() == null) {
            return;
        }
        Device device = DeviceFactory.getDevice();
        J2SEInputMethod inputMethod = (J2SEInputMethod)device.getInputMethod();
        if (ev.getKeyCode() == 86 && (ev.getModifiers() & 2) != 0) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            if (transferable != null) {
                try {
                    Object data = transferable.getTransferData(DataFlavor.stringFlavor);
                    if (data instanceof String) {
                        inputMethod.clipboardPaste((String)data);
                    }
                }
                catch (UnsupportedFlavorException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        switch (ev.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: {
                return;
            }
        }
        Iterator it = device.getButtons().iterator();
        while (it.hasNext()) {
            J2SEButton button = (J2SEButton)it.next();
            if (ev.getKeyCode() != button.getKeyboardKey()) continue;
            ev.setKeyCode(button.getKeyCode());
            break;
        }
        inputMethod.keyPressed(ev);
        this.pressedButton = inputMethod.getButton(ev);
        if (this.pressedButton != null) {
            org.microemu.device.impl.Shape shape = this.pressedButton.getShape();
            if (shape != null) {
                Rectangle r = shape.getBounds();
                this.repaint(r.x, r.y, r.width, r.height);
            }
        } else {
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent ev) {
        if (MIDletBridge.getCurrentMIDlet() == null) {
            return;
        }
        switch (ev.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: {
                return;
            }
        }
        Device device = DeviceFactory.getDevice();
        Iterator it = device.getButtons().iterator();
        while (it.hasNext()) {
            J2SEButton button = (J2SEButton)it.next();
            if (ev.getKeyCode() != button.getKeyboardKey()) continue;
            ev.setKeyCode(button.getKeyCode());
            break;
        }
        ((J2SEInputMethod)device.getInputMethod()).keyReleased(ev);
        this.prevOverButton = this.pressedButton;
        this.pressedButton = null;
        if (this.prevOverButton != null) {
            org.microemu.device.impl.Shape shape = this.prevOverButton.getShape();
            if (shape != null) {
                Rectangle r = shape.getBounds();
                this.repaint(r.x, r.y, r.width, r.height);
            }
        } else {
            this.repaint();
        }
    }

    public MouseListener getDefaultMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getDefaultMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public void paint(Graphics g) {
        org.microemu.device.impl.Shape shape;
        if (this.offg == null || this.offi.getWidth(null) != this.getSize().width || this.offi.getHeight(null) != this.getSize().height) {
            this.offi = this.createImage(this.getSize().width, this.getSize().height);
            this.offg = this.offi.getGraphics();
        }
        Dimension size = this.getSize();
        this.offg.setColor(UIManager.getColor("text"));
        this.offg.fillRect(0, 0, size.width, size.height);
        Device device = DeviceFactory.getDevice();
        if (device == null) {
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            return;
        }
        this.offg.drawImage(((J2SEImmutableImage)device.getNormalImage()).getImage(), 0, 0, this);
        Rectangle displayRectangle = ((J2SEDeviceDisplay)device.getDeviceDisplay()).getDisplayRectangle();
        this.offg.translate(displayRectangle.x, displayRectangle.y);
        this.dc.paint(this.offg);
        this.offg.translate(-displayRectangle.x, -displayRectangle.y);
        if (this.prevOverButton != null) {
            shape = this.prevOverButton.getShape();
            if (shape != null) {
                this.drawImageInShape(this.offg, ((J2SEImmutableImage)device.getNormalImage()).getImage(), shape);
            }
            this.prevOverButton = null;
        }
        if (this.overButton != null && (shape = this.overButton.getShape()) != null) {
            this.drawImageInShape(this.offg, ((J2SEImmutableImage)device.getOverImage()).getImage(), shape);
        }
        if (this.pressedButton != null && (shape = this.pressedButton.getShape()) != null) {
            this.drawImageInShape(this.offg, ((J2SEImmutableImage)device.getPressedImage()).getImage(), shape);
        }
        g.drawImage(this.offi, 0, 0, null);
    }

    private void drawImageInShape(Graphics g, Image image, org.microemu.device.impl.Shape shape) {
        Shape clipSave = g.getClip();
        if (shape instanceof Polygon) {
            java.awt.Polygon poly = new java.awt.Polygon(((Polygon)shape).xpoints, ((Polygon)shape).ypoints, ((Polygon)shape).npoints);
            g.setClip(poly);
        }
        Rectangle r = shape.getBounds();
        g.drawImage(image, r.x, r.y, r.x + r.width, r.y + r.height, r.x, r.y, r.x + r.width, r.y + r.height, null);
        g.setClip(clipSave);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private J2SEButton getButton(int x, int y) {
        Enumeration e = DeviceFactory.getDevice().getButtons().elements();
        while (e.hasMoreElements()) {
            J2SEButton button = (J2SEButton)e.nextElement();
            if (button.getShape() == null) continue;
            try {
                org.microemu.device.impl.Shape tmp = (org.microemu.device.impl.Shape)button.getShape().clone();
                if (!tmp.contains(x, y)) continue;
                return button;
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Dimension getPreferredSize() {
        javax.microedition.lcdui.Image img = DeviceFactory.getDevice().getNormalImage();
        return new Dimension(img.getWidth(), img.getHeight());
    }
}

