/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.microemu.DisplayComponent;
import org.microemu.EmulatorContext;
import org.microemu.MIDletBridge;
import org.microemu.app.Common;
import org.microemu.app.Config;
import org.microemu.app.ui.ResponseInterfaceListener;
import org.microemu.app.ui.StatusBarListener;
import org.microemu.app.ui.swing.ExtensionFileFilter;
import org.microemu.app.ui.swing.SwingDeviceComponent;
import org.microemu.app.ui.swing.SwingDialogWindow;
import org.microemu.app.ui.swing.SwingSelectDevicePanel;
import org.microemu.app.util.DeviceEntry;
import org.microemu.device.Device;
import org.microemu.device.DeviceDisplay;
import org.microemu.device.DeviceFactory;
import org.microemu.device.FontManager;
import org.microemu.device.InputMethod;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEFontManager;
import org.microemu.device.j2se.J2SEInputMethod;

public class WebStart
extends JFrame {
    private WebStart instance = null;
    protected Common common;
    private SwingSelectDevicePanel selectDevicePanel = null;
    private JFileChooser fileChooser = null;
    private JMenuItem menuOpenJADFile;
    private JMenuItem menuOpenJADURL;
    private JMenuItem menuSelectDevice;
    private SwingDeviceComponent devicePanel;
    private DeviceEntry deviceEntry;
    private JLabel statusBar = new JLabel("Status");
    private EmulatorContext emulatorContext = new EmulatorContext(){
        private InputMethod inputMethod = new J2SEInputMethod();
        private DeviceDisplay deviceDisplay = new J2SEDeviceDisplay(this);
        private FontManager fontManager = new J2SEFontManager();

        public DisplayComponent getDisplayComponent() {
            return WebStart.this.devicePanel.getDisplayComponent();
        }

        public InputMethod getDeviceInputMethod() {
            return this.inputMethod;
        }

        public DeviceDisplay getDeviceDisplay() {
            return this.deviceDisplay;
        }

        public FontManager getDeviceFontManager() {
            return this.fontManager;
        }
    };
    private ActionListener menuOpenJADFileListener = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            int returnVal;
            if (WebStart.this.fileChooser == null) {
                ExtensionFileFilter fileFilter = new ExtensionFileFilter("JAD files");
                fileFilter.addExtension("jad");
                WebStart.this.fileChooser = new JFileChooser();
                WebStart.this.fileChooser.setFileFilter(fileFilter);
                WebStart.this.fileChooser.setDialogTitle("Open JAD File...");
                WebStart.this.fileChooser.setCurrentDirectory(new File(Config.getRecentJadDirectory()));
            }
            if ((returnVal = WebStart.this.fileChooser.showOpenDialog(WebStart.this.instance)) == 0) {
                try {
                    Config.setRecentJadDirectory(WebStart.this.fileChooser.getCurrentDirectory().getAbsolutePath());
                    Config.saveConfig();
                    Common.openJadUrl(WebStart.this.fileChooser.getSelectedFile().toURL().toString());
                }
                catch (IOException ex) {
                    System.err.println("Cannot load " + WebStart.this.fileChooser.getSelectedFile().getName());
                }
            }
        }
    };
    private ActionListener menuOpenJADURLListener = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            String entered = JOptionPane.showInputDialog(WebStart.this.instance, (Object)"Enter JAD URL:");
            if (entered != null) {
                try {
                    Common.openJadUrl(entered);
                }
                catch (IOException ex) {
                    System.err.println("Cannot load " + entered);
                }
            }
        }
    };
    private ActionListener menuExitListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Config.setWindowX(WebStart.this.getX());
            Config.setWindowY(WebStart.this.getY());
            Config.saveConfig();
            System.exit(0);
        }
    };
    private ActionListener menuSelectDeviceListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (SwingDialogWindow.show(WebStart.this.instance, "Select device...", WebStart.this.selectDevicePanel)) {
                if (WebStart.this.selectDevicePanel.getSelectedDeviceEntry().equals(WebStart.this.deviceEntry)) {
                    return;
                }
                if (MIDletBridge.getCurrentMIDlet() != WebStart.this.common.getLauncher() && JOptionPane.showConfirmDialog(WebStart.this.instance, "Changing device needs MIDlet to be restarted. All MIDlet data will be lost. Are you sure?", "Question?", 0, 3) != 0) {
                    return;
                }
                WebStart.this.setDevice(WebStart.this.selectDevicePanel.getSelectedDeviceEntry());
                if (MIDletBridge.getCurrentMIDlet() != WebStart.this.common.getLauncher()) {
                    try {
                        WebStart.this.common.startMidlet(MIDletBridge.getCurrentMIDlet().getClass(), MIDletBridge.getMIDletAccess());
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                } else {
                    WebStart.this.common.startLauncher(MIDletBridge.getMIDletAccess());
                }
            }
        }
    };
    private StatusBarListener statusBarListener = new StatusBarListener(){

        public void statusBarChanged(String text) {
            WebStart.this.statusBar.setText(text);
        }
    };
    private ResponseInterfaceListener responseInterfaceListener = new ResponseInterfaceListener(){

        public void stateChanged(boolean state) {
            WebStart.this.menuOpenJADFile.setEnabled(state);
            WebStart.this.menuOpenJADURL.setEnabled(state);
            WebStart.this.menuSelectDevice.setEnabled(state);
        }
    };
    private WindowAdapter windowListener = new WindowAdapter(){

        public void windowClosing(WindowEvent ev) {
            WebStart.this.menuExitListener.actionPerformed(null);
        }

        public void windowIconified(WindowEvent ev) {
            MIDletBridge.getMIDletAccess(MIDletBridge.getCurrentMIDlet()).pauseApp();
        }

        public void windowDeiconified(WindowEvent ev) {
            try {
                MIDletBridge.getMIDletAccess(MIDletBridge.getCurrentMIDlet()).startApp();
            }
            catch (MIDletStateChangeException ex) {
                System.err.println(ex);
            }
        }
    };

    public WebStart() {
        this((DeviceEntry)null);
    }

    public WebStart(DeviceEntry defaultDevice) {
        this.instance = this;
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        this.menuOpenJADFile = new JMenuItem("Open JAD File...");
        this.menuOpenJADFile.addActionListener(this.menuOpenJADFileListener);
        menuFile.add(this.menuOpenJADFile);
        this.menuOpenJADURL = new JMenuItem("Open JAD URL...");
        this.menuOpenJADURL.addActionListener(this.menuOpenJADURLListener);
        menuFile.add(this.menuOpenJADURL);
        menuFile.addSeparator();
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.addActionListener(this.menuExitListener);
        menuFile.add(menuItem);
        JMenu menuOptions = new JMenu("Options");
        this.menuSelectDevice = new JMenuItem("Select device...");
        this.menuSelectDevice.addActionListener(this.menuSelectDeviceListener);
        menuOptions.add(this.menuSelectDevice);
        menuBar.add(menuFile);
        menuBar.add(menuOptions);
        this.setJMenuBar(menuBar);
        this.setTitle("MicroEmulator");
        this.addWindowListener(this.windowListener);
        try {
            Config.loadConfig(defaultDevice, this.emulatorContext);
        }
        catch (SecurityException e) {
            System.out.println("Cannot load config in webstart untrusted environment:" + e);
        }
        this.setLocation(Config.getWindowX(), Config.getWindowY());
        this.devicePanel = new SwingDeviceComponent();
        this.addKeyListener(this.devicePanel);
        this.selectDevicePanel = new SwingSelectDevicePanel(this.emulatorContext);
        this.common = new Common(this.emulatorContext);
        this.common.setStatusBarListener(this.statusBarListener);
        this.common.setResponseInterfaceListener(this.responseInterfaceListener);
        this.getContentPane().add((Component)this.devicePanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    public void setDevice(DeviceEntry entry) {
        if (DeviceFactory.getDevice() != null) {
            // empty if block
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (entry.getFileName() != null) {
                URL[] urls = new URL[]{new File(Config.getConfigPath(), entry.getFileName()).toURL()};
                classLoader = new URLClassLoader(urls);
            }
            this.emulatorContext.getDeviceFontManager().init();
            Device device = Device.create(this.emulatorContext, classLoader, entry.getDescriptorLocation());
            this.deviceEntry = entry;
            this.common.setDevice(device);
            this.updateDevice();
        }
        catch (MalformedURLException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    protected void updateDevice() {
        this.devicePanel.init();
        this.devicePanel.addKeyListener(this.devicePanel);
        Image tmpImg = this.common.getDevice().getNormalImage();
        Dimension size = new Dimension(tmpImg.getWidth(), tmpImg.getHeight());
        size.width += 10;
        size.height += this.statusBar.getPreferredSize().height + 55;
        this.setSize(size);
        this.doLayout();
    }

    public static void main(String[] args) {
        Class<?> uiClass = null;
        int uiFontSize = 11;
        try {
            uiClass = Class.forName(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (uiClass != null) {
            try {
                LookAndFeel customUI = (LookAndFeel)uiClass.newInstance();
                UIManager.setLookAndFeel(customUI);
            }
            catch (Exception e) {
                System.out.println("ERR_UIError");
            }
        } else {
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception ex) {
                System.out.println("Failed loading Metal look and feel");
                System.out.println(ex);
                uiFontSize = 11;
            }
        }
        if (uiFontSize > 0) {
            Font dialogPlain = new Font("Dialog", 0, uiFontSize);
            Font serifPlain = new Font("Serif", 0, uiFontSize);
            Font sansSerifPlain = new Font("SansSerif", 0, uiFontSize);
            Font monospacedPlain = new Font("Monospaced", 0, uiFontSize);
            UIManager.getDefaults().put("Button.font", dialogPlain);
            UIManager.getDefaults().put("ToggleButton.font", dialogPlain);
            UIManager.getDefaults().put("RadioButton.font", dialogPlain);
            UIManager.getDefaults().put("CheckBox.font", dialogPlain);
            UIManager.getDefaults().put("ColorChooser.font", dialogPlain);
            UIManager.getDefaults().put("ComboBox.font", dialogPlain);
            UIManager.getDefaults().put("Label.font", dialogPlain);
            UIManager.getDefaults().put("List.font", dialogPlain);
            UIManager.getDefaults().put("MenuBar.font", dialogPlain);
            UIManager.getDefaults().put("MenuItem.font", dialogPlain);
            UIManager.getDefaults().put("RadioButtonMenuItem.font", dialogPlain);
            UIManager.getDefaults().put("CheckBoxMenuItem.font", dialogPlain);
            UIManager.getDefaults().put("Menu.font", dialogPlain);
            UIManager.getDefaults().put("PopupMenu.font", dialogPlain);
            UIManager.getDefaults().put("OptionPane.font", dialogPlain);
            UIManager.getDefaults().put("Panel.font", dialogPlain);
            UIManager.getDefaults().put("ProgressBar.font", dialogPlain);
            UIManager.getDefaults().put("ScrollPane.font", dialogPlain);
            UIManager.getDefaults().put("Viewport.font", dialogPlain);
            UIManager.getDefaults().put("TabbedPane.font", dialogPlain);
            UIManager.getDefaults().put("Table.font", dialogPlain);
            UIManager.getDefaults().put("TableHeader.font", dialogPlain);
            UIManager.getDefaults().put("TextField.font", sansSerifPlain);
            UIManager.getDefaults().put("PasswordField.font", monospacedPlain);
            UIManager.getDefaults().put("TextArea.font", monospacedPlain);
            UIManager.getDefaults().put("TextPane.font", serifPlain);
            UIManager.getDefaults().put("EditorPane.font", serifPlain);
            UIManager.getDefaults().put("TitledBorder.font", dialogPlain);
            UIManager.getDefaults().put("ToolBar.font", dialogPlain);
            UIManager.getDefaults().put("ToolTip.font", sansSerifPlain);
            UIManager.getDefaults().put("Tree.font", dialogPlain);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            params.add(args[i]);
        }
        WebStart app = new WebStart();
        app.common.initDevice(params, app.selectDevicePanel.getSelectedDeviceEntry());
        app.updateDevice();
        app.common.initMIDlet(params, false);
        app.validate();
        app.setVisible(true);
    }
}

