/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.microemu.DisplayAccess;
import org.microemu.DisplayComponent;
import org.microemu.EmulatorContext;
import org.microemu.MIDletBridge;
import org.microemu.app.Common;
import org.microemu.app.Config;
import org.microemu.app.ui.ResponseInterfaceListener;
import org.microemu.app.ui.StatusBarListener;
import org.microemu.app.ui.swing.ExtensionFileFilter;
import org.microemu.app.ui.swing.JadUrlPanel;
import org.microemu.app.ui.swing.SwingDeviceComponent;
import org.microemu.app.ui.swing.SwingDialogWindow;
import org.microemu.app.ui.swing.SwingSelectDevicePanel;
import org.microemu.app.util.DeviceEntry;
import org.microemu.device.Device;
import org.microemu.device.DeviceDisplay;
import org.microemu.device.DeviceFactory;
import org.microemu.device.FontManager;
import org.microemu.device.InputMethod;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEFontManager;
import org.microemu.device.j2se.J2SEInputMethod;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Main instance = null;
    protected Common common;
    protected SwingSelectDevicePanel selectDevicePanel = null;
    private JadUrlPanel jadUrlPanel;
    private JFileChooser fileChooser = null;
    private JMenuItem menuOpenJADFile;
    private JMenuItem menuOpenJADURL;
    private JMenuItem menuSelectDevice;
    private SwingDeviceComponent devicePanel;
    private DeviceEntry deviceEntry;
    private JLabel statusBar = new JLabel("Status");
    protected EmulatorContext emulatorContext = new EmulatorContext(){
        private InputMethod inputMethod = new J2SEInputMethod();
        private DeviceDisplay deviceDisplay = new J2SEDeviceDisplay(this);
        private FontManager fontManager = new J2SEFontManager();

        public DisplayComponent getDisplayComponent() {
            return Main.this.devicePanel.getDisplayComponent();
        }

        public InputMethod getDeviceInputMethod() {
            return this.inputMethod;
        }

        public DeviceDisplay getDeviceDisplay() {
            return this.deviceDisplay;
        }

        public FontManager getDeviceFontManager() {
            return this.fontManager;
        }
    };
    private ActionListener menuOpenJADFileListener = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            int returnVal;
            if (Main.this.fileChooser == null) {
                ExtensionFileFilter fileFilter = new ExtensionFileFilter("JAD files");
                fileFilter.addExtension("jad");
                Main.this.fileChooser = new JFileChooser();
                Main.this.fileChooser.setFileFilter(fileFilter);
                Main.this.fileChooser.setDialogTitle("Open JAD File...");
                Main.this.fileChooser.setCurrentDirectory(new File(Config.getRecentJadDirectory()));
            }
            if ((returnVal = Main.this.fileChooser.showOpenDialog(Main.this.instance)) == 0) {
                try {
                    Config.setRecentJadDirectory(Main.this.fileChooser.getCurrentDirectory().getAbsolutePath());
                    Config.saveConfig();
                    Common.openJadUrl(Main.this.fileChooser.getSelectedFile().toURL().toString());
                }
                catch (IOException ex) {
                    System.err.println("Cannot load " + Main.this.fileChooser.getSelectedFile().getName());
                }
            }
        }
    };
    private ActionListener menuOpenJADURLListener = new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            if (SwingDialogWindow.show(Main.this, "Enter JAD URL:", Main.this.jadUrlPanel)) {
                try {
                    Common.openJadUrl(Main.this.jadUrlPanel.getText());
                }
                catch (IOException ex) {
                    System.err.println("Cannot load " + Main.this.jadUrlPanel.getText());
                }
            }
        }
    };
    private ActionListener menuCloseMidletListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (MIDletBridge.getCurrentMIDlet() != Main.this.common.getLauncher()) {
                Main.this.common.startLauncher(MIDletBridge.getMIDletAccess());
            }
        }
    };
    private ActionListener menuExitListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Config.setWindowX(Main.this.getX());
            Config.setWindowY(Main.this.getY());
            Config.saveConfig();
            System.exit(0);
        }
    };
    private ActionListener menuSelectDeviceListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (SwingDialogWindow.show(Main.this.instance, "Select device...", Main.this.selectDevicePanel)) {
                if (Main.this.selectDevicePanel.getSelectedDeviceEntry().equals(Main.this.deviceEntry)) {
                    return;
                }
                int restartMidlet = 1;
                if (MIDletBridge.getCurrentMIDlet() != Main.this.common.getLauncher()) {
                    restartMidlet = JOptionPane.showConfirmDialog(Main.this.instance, "Changing device may trigger MIDlet to the unpredictable state and restart of MIDlet is recommended. \nDo you want to restart the MIDlet? All MIDlet data will be lost.", "Question?", 0, 3);
                }
                Main.this.setDevice(Main.this.selectDevicePanel.getSelectedDeviceEntry());
                if (restartMidlet == 0) {
                    try {
                        Main.this.common.startMidlet(MIDletBridge.getCurrentMIDlet().getClass(), MIDletBridge.getMIDletAccess());
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                } else {
                    DeviceDisplay deviceDisplay = DeviceFactory.getDevice().getDeviceDisplay();
                    DisplayAccess da = MIDletBridge.getMIDletAccess().getDisplayAccess();
                    if (da != null) {
                        da.sizeChanged(deviceDisplay.getWidth(), deviceDisplay.getHeight());
                        deviceDisplay.repaint(0, 0, deviceDisplay.getFullWidth(), deviceDisplay.getFullHeight());
                    }
                }
            }
        }
    };
    private StatusBarListener statusBarListener = new StatusBarListener(){

        public void statusBarChanged(String text) {
            Main.this.statusBar.setText(text);
        }
    };
    private ResponseInterfaceListener responseInterfaceListener = new ResponseInterfaceListener(){

        public void stateChanged(boolean state) {
            Main.this.menuOpenJADFile.setEnabled(state);
            Main.this.menuOpenJADURL.setEnabled(state);
            Main.this.menuSelectDevice.setEnabled(state);
        }
    };
    private WindowAdapter windowListener = new WindowAdapter(){

        public void windowClosing(WindowEvent ev) {
            Main.this.menuExitListener.actionPerformed(null);
        }

        public void windowIconified(WindowEvent ev) {
            MIDletBridge.getMIDletAccess(MIDletBridge.getCurrentMIDlet()).pauseApp();
        }

        public void windowDeiconified(WindowEvent ev) {
            try {
                MIDletBridge.getMIDletAccess(MIDletBridge.getCurrentMIDlet()).startApp();
            }
            catch (MIDletStateChangeException ex) {
                System.err.println(ex);
            }
        }
    };

    public Main() {
        this((DeviceEntry)null);
    }

    public Main(DeviceEntry defaultDevice) {
        this.instance = this;
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        this.menuOpenJADFile = new JMenuItem("Open JAD File...");
        this.menuOpenJADFile.addActionListener(this.menuOpenJADFileListener);
        menuFile.add(this.menuOpenJADFile);
        this.menuOpenJADURL = new JMenuItem("Open JAD URL...");
        this.menuOpenJADURL.addActionListener(this.menuOpenJADURLListener);
        menuFile.add(this.menuOpenJADURL);
        JMenuItem menuItemTmp = new JMenuItem("Close MIDlet");
        menuItemTmp.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        menuItemTmp.addActionListener(this.menuCloseMidletListener);
        menuFile.add(menuItemTmp);
        menuFile.addSeparator();
        JMenuItem menuItem = new JMenuItem("Exit");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        menuItem.addActionListener(this.menuExitListener);
        menuFile.add(menuItem);
        JMenu menuOptions = new JMenu("Options");
        this.menuSelectDevice = new JMenuItem("Select device...");
        this.menuSelectDevice.addActionListener(this.menuSelectDeviceListener);
        menuOptions.add(this.menuSelectDevice);
        menuBar.add(menuFile);
        menuBar.add(menuOptions);
        this.setJMenuBar(menuBar);
        this.setTitle("MicroEmulator");
        this.addWindowListener(this.windowListener);
        Config.loadConfig(defaultDevice, this.emulatorContext);
        this.setLocation(Config.getWindowX(), Config.getWindowY());
        this.getContentPane().add(this.createContents(this.getContentPane()), "Center");
        this.selectDevicePanel = new SwingSelectDevicePanel(this.emulatorContext);
        this.jadUrlPanel = new JadUrlPanel();
        this.common = new Common(this.emulatorContext);
        this.common.setStatusBarListener(this.statusBarListener);
        this.common.setResponseInterfaceListener(this.responseInterfaceListener);
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    protected Component createContents(Container parent) {
        this.devicePanel = new SwingDeviceComponent();
        this.devicePanel.addKeyListener(this.devicePanel);
        this.addKeyListener(this.devicePanel);
        return this.devicePanel;
    }

    public void setDevice(DeviceEntry entry) {
        if (DeviceFactory.getDevice() != null) {
            // empty if block
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (entry.getFileName() != null) {
                URL[] urls = new URL[]{new File(Config.getConfigPath(), entry.getFileName()).toURL()};
                classLoader = new URLClassLoader(urls);
            }
            this.emulatorContext.getDeviceFontManager().init();
            Device device = Device.create(this.emulatorContext, classLoader, entry.getDescriptorLocation());
            this.deviceEntry = entry;
            this.common.setDevice(device);
            this.updateDevice();
        }
        catch (MalformedURLException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    protected void updateDevice() {
        this.devicePanel.init();
        this.pack();
    }

    public static void main(String[] args) {
        Class<?> uiClass = null;
        int uiFontSize = 11;
        try {
            uiClass = Class.forName(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (uiClass != null) {
            try {
                LookAndFeel customUI = (LookAndFeel)uiClass.newInstance();
                UIManager.setLookAndFeel(customUI);
            }
            catch (Exception e) {
                System.out.println("ERR_UIError");
            }
        } else {
            try {
                UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            }
            catch (Exception ex) {
                System.out.println("Failed loading Metal look and feel");
                System.out.println(ex);
                uiFontSize = 11;
            }
        }
        if (uiFontSize > 0) {
            Font dialogPlain = new Font("Dialog", 0, uiFontSize);
            Font serifPlain = new Font("Serif", 0, uiFontSize);
            Font sansSerifPlain = new Font("SansSerif", 0, uiFontSize);
            Font monospacedPlain = new Font("Monospaced", 0, uiFontSize);
            UIManager.getDefaults().put("Button.font", dialogPlain);
            UIManager.getDefaults().put("ToggleButton.font", dialogPlain);
            UIManager.getDefaults().put("RadioButton.font", dialogPlain);
            UIManager.getDefaults().put("CheckBox.font", dialogPlain);
            UIManager.getDefaults().put("ColorChooser.font", dialogPlain);
            UIManager.getDefaults().put("ComboBox.font", dialogPlain);
            UIManager.getDefaults().put("Label.font", dialogPlain);
            UIManager.getDefaults().put("List.font", dialogPlain);
            UIManager.getDefaults().put("MenuBar.font", dialogPlain);
            UIManager.getDefaults().put("MenuItem.font", dialogPlain);
            UIManager.getDefaults().put("RadioButtonMenuItem.font", dialogPlain);
            UIManager.getDefaults().put("CheckBoxMenuItem.font", dialogPlain);
            UIManager.getDefaults().put("Menu.font", dialogPlain);
            UIManager.getDefaults().put("PopupMenu.font", dialogPlain);
            UIManager.getDefaults().put("OptionPane.font", dialogPlain);
            UIManager.getDefaults().put("Panel.font", dialogPlain);
            UIManager.getDefaults().put("ProgressBar.font", dialogPlain);
            UIManager.getDefaults().put("ScrollPane.font", dialogPlain);
            UIManager.getDefaults().put("Viewport.font", dialogPlain);
            UIManager.getDefaults().put("TabbedPane.font", dialogPlain);
            UIManager.getDefaults().put("Table.font", dialogPlain);
            UIManager.getDefaults().put("TableHeader.font", dialogPlain);
            UIManager.getDefaults().put("TextField.font", sansSerifPlain);
            UIManager.getDefaults().put("PasswordField.font", monospacedPlain);
            UIManager.getDefaults().put("TextArea.font", monospacedPlain);
            UIManager.getDefaults().put("TextPane.font", serifPlain);
            UIManager.getDefaults().put("EditorPane.font", serifPlain);
            UIManager.getDefaults().put("TitledBorder.font", dialogPlain);
            UIManager.getDefaults().put("ToolBar.font", dialogPlain);
            UIManager.getDefaults().put("ToolTip.font", sansSerifPlain);
            UIManager.getDefaults().put("Tree.font", dialogPlain);
        }
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            params.add(args[i]);
        }
        Main app = new Main();
        app.common.initDevice(params, app.selectDevicePanel.getSelectedDeviceEntry());
        app.updateDevice();
        app.common.initMIDlet(params, false);
        app.validate();
        app.setVisible(true);
    }
}

