/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import nanoxml.XMLElement;
import nanoxml.XMLParseException;
import org.microemu.EmulatorContext;
import org.microemu.app.util.DeviceEntry;
import org.microemu.app.util.IOUtils;

public class Config {
    private static File configPath = Config.initConfigPath();
    private static XMLElement configXml;
    private static DeviceEntry defaultDevice;
    private static EmulatorContext emulatorContext;

    private static File initConfigPath() {
        try {
            return new File(System.getProperty("user.home") + "/.microemulator/");
        }
        catch (SecurityException e) {
            System.out.println("Cannot access user.home in webstart: " + e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfig(DeviceEntry defaultDevice, EmulatorContext emulatorContext) {
        Config.defaultDevice = defaultDevice;
        Config.emulatorContext = emulatorContext;
        File configFile = new File(configPath, "config2.xml");
        try {
            if (configFile.exists()) {
                Config.loadConfig("config2.xml", defaultDevice, emulatorContext);
            } else {
                Config.loadConfig("config.xml", defaultDevice, emulatorContext);
                Enumeration e = Config.getDeviceEntries().elements();
                while (e.hasMoreElements()) {
                    DeviceEntry entry = (DeviceEntry)e.nextElement();
                    if (!entry.canRemove()) continue;
                    Config.removeDeviceEntry(entry);
                    File src = new File(configPath, entry.getFileName());
                    File dst = File.createTempFile("dev", ".jar", configPath);
                    IOUtils.copyFile(src, dst);
                    entry.setFileName(dst.getName());
                    Config.addDeviceEntry(entry);
                }
                Config.saveConfig();
            }
        }
        catch (FileNotFoundException ex) {
            Config.loadDefaultConfig();
        }
        catch (IOException ex) {
            System.out.println(ex);
            Config.loadDefaultConfig();
        }
        finally {
            if (configXml == null) {
                Config.loadDefaultConfig();
            }
        }
        Config.initSystemProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig(String configFileName, DeviceEntry defaultDevice, EmulatorContext emulatorContext) throws IOException {
        File configFile = new File(configPath, configFileName);
        FileInputStream is = null;
        String xml = "";
        try {
            is = new FileInputStream(configFile);
            BufferedInputStream dis = new BufferedInputStream(is);
            while (((InputStream)dis).available() > 0) {
                byte[] b = new byte[((InputStream)dis).available()];
                ((InputStream)dis).read(b);
                xml = xml + new String(b);
            }
            Config.parseConfigXML(xml, defaultDevice, emulatorContext);
        }
        catch (XMLParseException e) {
            try {
                System.out.println(e);
                Config.loadDefaultConfig();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
        }
        IOUtils.closeQuietly(is);
    }

    private static void parseConfigXML(String xml, DeviceEntry defaultDevice, EmulatorContext emulatorContext) throws XMLParseException {
        configXml = new XMLElement();
        configXml.parseString(xml);
    }

    private static void loadDefaultConfig() {
        configXml = new XMLElement();
        configXml.setName("config");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig() {
        File configFile = new File(configPath, "config2.xml");
        configPath.mkdirs();
        FileWriter fw = null;
        try {
            fw = new FileWriter(configFile);
            configXml.write(fw);
            fw.close();
        }
        catch (IOException ex) {
            try {
                System.out.println(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly(fw);
        }
        IOUtils.closeQuietly(fw);
    }

    private static void initSystemProperties() {
        Properties systemProperties = null;
        Enumeration e = configXml.enumerateChildren();
        while (e.hasMoreElements()) {
            XMLElement tmp = (XMLElement)e.nextElement();
            if (!tmp.getName().equals("system-properties")) continue;
            systemProperties = new Properties();
            Enumeration e_prop = tmp.enumerateChildren();
            while (e_prop.hasMoreElements()) {
                XMLElement tmp_prop = (XMLElement)e_prop.nextElement();
                if (!tmp_prop.getName().equals("system-property")) continue;
                systemProperties.put(tmp_prop.getStringAttribute("name"), tmp_prop.getStringAttribute("value"));
            }
        }
        if (systemProperties == null) {
            systemProperties = new Properties();
            systemProperties.put("microedition.configuration", "CLDC-1.0");
            systemProperties.put("microedition.profiles", "MIDP-2.0");
            systemProperties.put("avetana.forceNativeLibrary", Boolean.TRUE.toString());
            XMLElement propertiesXml = configXml.getChild("system-properties");
            if (propertiesXml == null) {
                propertiesXml = configXml.addChild("system-properties");
            }
            Iterator<Map.Entry<Object, Object>> i = systemProperties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> e2 = i.next();
                XMLElement xmlProperty = propertiesXml.addChild("system-property");
                xmlProperty.setAttribute("value", (String)e2.getValue());
                xmlProperty.setAttribute("name", (String)e2.getKey());
            }
            Config.saveConfig();
        }
        try {
            Iterator<Map.Entry<Object, Object>> i = systemProperties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> e3 = i.next();
                System.setProperty((String)e3.getKey(), (String)e3.getValue());
            }
        }
        catch (SecurityException e2) {
            System.out.println("Cannot set SystemProperties: " + e2);
        }
    }

    public static File getConfigPath() {
        return configPath;
    }

    public static Vector getDeviceEntries() {
        Vector<DeviceEntry> result = new Vector<DeviceEntry>();
        if (defaultDevice == null) {
            defaultDevice = new DeviceEntry("Default device", null, "org/microemu/device/default/device.xml", true, false);
        }
        defaultDevice.setDefaultDevice(true);
        result.add(defaultDevice);
        XMLElement devicesXml = configXml.getChild("devices");
        if (devicesXml == null) {
            return result;
        }
        Enumeration e_device = devicesXml.enumerateChildren();
        while (e_device.hasMoreElements()) {
            XMLElement tmp_device = (XMLElement)e_device.nextElement();
            if (!tmp_device.getName().equals("device")) continue;
            boolean devDefault = false;
            if (tmp_device.getStringAttribute("default") != null && tmp_device.getStringAttribute("default").equals("true")) {
                devDefault = true;
                defaultDevice.setDefaultDevice(false);
            }
            String devName = tmp_device.getChildString("name", null);
            String devFile = tmp_device.getChildString("filename", null);
            String devClass = tmp_device.getChildString("class", null);
            String devDescriptor = tmp_device.getChildString("descriptor", null);
            if (devDescriptor == null) {
                result.add(new DeviceEntry(devName, devFile, devDefault, devClass, emulatorContext));
                continue;
            }
            result.add(new DeviceEntry(devName, devFile, devDescriptor, devDefault));
        }
        return result;
    }

    public static void addDeviceEntry(DeviceEntry entry) {
        Enumeration en = Config.getDeviceEntries().elements();
        while (en.hasMoreElements()) {
            DeviceEntry test = (DeviceEntry)en.nextElement();
            if (!test.getDescriptorLocation().equals(entry.getDescriptorLocation())) continue;
            return;
        }
        XMLElement devicesXml = configXml.getChild("devices");
        if (devicesXml == null) {
            devicesXml = configXml.addChild("devices");
        }
        XMLElement deviceXml = devicesXml.addChild("device");
        if (entry.isDefaultDevice()) {
            deviceXml.setAttribute("default", "true");
        }
        deviceXml.addChild("name", entry.getName());
        deviceXml.addChild("filename", entry.getFileName());
        deviceXml.addChild("descriptor", entry.getDescriptorLocation());
        Config.saveConfig();
    }

    public static void removeDeviceEntry(DeviceEntry entry) {
        XMLElement devicesXml = configXml.getChild("devices");
        if (devicesXml == null) {
            return;
        }
        Enumeration e_device = devicesXml.enumerateChildren();
        while (e_device.hasMoreElements()) {
            XMLElement tmp_device = (XMLElement)e_device.nextElement();
            if (!tmp_device.getName().equals("device")) continue;
            String testDescriptor = tmp_device.getChildString("descriptor", null);
            if (testDescriptor == null) {
                devicesXml.removeChild(tmp_device);
                Config.saveConfig();
                continue;
            }
            if (!testDescriptor.equals(entry.getDescriptorLocation())) continue;
            devicesXml.removeChild(tmp_device);
            Config.saveConfig();
            break;
        }
    }

    public static void changeDeviceEntry(DeviceEntry entry) {
        XMLElement devicesXml = configXml.getChild("devices");
        if (devicesXml == null) {
            return;
        }
        Enumeration e_device = devicesXml.enumerateChildren();
        while (e_device.hasMoreElements()) {
            String testDescriptor;
            XMLElement tmp_device = (XMLElement)e_device.nextElement();
            if (!tmp_device.getName().equals("device") || !(testDescriptor = tmp_device.getChildString("descriptor", null)).equals(entry.getDescriptorLocation())) continue;
            if (entry.isDefaultDevice()) {
                tmp_device.setAttribute("default", "true");
            } else {
                tmp_device.removeAttribute("default");
            }
            Config.saveConfig();
            break;
        }
    }

    public static int getWindowX() {
        int defaultResult = 0;
        XMLElement windowsXml = configXml.getChild("windows");
        if (windowsXml == null) {
            return defaultResult;
        }
        XMLElement mainXml = windowsXml.getChild("main");
        if (mainXml == null) {
            return defaultResult;
        }
        return mainXml.getChildInteger("x", defaultResult);
    }

    public static void setWindowX(int windowX) {
        XMLElement xXml;
        XMLElement mainXml;
        XMLElement windowsXml = configXml.getChild("windows");
        if (windowsXml == null) {
            windowsXml = configXml.addChild("windows");
        }
        if ((mainXml = windowsXml.getChild("main")) == null) {
            mainXml = windowsXml.addChild("main");
        }
        if ((xXml = mainXml.getChild("x")) == null) {
            xXml = mainXml.addChild("x");
        }
        xXml.setContent(String.valueOf(windowX));
        Config.saveConfig();
    }

    public static int getWindowY() {
        int defaultResult = 0;
        XMLElement windowsXml = configXml.getChild("windows");
        if (windowsXml == null) {
            return defaultResult;
        }
        XMLElement mainXml = windowsXml.getChild("main");
        if (mainXml == null) {
            return defaultResult;
        }
        return mainXml.getChildInteger("y", defaultResult);
    }

    public static void setWindowY(int windowY) {
        XMLElement yXml;
        XMLElement mainXml;
        XMLElement windowsXml = configXml.getChild("windows");
        if (windowsXml == null) {
            windowsXml = configXml.addChild("windows");
        }
        if ((mainXml = windowsXml.getChild("main")) == null) {
            mainXml = windowsXml.addChild("main");
        }
        if ((yXml = mainXml.getChild("y")) == null) {
            yXml = mainXml.addChild("y");
        }
        yXml.setContent(String.valueOf(windowY));
        Config.saveConfig();
    }

    public static String getRecentJadDirectory() {
        String defaultResult = ".";
        XMLElement filesXml = configXml.getChild("files");
        if (filesXml == null) {
            return defaultResult;
        }
        return filesXml.getChildString("recentJadDirectory", defaultResult);
    }

    public static void setRecentJadDirectory(String recentJadDirectory) {
        XMLElement recentJadDirectoryXml;
        XMLElement filesXml = configXml.getChild("files");
        if (filesXml == null) {
            filesXml = configXml.addChild("files");
        }
        if ((recentJadDirectoryXml = filesXml.getChild("recentJadDirectory")) == null) {
            recentJadDirectoryXml = filesXml.addChild("recentJadDirectory");
        }
        recentJadDirectoryXml.setContent(recentJadDirectory);
        Config.saveConfig();
    }
}

