/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import org.microemu.DisplayComponent;
import org.microemu.EmulatorContext;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.MIDletEntry;
import org.microemu.MicroEmulator;
import org.microemu.RecordStoreManager;
import org.microemu.app.Config;
import org.microemu.app.launcher.Launcher;
import org.microemu.app.ui.ResponseInterfaceListener;
import org.microemu.app.ui.StatusBarListener;
import org.microemu.app.ui.noui.NoUiDisplayComponent;
import org.microemu.app.util.DeviceEntry;
import org.microemu.app.util.FileRecordStoreManager;
import org.microemu.app.util.IOUtils;
import org.microemu.app.util.MIDletClassLoader;
import org.microemu.device.Device;
import org.microemu.device.DeviceDisplay;
import org.microemu.device.DeviceFactory;
import org.microemu.device.FontManager;
import org.microemu.device.InputMethod;
import org.microemu.device.j2se.J2SEDeviceDisplay;
import org.microemu.device.j2se.J2SEFontManager;
import org.microemu.device.j2se.J2SEInputMethod;
import org.microemu.util.Base64Coder;
import org.microemu.util.JadMidletEntry;
import org.microemu.util.JadProperties;
import org.microemu.util.MemoryRecordStoreManager;

public class Common
implements MicroEmulator {
    private static Common instance;
    private static Launcher launcher;
    private static StatusBarListener statusBarListener;
    protected EmulatorContext emulatorContext;
    protected JadProperties jad = new JadProperties();
    protected JadProperties manifest = new JadProperties();
    private RecordStoreManager recordStoreManager;
    private ResponseInterfaceListener responseInterfaceListener = null;

    public Common(EmulatorContext context) {
        instance = this;
        this.emulatorContext = context;
        launcher = new Launcher(this);
        launcher.setCurrentMIDlet(launcher);
        MIDletBridge.setMicroEmulator(this);
    }

    public RecordStoreManager getRecordStoreManager() {
        return this.recordStoreManager;
    }

    public void setRecordStoreManager(RecordStoreManager manager) {
        this.recordStoreManager = manager;
    }

    public String getAppProperty(String key) {
        if (key.equals("microedition.platform")) {
            return "MicroEmulator";
        }
        if (key.equals("microedition.profile")) {
            return "MIDP-1.0";
        }
        if (key.equals("microedition.configuration")) {
            return "CLDC-1.0";
        }
        if (key.equals("microedition.locale")) {
            return Locale.getDefault().getLanguage();
        }
        if (key.equals("microedition.encoding")) {
            return System.getProperty("file.encoding");
        }
        String result = this.jad.getProperty(key);
        if (result == null) {
            result = this.manifest.getProperty(key);
        }
        return result;
    }

    public void notifyDestroyed(MIDletAccess previousMidletAccess) {
        this.startLauncher(previousMidletAccess);
    }

    public Launcher getLauncher() {
        return launcher;
    }

    public void loadMidlet(String name, Class midletClass) {
        launcher.addMIDletEntry(new MIDletEntry(name, midletClass));
    }

    public static void dispose() {
        try {
            MIDletBridge.getMIDletAccess().destroyApp(true);
        }
        catch (MIDletStateChangeException ex) {
            ex.printStackTrace();
        }
        DeviceFactory.getDevice().getInputMethod().dispose();
    }

    public static void openJadUrl(String urlString) throws IOException {
        Common.openJadUrl(urlString, new MIDletClassLoader(instance.getClass().getClassLoader()));
    }

    public static void openJadUrl(String urlString, MIDletClassLoader midletClassLoader) throws IOException {
        try {
            URL url = new URL(urlString);
            Common.setStatusBar("Loading...");
            Common.getInstance().jad.clear();
            if (url.getUserInfo() == null) {
                Common.getInstance().jad.load(url.openStream());
            } else {
                URLConnection cn = url.openConnection();
                String userInfo = new String(Base64Coder.encode(url.getUserInfo().getBytes("UTF-8")));
                cn.setRequestProperty("Authorization", "Basic " + userInfo);
                Common.getInstance().jad.load(cn.getInputStream());
            }
            Common.getInstance().loadFromJad(url, midletClassLoader);
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            System.err.println("Cannot found " + urlString);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            System.err.println("Cannot open jad " + urlString);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            System.err.println("Cannot open jad " + urlString);
        }
    }

    public void startMidlet(Class midletClass, MIDletAccess previousMidletAccess) {
        try {
            MIDlet m = (MIDlet)midletClass.newInstance();
            if (previousMidletAccess != null) {
                previousMidletAccess.destroyApp(true);
            }
            MIDletBridge.getMIDletAccess(m).startApp();
            launcher.setCurrentMIDlet(m);
        }
        catch (InstantiationException ex) {
            this.handleStartMidletException(new MIDletStateChangeException(ex.getMessage()));
        }
        catch (IllegalAccessException ex) {
            this.handleStartMidletException(new MIDletStateChangeException(ex.getMessage()));
        }
        catch (MIDletStateChangeException ex) {
            this.handleStartMidletException(ex);
        }
    }

    protected void startLauncher(MIDletAccess previousMidletAccess) {
        try {
            if (previousMidletAccess != null) {
                previousMidletAccess.destroyApp(true);
            }
            MIDletBridge.getMIDletAccess(launcher).startApp();
            launcher.setCurrentMIDlet(launcher);
        }
        catch (MIDletStateChangeException ex) {
            this.handleStartMidletException(ex);
        }
    }

    public void setStatusBarListener(StatusBarListener listener) {
        statusBarListener = listener;
    }

    public boolean platformRequest(String URL2) {
        return false;
    }

    public void setResponseInterfaceListener(ResponseInterfaceListener listener) {
        this.responseInterfaceListener = listener;
    }

    protected void handleStartMidletException(MIDletStateChangeException ex) {
        ex.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromJad(URL jadUrl, MIDletClassLoader midletClassLoader) throws ClassNotFoundException {
        if (this.jad.getJarURL() == null) {
            throw new ClassNotFoundException("Cannot find MIDlet-Jar-URL property in jad");
        }
        MIDletAccess previousMidletAccess = MIDletBridge.getMIDletAccess();
        MIDletBridge.clear();
        this.setResponseInterface(false);
        URL url = null;
        try {
            url = new URL(this.jad.getJarURL());
        }
        catch (MalformedURLException ex) {
            try {
                String urlFullPath = jadUrl.toExternalForm();
                url = new URL(urlFullPath.substring(0, urlFullPath.lastIndexOf(47) + 1) + this.jad.getJarURL());
            }
            catch (MalformedURLException ex1) {
                ex1.printStackTrace();
                this.setResponseInterface(true);
            }
        }
        try {
            midletClassLoader.addURL(url);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(ex.getMessage());
        }
        launcher.removeMIDletEntries();
        this.manifest.clear();
        InputStream is = null;
        try {
            is = midletClassLoader.getResourceAsStream("/META-INF/MANIFEST.MF");
            this.manifest.load(is);
        }
        catch (IOException ex) {
            try {
                ex.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly(is);
        }
        IOUtils.closeQuietly(is);
        launcher.setSuiteName(this.jad.getSuiteName());
        Enumeration e = this.jad.getMidletEntries().elements();
        while (e.hasMoreElements()) {
            JadMidletEntry jadEntry = (JadMidletEntry)e.nextElement();
            Class<?> midletClass = midletClassLoader.loadClass(jadEntry.getClassName());
            this.loadMidlet(jadEntry.getName(), midletClass);
        }
        this.notifyDestroyed(previousMidletAccess);
        Common.setStatusBar("");
        this.setResponseInterface(true);
    }

    public Device getDevice() {
        return DeviceFactory.getDevice();
    }

    protected void setDevice(Device device) {
        DeviceFactory.setDevice(device);
    }

    private static Common getInstance() {
        return instance;
    }

    private static void setStatusBar(String text) {
        if (statusBarListener != null) {
            statusBarListener.statusBarChanged(text);
        }
    }

    private void setResponseInterface(boolean state) {
        if (this.responseInterfaceListener != null) {
            this.responseInterfaceListener.stateChanged(state);
        }
    }

    public static void main(String[] args) {
        Common app = new Common(new EmulatorContext(){
            private DisplayComponent displayComponent = new NoUiDisplayComponent();
            private InputMethod inputMethod = new J2SEInputMethod();
            private DeviceDisplay deviceDisplay = new J2SEDeviceDisplay(this);
            private FontManager fontManager = new J2SEFontManager();

            public DisplayComponent getDisplayComponent() {
                return this.displayComponent;
            }

            public InputMethod getDeviceInputMethod() {
                return this.inputMethod;
            }

            public DeviceDisplay getDeviceDisplay() {
                return this.deviceDisplay;
            }

            public FontManager getDeviceFontManager() {
                return this.fontManager;
            }
        });
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            params.add(args[i]);
        }
        DeviceEntry defaultDevice = new DeviceEntry("Default device", null, "org/microemu/device/default/device.xml", true, false);
        app.initDevice(params, defaultDevice);
        app.initMIDlet(params, false);
    }

    public void initDevice(List params, DeviceEntry defaultDevice) {
        RecordStoreManager paramRecordStoreManager = null;
        Class<?> deviceClass = null;
        String deviceDescriptorLocation = null;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            String tmp = (String)it.next();
            if (tmp.equals("-d") || tmp.equals("--device")) {
                it.remove();
                if (!it.hasNext()) continue;
                String tmpDevice = (String)it.next();
                it.remove();
                if (!tmpDevice.toLowerCase().endsWith(".xml")) {
                    try {
                        deviceClass = Class.forName(tmpDevice);
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                }
                if (deviceClass != null) continue;
                deviceDescriptorLocation = tmpDevice;
                continue;
            }
            if (!tmp.equals("--rms")) continue;
            it.remove();
            if (!it.hasNext()) continue;
            String tmpRms = (String)it.next();
            it.remove();
            if (tmpRms.equals("file")) {
                paramRecordStoreManager = new FileRecordStoreManager(launcher);
                continue;
            }
            if (!tmpRms.equals("memory")) continue;
            paramRecordStoreManager = new MemoryRecordStoreManager();
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (deviceDescriptorLocation != null) {
            try {
                this.setDevice(Device.create(this.emulatorContext, classLoader, deviceDescriptorLocation));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (DeviceFactory.getDevice() == null) {
            try {
                if (deviceClass == null) {
                    if (defaultDevice.getFileName() != null) {
                        URL[] urls = new URL[]{new File(Config.getConfigPath(), defaultDevice.getFileName()).toURL()};
                        classLoader = new URLClassLoader(urls);
                    }
                    this.setDevice(Device.create(this.emulatorContext, classLoader, defaultDevice.getDescriptorLocation()));
                } else {
                    Device device = (Device)deviceClass.newInstance();
                    device.init(this.emulatorContext);
                    this.setDevice(device);
                }
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.getRecordStoreManager() == null) {
            if (paramRecordStoreManager == null) {
                this.setRecordStoreManager(new FileRecordStoreManager(launcher));
            } else {
                this.setRecordStoreManager(paramRecordStoreManager);
            }
        }
    }

    public void initMIDlet(List params) {
        this.initMIDlet(params, false);
    }

    public void initMIDlet(List params, boolean startMidlet) {
        Class<?> midletClass = null;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Object url;
            String test = (String)it.next();
            it.remove();
            if (midletClass == null && test.endsWith(".jad")) {
                try {
                    File file = new File(test);
                    url = file.exists() ? file.toURL().toString() : test;
                    Common.openJadUrl((String)url);
                }
                catch (IOException exception) {
                    System.out.println("Cannot load " + test + " URL");
                }
                continue;
            }
            String resource = "/" + test.replace('.', '/') + ".class";
            url = this.getClass().getResource(resource);
            if (url != null) {
                String path = ((URL)url).toExternalForm();
                String basePath = path.substring(0, path.length() - resource.length());
                MIDletClassLoader classLoader = new MIDletClassLoader(instance.getClass().getClassLoader());
                try {
                    classLoader.addURL(new URL(basePath));
                    midletClass = classLoader.loadClass(test);
                }
                catch (ClassNotFoundException ignore) {
                }
                catch (MalformedURLException ignore) {
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (midletClass != null) continue;
            try {
                midletClass = Class.forName(test);
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Cannot find " + test + " MIDlet class");
            }
        }
        if (midletClass == null) {
            MIDletEntry entry = launcher.getSelectedMidletEntry();
            if (startMidlet && entry != null) {
                this.startMidlet(entry.getMIDletClass(), null);
            } else {
                this.startLauncher(null);
            }
        } else {
            this.startMidlet(midletClass, null);
        }
    }

    public static String usage() {
        return "[(-d | --device) ({device descriptor} | {device class name}) ] [--rms (file | memory)] ({midlet class name} | {jad file location})";
    }

    static {
        statusBarListener = null;
    }
}

