/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.StringComponent;
import javax.microedition.lcdui.Ticker;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;

public abstract class Displayable {
    protected Device device;
    Display currentDisplay = null;
    private Ticker ticker;
    protected StringComponent title;
    protected int viewPortY;
    protected int viewPortHeight;
    private Vector commands = new Vector();
    private CommandListener listener = null;

    Displayable(String title) {
        this.title = new StringComponent(title);
        this.device = DeviceFactory.getDevice();
    }

    public void addCommand(Command cmd) {
        for (int i = 0; i < this.commands.size(); ++i) {
            if (cmd != (Command)this.commands.elementAt(i)) continue;
            return;
        }
        boolean inserted = false;
        for (int i = 0; i < this.commands.size(); ++i) {
            if (cmd.getPriority() >= ((Command)this.commands.elementAt(i)).getPriority()) continue;
            this.commands.insertElementAt(cmd, i);
            inserted = true;
            break;
        }
        if (!inserted) {
            this.commands.addElement(cmd);
        }
        if (this.isShown()) {
            this.currentDisplay.updateCommands();
        }
    }

    public void removeCommand(Command cmd) {
        this.commands.removeElement(cmd);
        if (this.isShown()) {
            this.currentDisplay.updateCommands();
        }
    }

    public int getWidth() {
        return this.device.getDeviceDisplay().getWidth();
    }

    public int getHeight() {
        return this.device.getDeviceDisplay().getHeight();
    }

    public boolean isShown() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.isShown(this);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
        this.repaint();
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String s) {
        this.title.setText(s);
    }

    public void setCommandListener(CommandListener l) {
        this.listener = l;
    }

    protected void sizeChanged(int w, int h) {
    }

    CommandListener getCommandListener() {
        return this.listener;
    }

    Vector getCommands() {
        return this.commands;
    }

    void hideNotify() {
    }

    final void hideNotify(Display d) {
        this.hideNotify();
    }

    void keyPressed(int keyCode) {
    }

    void keyReleased(int keyCode) {
    }

    void pointerPressed(int x, int y) {
    }

    void pointerReleased(int x, int y) {
    }

    void pointerDragged(int x, int y) {
    }

    abstract void paint(Graphics var1);

    void repaint() {
        if (this.currentDisplay != null) {
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    void repaint(int x, int y, int width, int height) {
        if (this.currentDisplay != null) {
            this.currentDisplay.repaint(this, x, y, width, height);
        }
    }

    void showNotify() {
    }

    final void showNotify(Display d) {
        this.currentDisplay = d;
        this.viewPortY = 0;
        this.viewPortHeight = this.device.getDeviceDisplay().getHeight() - this.title.getHeight() - 1;
        if (this.ticker != null) {
            this.viewPortHeight -= this.ticker.getHeight();
        }
        this.showNotify();
    }
}

